/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestUmbilicalProtocolWithJobToken {
    private static final String ADDRESS = "0.0.0.0";
    public static final Log LOG = LogFactory.getLog(TestUmbilicalProtocolWithJobToken.class);
    private static Configuration conf = new Configuration();

    @Test
    public void testJobTokenRpc() throws Exception {
        TaskUmbilicalProtocol mockTT = (TaskUmbilicalProtocol)Mockito.mock(TaskUmbilicalProtocol.class);
        ((TaskUmbilicalProtocol)Mockito.doReturn((Object)19L).when((Object)mockTT)).getProtocolVersion(Matchers.anyString(), Matchers.anyLong());
        ((TaskUmbilicalProtocol)Mockito.doReturn((Object)ProtocolSignature.getProtocolSignature(mockTT, TaskUmbilicalProtocol.class.getName(), 19L, 0)).when((Object)mockTT)).getProtocolSignature(Matchers.anyString(), Matchers.anyLong(), Matchers.anyInt());
        JobTokenSecretManager sm = new JobTokenSecretManager();
        final RPC.Server server = new RPC.Builder(conf).setProtocol(TaskUmbilicalProtocol.class).setInstance(mockTT).setBindAddress(ADDRESS).setPort(0).setNumHandlers(5).setVerbose(true).setSecretManager(sm).build();
        server.start();
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        final InetSocketAddress addr = NetUtils.getConnectAddress(server);
        String jobId = current.getUserName();
        JobTokenIdentifier tokenId = new JobTokenIdentifier(new Text(jobId));
        Token<JobTokenIdentifier> token = new Token<JobTokenIdentifier>(tokenId, sm);
        sm.addTokenForJob(jobId, token);
        SecurityUtil.setTokenService(token, addr);
        LOG.info((Object)("Service address for token is " + token.getService()));
        current.addToken(token);
        current.doAs(new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                TaskUmbilicalProtocol proxy = null;
                try {
                    proxy = RPC.getProxy(TaskUmbilicalProtocol.class, 19L, addr, conf);
                    proxy.ping(null);
                }
                finally {
                    server.stop();
                    if (proxy != null) {
                        RPC.stopProxy(proxy);
                    }
                }
                return null;
            }
        });
    }

    static {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration(conf);
        ((Log4JLogger)Client.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)Server.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslInputStream.LOG).getLogger().setLevel(Level.ALL);
    }
}

