/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.token.delegation;

import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestDelegationToken {
    private MiniMRCluster cluster;
    private UserGroupInformation user1;
    private UserGroupInformation user2;

    @Before
    public void setup() throws Exception {
        this.user1 = UserGroupInformation.createUserForTesting("alice", new String[]{"users"});
        this.user2 = UserGroupInformation.createUserForTesting("bob", new String[]{"users"});
        this.cluster = new MiniMRCluster(0, 0, 1, "file:///", 1);
    }

    @Test
    public void testDelegationToken() throws Exception {
        final JobClient client = this.user1.doAs(new PrivilegedExceptionAction<JobClient>(){

            @Override
            public JobClient run() throws Exception {
                return new JobClient(TestDelegationToken.this.cluster.createJobConf());
            }
        });
        final JobClient bobClient = this.user2.doAs(new PrivilegedExceptionAction<JobClient>(){

            @Override
            public JobClient run() throws Exception {
                return new JobClient(TestDelegationToken.this.cluster.createJobConf());
            }
        });
        final Token<DelegationTokenIdentifier> token = client.getDelegationToken(new Text(this.user1.getUserName()));
        DataInputBuffer inBuf = new DataInputBuffer();
        byte[] bytes = token.getIdentifier();
        inBuf.reset(bytes, bytes.length);
        DelegationTokenIdentifier ident = new DelegationTokenIdentifier();
        ident.readFields(inBuf);
        Assert.assertEquals((Object)"alice", (Object)ident.getUser().getUserName());
        long createTime = ident.getIssueDate();
        long maxTime = ident.getMaxDate();
        long currentTime = System.currentTimeMillis();
        System.out.println("create time: " + createTime);
        System.out.println("current time: " + currentTime);
        System.out.println("max time: " + maxTime);
        Assert.assertTrue((String)"createTime < current", (createTime < currentTime ? 1 : 0) != 0);
        Assert.assertTrue((String)"current < maxTime", (currentTime < maxTime ? 1 : 0) != 0);
        this.user1.doAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                client.renewDelegationToken(token);
                client.renewDelegationToken(token);
                return null;
            }
        });
        this.user2.doAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    bobClient.renewDelegationToken(token);
                    Assert.fail((String)"bob renew");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                return null;
            }
        });
        this.user2.doAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    bobClient.cancelDelegationToken(token);
                    Assert.fail((String)"bob cancel");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                return null;
            }
        });
        this.user1.doAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                client.cancelDelegationToken(token);
                try {
                    client.cancelDelegationToken(token);
                    Assert.fail((String)"second alice cancel");
                }
                catch (SecretManager.InvalidToken invalidToken) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

