/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.FailingMapper;
import org.apache.hadoop.RandomTextWriterJob;
import org.apache.hadoop.SleepJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.JarFinder;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMRJobs {
    private static final Log LOG = LogFactory.getLog(TestMRJobs.class);
    private static final EnumSet<RMAppState> TERMINAL_RM_APP_STATES = EnumSet.of(RMAppState.FINISHED, RMAppState.FAILED, RMAppState.KILLED);
    private static final int NUM_NODE_MGRS = 3;
    private static final String TEST_IO_SORT_MB = "11";
    protected static MiniMRYarnCluster mrCluster;
    protected static MiniDFSCluster dfsCluster;
    private static Configuration conf;
    private static FileSystem localFs;
    private static FileSystem remoteFs;
    private static Path TEST_ROOT_DIR;
    static Path APP_JAR;
    private static final String OUTPUT_ROOT_DIR;

    @BeforeClass
    public static void setup() throws IOException {
        try {
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        if (mrCluster == null) {
            mrCluster = new MiniMRYarnCluster(TestMRJobs.class.getName(), 3);
            Configuration conf = new Configuration();
            conf.set("fs.defaultFS", remoteFs.getUri().toString());
            conf.set("yarn.app.mapreduce.am.staging-dir", "/apps_staging_dir");
            mrCluster.init(conf);
            mrCluster.start();
        }
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), APP_JAR);
        localFs.setPermission(APP_JAR, new FsPermission("700"));
    }

    @AfterClass
    public static void tearDown() {
        if (mrCluster != null) {
            mrCluster.stop();
            mrCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    @Test(timeout=300000L)
    public void testSleepJob() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testSleepJob().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Configuration sleepConf = new Configuration(mrCluster.getConfig());
        sleepConf.set("mapreduce.jobtracker.address", "local");
        SleepJob sleepJob = new SleepJob();
        sleepJob.setConf(sleepConf);
        int numReduces = sleepConf.getInt("TestMRJobs.testSleepJob.reduces", 2);
        Job job = sleepJob.createJob(3, numReduces, 10000L, 1, 5000L, 1);
        job.addFileToClassPath(APP_JAR);
        job.setJarByClass(SleepJob.class);
        job.setMaxMapAttempts(1);
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((boolean)succeeded);
        Assert.assertEquals((Object)((Object)JobStatus.State.SUCCEEDED), (Object)((Object)job.getJobState()));
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
        this.verifySleepJobCounters(job);
        this.verifyTaskProgress(job);
    }

    @Test(timeout=300000L)
    public void testJobClassloader() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testJobClassloader().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Configuration sleepConf = new Configuration(mrCluster.getConfig());
        sleepConf.set("mapreduce.jobtracker.address", "local");
        sleepConf.setBoolean("mapreduce.job.classloader", true);
        sleepConf.set("mapreduce.task.io.sort.mb", TEST_IO_SORT_MB);
        sleepConf.set("yarn.app.mapreduce.am.log.level", Level.ALL.toString());
        sleepConf.set("mapreduce.map.log.level", Level.ALL.toString());
        sleepConf.set("mapreduce.reduce.log.level", Level.ALL.toString());
        sleepConf.set("mapreduce.map.java.opts", "-verbose:class");
        SleepJob sleepJob = new SleepJob();
        sleepJob.setConf(sleepConf);
        Job job = sleepJob.createJob(1, 1, 10L, 1, 10L, 1);
        job.setMapperClass(ConfVerificationMapper.class);
        job.addFileToClassPath(APP_JAR);
        job.setJarByClass(SleepJob.class);
        job.setMaxMapAttempts(1);
        job.submit();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((String)("Job status: " + job.getStatus().getFailureInfo()), (boolean)succeeded);
    }

    protected void verifySleepJobCounters(Job job) throws InterruptedException, IOException {
        Counters counters = job.getCounters();
        Assert.assertEquals((long)3L, (long)counters.findCounter(JobCounter.OTHER_LOCAL_MAPS).getValue());
        Assert.assertEquals((long)3L, (long)counters.findCounter(JobCounter.TOTAL_LAUNCHED_MAPS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter(JobCounter.TOTAL_LAUNCHED_REDUCES).getValue());
        Assert.assertTrue((counters.findCounter(JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter(JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((counters.findCounter(JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter(JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
    }

    protected void verifyTaskProgress(Job job) throws InterruptedException, IOException {
        for (TaskReport taskReport : job.getTaskReports(TaskType.MAP)) {
            Assert.assertTrue((0.9999f < taskReport.getProgress() && 1.0001f > taskReport.getProgress() ? 1 : 0) != 0);
        }
        for (TaskReport taskReport : job.getTaskReports(TaskType.REDUCE)) {
            Assert.assertTrue((0.9999f < taskReport.getProgress() && 1.0001f > taskReport.getProgress() ? 1 : 0) != 0);
        }
    }

    @Test(timeout=60000L)
    public void testRandomWriter() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testRandomWriter().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        RandomTextWriterJob randomWriterJob = new RandomTextWriterJob();
        mrCluster.getConfig().set("mapreduce.randomtextwriter.totalbytes", "3072");
        mrCluster.getConfig().set("mapreduce.randomtextwriter.bytespermap", "1024");
        Job job = randomWriterJob.createJob(mrCluster.getConfig());
        Path outputDir = new Path(OUTPUT_ROOT_DIR, "random-output");
        FileOutputFormat.setOutputPath(job, outputDir);
        job.setSpeculativeExecution(false);
        job.addFileToClassPath(APP_JAR);
        job.setJarByClass(RandomTextWriterJob.class);
        job.setMaxMapAttempts(1);
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((boolean)succeeded);
        Assert.assertEquals((Object)((Object)JobStatus.State.SUCCEEDED), (Object)((Object)job.getJobState()));
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
        RemoteIterator<FileStatus> iterator = FileContext.getFileContext(mrCluster.getConfig()).listStatus(outputDir);
        int count = 0;
        while (iterator.hasNext()) {
            FileStatus file = iterator.next();
            if (file.getPath().getName().equals("_SUCCESS")) continue;
            ++count;
        }
        Assert.assertEquals((String)"Number of part files is wrong!", (long)3L, (long)count);
        this.verifyRandomWriterCounters(job);
    }

    protected void verifyRandomWriterCounters(Job job) throws InterruptedException, IOException {
        Counters counters = job.getCounters();
        Assert.assertEquals((long)3L, (long)counters.findCounter(JobCounter.OTHER_LOCAL_MAPS).getValue());
        Assert.assertEquals((long)3L, (long)counters.findCounter(JobCounter.TOTAL_LAUNCHED_MAPS).getValue());
        Assert.assertTrue((counters.findCounter(JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter(JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testFailingMapper() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testFailingMapper().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Job job = this.runFailingMapperJob();
        TaskID taskID = new TaskID(job.getJobID(), TaskType.MAP, 0);
        TaskAttemptID aId = new TaskAttemptID(taskID, 0);
        System.out.println("Diagnostics for " + aId + " :");
        for (String diag : job.getTaskDiagnostics(aId)) {
            System.out.println(diag);
        }
        aId = new TaskAttemptID(taskID, 1);
        System.out.println("Diagnostics for " + aId + " :");
        for (String diag : job.getTaskDiagnostics(aId)) {
            System.out.println(diag);
        }
        TaskCompletionEvent[] events = job.getTaskCompletionEvents(0, 2);
        Assert.assertEquals((Object)((Object)TaskCompletionEvent.Status.FAILED), (Object)((Object)events[0].getStatus()));
        Assert.assertEquals((Object)((Object)TaskCompletionEvent.Status.TIPFAILED), (Object)((Object)events[1].getStatus()));
        Assert.assertEquals((Object)((Object)JobStatus.State.FAILED), (Object)((Object)job.getJobState()));
        this.verifyFailingMapperCounters(job);
    }

    protected void verifyFailingMapperCounters(Job job) throws InterruptedException, IOException {
        Counters counters = job.getCounters();
        Assert.assertEquals((long)2L, (long)counters.findCounter(JobCounter.OTHER_LOCAL_MAPS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter(JobCounter.TOTAL_LAUNCHED_MAPS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter(JobCounter.NUM_FAILED_MAPS).getValue());
        Assert.assertTrue((counters.findCounter(JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter(JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
    }

    protected Job runFailingMapperJob() throws IOException, InterruptedException, ClassNotFoundException {
        Configuration myConf = new Configuration(mrCluster.getConfig());
        myConf.setInt("mapreduce.job.maps", 1);
        myConf.setInt("mapreduce.map.maxattempts", 2);
        Job job = new Job(myConf);
        job.setJarByClass(FailingMapper.class);
        job.setJobName("failmapper");
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(RandomTextWriterJob.RandomInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapperClass(FailingMapper.class);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath(job, new Path(OUTPUT_ROOT_DIR, "failmapper-output"));
        job.addFileToClassPath(APP_JAR);
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertFalse((boolean)succeeded);
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
        return job;
    }

    public void testSleepJobWithSecurityOn() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testSleepJobWithSecurityOn().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            return;
        }
        mrCluster.getConfig().set("hadoop.security.authentication", "kerberos");
        mrCluster.getConfig().set("yarn.resourcemanager.keytab", "/etc/krb5.keytab");
        mrCluster.getConfig().set("yarn.nodemanager.keytab", "/etc/krb5.keytab");
        mrCluster.getConfig().set("yarn.resourcemanager.principal", "rm/sightbusy-lx@LOCALHOST");
        mrCluster.getConfig().set("yarn.nodemanager.principal", "nm/sightbusy-lx@LOCALHOST");
        UserGroupInformation.setConfiguration(mrCluster.getConfig());
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        LOG.info((Object)("User name is " + user.getUserName()));
        for (Token<? extends TokenIdentifier> str : user.getTokens()) {
            LOG.info((Object)("Token is " + str.encodeToUrlString()));
        }
        user.doAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SleepJob sleepJob = new SleepJob();
                sleepJob.setConf(mrCluster.getConfig());
                Job job = sleepJob.createJob(3, 0, 10000L, 1, 0L, 0);
                job.addFileToClassPath(APP_JAR);
                job.submit();
                String trackingUrl = job.getTrackingURL();
                String jobId = job.getJobID().toString();
                job.waitForCompletion(true);
                Assert.assertEquals((Object)((Object)JobStatus.State.SUCCEEDED), (Object)((Object)job.getJobState()));
                Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
                return null;
            }
        });
    }

    @Test(timeout=120000L)
    public void testContainerRollingLog() throws IOException, InterruptedException, ClassNotFoundException {
        ApplicationId appID;
        Job job;
        JobConf sleepConf;
        block11: {
            if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
                LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
                return;
            }
            SleepJob sleepJob = new SleepJob();
            sleepConf = new JobConf(mrCluster.getConfig());
            sleepConf.set("mapreduce.map.log.level", Level.ALL.toString());
            long userLogKb = 4L;
            sleepConf.setLong("mapreduce.task.userlog.limit.kb", 4L);
            sleepConf.setInt("yarn.app.mapreduce.task.container.log.backups", 3);
            sleepConf.set("yarn.app.mapreduce.am.log.level", Level.ALL.toString());
            long amLogKb = 7L;
            sleepConf.setLong("yarn.app.mapreduce.am.container.log.limit.kb", 7L);
            sleepConf.setInt("yarn.app.mapreduce.am.container.log.backups", 7);
            sleepJob.setConf(sleepConf);
            job = sleepJob.createJob(1, 0, 1L, 100, 0L, 0);
            job.setJarByClass(SleepJob.class);
            job.addFileToClassPath(APP_JAR);
            job.waitForCompletion(true);
            JobId jobId = TypeConverter.toYarn(job.getJobID());
            appID = jobId.getAppId();
            int pollElapsed = 0;
            do {
                Thread.sleep(1000L);
                pollElapsed += 1000;
                if (TERMINAL_RM_APP_STATES.contains((Object)((RMApp)mrCluster.getResourceManager().getRMContext().getRMApps().get(appID)).getState())) break block11;
            } while (pollElapsed < 60000);
            LOG.warn((Object)"application did not reach terminal state within 60 seconds");
        }
        Assert.assertEquals((Object)((Object)RMAppState.FINISHED), (Object)((Object)((RMApp)mrCluster.getResourceManager().getRMContext().getRMApps().get(appID)).getState()));
        String appIdStr = appID.toString();
        String appIdSuffix = appIdStr.substring("application_".length(), appIdStr.length());
        String containerGlob = "container_" + appIdSuffix + "_*_*";
        String syslogGlob = appIdStr + "/" + containerGlob + "/" + (Object)((Object)TaskLog.LogName.SYSLOG);
        int numAppMasters = 0;
        int numMapTasks = 0;
        for (int i = 0; i < 3; ++i) {
            Configuration nmConf = mrCluster.getNodeManager(i).getConfig();
            for (String logDir : nmConf.getTrimmedStrings("yarn.nodemanager.log-dirs")) {
                FileStatus[] syslogs;
                Path absSyslogGlob = new Path(logDir + "/" + syslogGlob);
                LOG.info((Object)("Checking for glob: " + absSyslogGlob));
                for (FileStatus slog : syslogs = localFs.globStatus(absSyslogGlob)) {
                    boolean foundAppMaster = job.isUber();
                    Path containerPathComponent = slog.getPath().getParent();
                    if (!foundAppMaster) {
                        ContainerId cid = ConverterUtils.toContainerId(containerPathComponent.getName());
                        foundAppMaster = cid.getId() == 1;
                    }
                    Object[] sysSiblings = localFs.globStatus(new Path(containerPathComponent, (Object)((Object)TaskLog.LogName.SYSLOG) + "*"));
                    Arrays.sort(sysSiblings);
                    if (foundAppMaster) {
                        ++numAppMasters;
                    } else {
                        ++numMapTasks;
                    }
                    if (foundAppMaster) {
                        Assert.assertSame((String)"Unexpected number of AM sylog* files", (Object)(sleepConf.getInt("yarn.app.mapreduce.am.container.log.backups", 0) + 1), (Object)sysSiblings.length);
                        Assert.assertTrue((String)"AM syslog.1 length kb should be >= 7", (((FileStatus)sysSiblings[1]).getLen() >= 7168L ? 1 : 0) != 0);
                        continue;
                    }
                    Assert.assertSame((String)"Unexpected number of MR task sylog* files", (Object)(sleepConf.getInt("yarn.app.mapreduce.task.container.log.backups", 0) + 1), (Object)sysSiblings.length);
                    Assert.assertTrue((String)"MR syslog.1 length kb should be >= 4", (((FileStatus)sysSiblings[1]).getLen() >= 4096L ? 1 : 0) != 0);
                }
            }
        }
        Assert.assertEquals((String)"No AppMaster log found!", (long)1L, (long)numAppMasters);
        if (sleepConf.getBoolean("mapreduce.job.ubertask.enable", false)) {
            Assert.assertEquals((String)"MapTask log with uber found!", (long)0L, (long)numMapTasks);
        } else {
            Assert.assertEquals((String)"No MapTask log found!", (long)1L, (long)numMapTasks);
        }
    }

    public void _testDistributedCache(String jobJarPath) throws Exception {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Path first = this.createTempFile("distributed.first", "x");
        Path second = this.makeJar(new Path(TEST_ROOT_DIR, "distributed.second.jar"), 2);
        Path third = this.makeJar(new Path(TEST_ROOT_DIR, "distributed.third.jar"), 3);
        Path fourth = this.makeJar(new Path(TEST_ROOT_DIR, "distributed.fourth.jar"), 4);
        Job job = Job.getInstance(mrCluster.getConfig());
        job.setJar(jobJarPath);
        Path distributedCacheCheckerJar = new Path(JarFinder.getJar(DistributedCacheChecker.class));
        job.addFileToClassPath(distributedCacheCheckerJar.makeQualified(localFs.getUri(), distributedCacheCheckerJar.getParent()));
        job.setMapperClass(DistributedCacheChecker.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        FileInputFormat.setInputPaths(job, first);
        job.addCacheFile(new URI(first.toUri().toString() + "#distributed.first.symlink"));
        job.addFileToClassPath(second);
        job.addFileToClassPath(APP_JAR.makeQualified(localFs.getUri(), APP_JAR.getParent()));
        job.addArchiveToClassPath(third);
        job.addCacheArchive(fourth.toUri());
        job.setMaxMapAttempts(1);
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        Assert.assertTrue((boolean)job.waitForCompletion(false));
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
    }

    @Test(timeout=600000L)
    public void testDistributedCache() throws Exception {
        Path localJobJarPath = this.makeJobJarWithLib(TEST_ROOT_DIR.toUri().toString());
        this._testDistributedCache(localJobJarPath.toUri().toString());
        Path remoteJobJarPath = new Path(remoteFs.getUri().toString() + "/", localJobJarPath.getName());
        remoteFs.moveFromLocalFile(localJobJarPath, remoteJobJarPath);
        File localJobJarFile = new File(localJobJarPath.toUri().toString());
        if (localJobJarFile.exists()) {
            localJobJarFile.delete();
        }
        this._testDistributedCache(remoteJobJarPath.toUri().toString());
    }

    private Path createTempFile(String filename, String contents) throws IOException {
        Path path = new Path(TEST_ROOT_DIR, filename);
        FSDataOutputStream os = localFs.create(path);
        os.writeBytes(contents);
        os.close();
        localFs.setPermission(path, new FsPermission("700"));
        return path;
    }

    private Path makeJar(Path p, int index) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(new File(p.toUri().getPath()));
        JarOutputStream jos = new JarOutputStream(fos);
        ZipEntry ze = new ZipEntry("distributed.jar.inside" + index);
        jos.putNextEntry(ze);
        jos.write(("inside the jar!" + index).getBytes());
        jos.closeEntry();
        jos.close();
        localFs.setPermission(p, new FsPermission("700"));
        return p;
    }

    private Path makeJobJarWithLib(String testDir) throws FileNotFoundException, IOException {
        Path jobJarPath = new Path(testDir, "thejob.jar");
        FileOutputStream fos = new FileOutputStream(new File(jobJarPath.toUri().getPath()));
        JarOutputStream jos = new JarOutputStream(fos);
        this.createAndAddJarToJar(jos, new File(new Path(testDir, "lib1.jar").toUri().getPath()));
        this.createAndAddJarToJar(jos, new File(new Path(testDir, "lib2.jar").toUri().getPath()));
        jos.close();
        localFs.setPermission(jobJarPath, new FsPermission("700"));
        return jobJarPath;
    }

    private void createAndAddJarToJar(JarOutputStream jos, File jarFile) throws FileNotFoundException, IOException {
        int numRead;
        FileOutputStream fos2 = new FileOutputStream(jarFile);
        JarOutputStream jos2 = new JarOutputStream(fos2);
        ZipEntry ze = new ZipEntry("lib1.inside");
        jos2.putNextEntry(ze);
        jos2.closeEntry();
        jos2.close();
        ze = new ZipEntry("lib/" + jarFile.getName());
        jos.putNextEntry(ze);
        FileInputStream in = new FileInputStream(jarFile);
        byte[] buf = new byte[1024];
        do {
            if ((numRead = in.read(buf)) < 0) continue;
            jos.write(buf, 0, numRead);
        } while (numRead != -1);
        in.close();
        jos.closeEntry();
        jarFile.delete();
    }

    static {
        conf = new Configuration();
        try {
            localFs = FileSystem.getLocal(conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        TEST_ROOT_DIR = new Path("target", TestMRJobs.class.getName() + "-tmpDir").makeQualified(localFs);
        APP_JAR = new Path(TEST_ROOT_DIR, "MRAppJar.jar");
        OUTPUT_ROOT_DIR = "/tmp/" + TestMRJobs.class.getSimpleName();
    }

    public static class ConfVerificationMapper
    extends SleepJob.SleepMapper {
        @Override
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Configuration conf = context.getConfiguration();
            String ioSortMb = conf.get("mapreduce.task.io.sort.mb");
            if (!TestMRJobs.TEST_IO_SORT_MB.equals(ioSortMb)) {
                throw new IOException("io.sort.mb expected: 11, actual: " + ioSortMb);
            }
        }
    }

    public static class DistributedCacheChecker
    extends Mapper<LongWritable, Text, NullWritable, NullWritable> {
        @Override
        public void setup(Mapper.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            Path[] localFiles = context.getLocalCacheFiles();
            URI[] files = context.getCacheFiles();
            Path[] localArchives = context.getLocalCacheArchives();
            URI[] archives = context.getCacheArchives();
            Assert.assertEquals((long)4L, (long)localFiles.length);
            Assert.assertEquals((long)4L, (long)files.length);
            Assert.assertEquals((long)2L, (long)localArchives.length);
            Assert.assertEquals((long)2L, (long)archives.length);
            Map<String, Path> filesMap = DistributedCacheChecker.pathsToMap(localFiles);
            Assert.assertTrue((boolean)filesMap.containsKey("distributed.first.symlink"));
            Assert.assertEquals((long)1L, (long)localFs.getFileStatus(filesMap.get("distributed.first.symlink")).getLen());
            Assert.assertTrue((boolean)filesMap.containsKey("distributed.second.jar"));
            Assert.assertTrue((localFs.getFileStatus(filesMap.get("distributed.second.jar")).getLen() > 1L ? 1 : 0) != 0);
            Map<String, Path> archivesMap = DistributedCacheChecker.pathsToMap(localArchives);
            Assert.assertTrue((boolean)archivesMap.containsKey("distributed.third.jar"));
            Assert.assertTrue((boolean)localFs.exists(new Path(archivesMap.get("distributed.third.jar"), "distributed.jar.inside3")));
            Assert.assertTrue((boolean)archivesMap.containsKey("distributed.fourth.jar"));
            Assert.assertTrue((boolean)localFs.exists(new Path(archivesMap.get("distributed.fourth.jar"), "distributed.jar.inside4")));
            LOG.info((Object)("Java Classpath: " + System.getProperty("java.class.path")));
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Assert.assertNotNull((Object)cl.getResource("distributed.jar.inside2"));
            Assert.assertNotNull((Object)cl.getResource("distributed.jar.inside3"));
            Assert.assertNotNull((Object)cl.getResource("distributed.jar.inside4"));
            Assert.assertNotNull((Object)cl.getResource("job.jar/"));
            Assert.assertNotNull((Object)cl.getResource("job.jar/lib/lib1.jar"));
            Assert.assertNotNull((Object)cl.getResource("job.jar/lib/lib2.jar"));
            File symlinkFile = new File("distributed.first.symlink");
            Assert.assertTrue((boolean)symlinkFile.exists());
            Assert.assertEquals((long)1L, (long)symlinkFile.length());
            File jobJarDir = new File("job.jar");
            if (Shell.WINDOWS) {
                Assert.assertTrue((boolean)DistributedCacheChecker.isWindowsSymlinkedDirectory(jobJarDir));
            } else {
                Assert.assertTrue((boolean)FileUtils.isSymlink((File)jobJarDir));
                Assert.assertTrue((boolean)jobJarDir.isDirectory());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean isWindowsSymlinkedDirectory(File file) throws IOException {
            String dirOut = Shell.execCommand("cmd", "/c", "dir", file.getAbsoluteFile().getParent());
            StringReader sr = new StringReader(dirOut);
            BufferedReader br = new BufferedReader(sr);
            try {
                String line = br.readLine();
                while (line != null) {
                    line = br.readLine();
                    if (!line.contains(file.getName()) || !line.contains("<SYMLINKD>")) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeStream(br);
                IOUtils.closeStream(sr);
            }
        }

        private static Map<String, Path> pathsToMap(Path[] paths) {
            HashMap<String, Path> map = new HashMap<String, Path>();
            for (Path path : paths) {
                map.put(path.getName(), path);
            }
            return map;
        }
    }
}

