/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapReduceChildJVM;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapred.WrappedProgressSplitsBlock;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.api.records.Avataar;
import org.apache.hadoop.mapreduce.v2.api.records.Locality;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterTaskAbortEvent;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobTaskAttemptFetchFailureEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerLaunchedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptRecoverEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.app.speculate.SpeculatorEvent;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.RackResolver;

public abstract class TaskAttemptImpl
implements TaskAttempt,
EventHandler<TaskAttemptEvent> {
    static final Counters EMPTY_COUNTERS = new Counters();
    private static final Log LOG = LogFactory.getLog(TaskAttemptImpl.class);
    private static final long MEMORY_SPLITS_RESOLUTION = 1024L;
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected final JobConf conf;
    protected final Path jobFile;
    protected final int partition;
    protected EventHandler eventHandler;
    private final TaskAttemptId attemptId;
    private final Clock clock;
    private final JobID oldJobId;
    private final TaskAttemptListener taskAttemptListener;
    private final Resource resourceCapability;
    protected Set<String> dataLocalHosts;
    protected Set<String> dataLocalRacks;
    private final List<String> diagnostics = new ArrayList<String>();
    private final Lock readLock;
    private final Lock writeLock;
    private final AppContext appContext;
    private Credentials credentials;
    private Token<JobTokenIdentifier> jobToken;
    private static AtomicBoolean initialClasspathFlag = new AtomicBoolean();
    private static String initialClasspath = null;
    private static String initialAppClasspath = null;
    private static Object commonContainerSpecLock = new Object();
    private static ContainerLaunchContext commonContainerSpec = null;
    private static final Object classpathLock = new Object();
    private long launchTime;
    private long finishTime;
    private WrappedProgressSplitsBlock progressSplitBlock;
    private int shufflePort = -1;
    private String trackerName;
    private int httpPort;
    private Locality locality;
    private Avataar avataar;
    private static final CleanupContainerTransition CLEANUP_CONTAINER_TRANSITION = new CleanupContainerTransition();
    private static final DiagnosticInformationUpdater DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION = new DiagnosticInformationUpdater();
    private static final EnumSet<TaskAttemptEventType> FAILED_KILLED_STATE_IGNORED_EVENTS = EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_ASSIGNED, TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE});
    private static final StateMachineFactory<TaskAttemptImpl, TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachineFactory = new StateMachineFactory<TaskAttemptImpl, TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent>(TaskAttemptStateInternal.NEW).addTransition(TaskAttemptStateInternal.NEW, TaskAttemptStateInternal.UNASSIGNED, TaskAttemptEventType.TA_SCHEDULE, new RequestContainerTransition(false)).addTransition(TaskAttemptStateInternal.NEW, TaskAttemptStateInternal.UNASSIGNED, TaskAttemptEventType.TA_RESCHEDULE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new RequestContainerTransition(true)).addTransition(TaskAttemptStateInternal.NEW, TaskAttemptStateInternal.KILLED, TaskAttemptEventType.TA_KILL, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new KilledTransition()).addTransition(TaskAttemptStateInternal.NEW, TaskAttemptStateInternal.FAILED, TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new FailedTransition()).addTransition(TaskAttemptStateInternal.NEW, EnumSet.of(TaskAttemptStateInternal.FAILED, TaskAttemptStateInternal.KILLED, TaskAttemptStateInternal.SUCCEEDED), TaskAttemptEventType.TA_RECOVER, new RecoverTransition()).addTransition(TaskAttemptStateInternal.NEW, TaskAttemptStateInternal.NEW, TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.UNASSIGNED, TaskAttemptStateInternal.ASSIGNED, TaskAttemptEventType.TA_ASSIGNED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new ContainerAssignedTransition()).addTransition(TaskAttemptStateInternal.UNASSIGNED, TaskAttemptStateInternal.KILLED, TaskAttemptEventType.TA_KILL, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new DeallocateContainerTransition(TaskAttemptStateInternal.KILLED, true)).addTransition(TaskAttemptStateInternal.UNASSIGNED, TaskAttemptStateInternal.FAILED, TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new DeallocateContainerTransition(TaskAttemptStateInternal.FAILED, true)).addTransition(TaskAttemptStateInternal.UNASSIGNED, TaskAttemptStateInternal.UNASSIGNED, TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.ASSIGNED, TaskAttemptStateInternal.RUNNING, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new LaunchedContainerTransition()).addTransition(TaskAttemptStateInternal.ASSIGNED, TaskAttemptStateInternal.ASSIGNED, TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.ASSIGNED, TaskAttemptStateInternal.FAILED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new DeallocateContainerTransition(TaskAttemptStateInternal.FAILED, false)).addTransition(TaskAttemptStateInternal.ASSIGNED, TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.ASSIGNED, TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_KILL, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.ASSIGNED, TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.RUNNING, TaskAttemptStateInternal.RUNNING, TaskAttemptEventType.TA_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new StatusUpdater()).addTransition(TaskAttemptStateInternal.RUNNING, TaskAttemptStateInternal.RUNNING, TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.RUNNING, TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, TaskAttemptEventType.TA_DONE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.RUNNING, TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptEventType.TA_COMMIT_PENDING, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new CommitPendingTransition()).addTransition(TaskAttemptStateInternal.RUNNING, TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.RUNNING, TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.RUNNING, TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.RUNNING, TaskAttemptStateInternal.KILLED, TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new KilledTransition()).addTransition(TaskAttemptStateInternal.RUNNING, TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_KILL, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptEventType.TA_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new StatusUpdater()).addTransition(TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, TaskAttemptEventType.TA_DONE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_KILL, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptStateInternal.KILLED, TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new KilledTransition()).addTransition(TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_FAILMSG, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_CONTAINER_COMPLETED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.COMMIT_PENDING, TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)CLEANUP_CONTAINER_TRANSITION).addTransition(TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, TaskAttemptStateInternal.SUCCEEDED, TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new SucceededTransition()).addTransition(TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, TaskAttemptStateInternal.SUCCESS_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_CONTAINER_COMPLETED)).addTransition(TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptStateInternal.FAIL_TASK_CLEANUP, TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new TaskCleanupTransition()).addTransition(TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, TaskAttemptStateInternal.FAIL_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TIMED_OUT})).addTransition(TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, TaskAttemptStateInternal.KILL_TASK_CLEANUP, (TaskAttemptEventType[])TaskAttemptEventType.TA_CONTAINER_CLEANED, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new TaskCleanupTransition()).addTransition(TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, (TaskAttemptEventType[])TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, TaskAttemptStateInternal.KILL_CONTAINER_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_TIMED_OUT})).addTransition(TaskAttemptStateInternal.FAIL_TASK_CLEANUP, TaskAttemptStateInternal.FAILED, (TaskAttemptEventType[])TaskAttemptEventType.TA_CLEANUP_DONE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new FailedTransition()).addTransition(TaskAttemptStateInternal.FAIL_TASK_CLEANUP, TaskAttemptStateInternal.FAIL_TASK_CLEANUP, (TaskAttemptEventType[])TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.FAIL_TASK_CLEANUP, TaskAttemptStateInternal.FAIL_TASK_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED})).addTransition(TaskAttemptStateInternal.KILL_TASK_CLEANUP, TaskAttemptStateInternal.KILLED, (TaskAttemptEventType[])TaskAttemptEventType.TA_CLEANUP_DONE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new KilledTransition()).addTransition(TaskAttemptStateInternal.KILL_TASK_CLEANUP, TaskAttemptStateInternal.KILL_TASK_CLEANUP, (TaskAttemptEventType[])TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.KILL_TASK_CLEANUP, TaskAttemptStateInternal.KILL_TASK_CLEANUP, EnumSet.of(TaskAttemptEventType.TA_KILL, new TaskAttemptEventType[]{TaskAttemptEventType.TA_CONTAINER_COMPLETED, TaskAttemptEventType.TA_UPDATE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_LAUNCHED, TaskAttemptEventType.TA_CONTAINER_LAUNCH_FAILED})).addTransition(TaskAttemptStateInternal.SUCCEEDED, TaskAttemptStateInternal.FAILED, (TaskAttemptEventType[])TaskAttemptEventType.TA_TOO_MANY_FETCH_FAILURE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)new TooManyFetchFailureTransition()).addTransition(TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptStateInternal.SUCCEEDED, TaskAttemptStateInternal.KILLED), (TaskAttemptEventType[])TaskAttemptEventType.TA_KILL, new KilledAfterSuccessTransition()).addTransition(TaskAttemptStateInternal.SUCCEEDED, TaskAttemptStateInternal.SUCCEEDED, (TaskAttemptEventType[])TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.SUCCEEDED, TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptEventType.TA_FAILMSG, TaskAttemptEventType.TA_CONTAINER_CLEANED, TaskAttemptEventType.TA_CONTAINER_COMPLETED)).addTransition(TaskAttemptStateInternal.FAILED, TaskAttemptStateInternal.FAILED, TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.FAILED, TaskAttemptStateInternal.FAILED, FAILED_KILLED_STATE_IGNORED_EVENTS).addTransition(TaskAttemptStateInternal.KILLED, TaskAttemptStateInternal.KILLED, TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, (SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent>)DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition(TaskAttemptStateInternal.KILLED, TaskAttemptStateInternal.KILLED, FAILED_KILLED_STATE_IGNORED_EVENTS).installTopology();
    private final StateMachine<TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachine;
    @VisibleForTesting
    public Container container;
    private String nodeRackName;
    private WrappedJvmID jvmID;
    private Task remoteTask;
    private TaskAttemptStatusUpdateEvent.TaskAttemptStatus reportedStatus;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern ipPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    public TaskAttemptImpl(TaskId taskId, int i, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, Path jobFile, int partition, JobConf conf, String[] dataLocalHosts, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, AppContext appContext) {
        this.oldJobId = TypeConverter.fromYarn(taskId.getJobId());
        this.conf = conf;
        this.clock = clock;
        this.attemptId = recordFactory.newRecordInstance(TaskAttemptId.class);
        this.attemptId.setTaskId(taskId);
        this.attemptId.setId(i);
        this.taskAttemptListener = taskAttemptListener;
        this.appContext = appContext;
        this.reportedStatus = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        this.initTaskAttemptStatus(this.reportedStatus);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.credentials = credentials;
        this.jobToken = jobToken;
        this.eventHandler = eventHandler;
        this.jobFile = jobFile;
        this.partition = partition;
        this.resourceCapability = recordFactory.newRecordInstance(Resource.class);
        this.resourceCapability.setMemory(this.getMemoryRequired(conf, taskId.getTaskType()));
        this.resourceCapability.setVirtualCores(this.getCpuRequired(conf, taskId.getTaskType()));
        this.dataLocalHosts = this.resolveHosts(dataLocalHosts);
        RackResolver.init(conf);
        this.dataLocalRacks = new HashSet<String>();
        for (String host : this.dataLocalHosts) {
            this.dataLocalRacks.add(RackResolver.resolve(host).getNetworkLocation());
        }
        this.locality = Locality.OFF_SWITCH;
        this.avataar = Avataar.VIRGIN;
        this.stateMachine = stateMachineFactory.make(this);
    }

    private int getMemoryRequired(Configuration conf, TaskType taskType) {
        int memory = 1024;
        if (taskType == TaskType.MAP) {
            memory = conf.getInt("mapreduce.map.memory.mb", 1024);
        } else if (taskType == TaskType.REDUCE) {
            memory = conf.getInt("mapreduce.reduce.memory.mb", 1024);
        }
        return memory;
    }

    private int getCpuRequired(Configuration conf, TaskType taskType) {
        int vcores = 1;
        if (taskType == TaskType.MAP) {
            vcores = conf.getInt("mapreduce.map.cpu.vcores", 1);
        } else if (taskType == TaskType.REDUCE) {
            vcores = conf.getInt("mapreduce.reduce.cpu.vcores", 1);
        }
        return vcores;
    }

    private static LocalResource createLocalResource(FileSystem fc, Path file, LocalResourceType type, LocalResourceVisibility visibility) throws IOException {
        FileStatus fstat = fc.getFileStatus(file);
        URL resourceURL = ConverterUtils.getYarnUrlFromPath(fc.resolvePath(fstat.getPath()));
        long resourceSize = fstat.getLen();
        long resourceModificationTime = fstat.getModificationTime();
        return LocalResource.newInstance(resourceURL, type, visibility, resourceSize, resourceModificationTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInitialClasspath(Configuration conf) throws IOException {
        Object object = classpathLock;
        synchronized (object) {
            if (initialClasspathFlag.get()) {
                return initialClasspath;
            }
            HashMap<String, String> env = new HashMap<String, String>();
            MRApps.setClasspath(env, conf);
            initialClasspath = (String)env.get(ApplicationConstants.Environment.CLASSPATH.name());
            initialAppClasspath = (String)env.get(ApplicationConstants.Environment.APP_CLASSPATH.name());
            initialClasspathFlag.set(true);
            return initialClasspath;
        }
    }

    private static ContainerLaunchContext createCommonContainerLaunchContext(Map<ApplicationAccessType, String> applicationACLs, Configuration conf, Token<JobTokenIdentifier> jobToken, JobID oldJobId, Credentials credentials) {
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        HashMap<String, String> environment = new HashMap<String, String>();
        HashMap<String, ByteBuffer> serviceData = new HashMap<String, ByteBuffer>();
        ByteBuffer taskCredentialsBuffer = ByteBuffer.wrap(new byte[0]);
        try {
            FileSystem remoteFS = FileSystem.get(conf);
            String jobJar = conf.get("mapreduce.job.jar");
            if (jobJar != null) {
                Path remoteJobJar = new Path(jobJar).makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory());
                LocalResource rc = TaskAttemptImpl.createLocalResource(remoteFS, remoteJobJar, LocalResourceType.PATTERN, LocalResourceVisibility.APPLICATION);
                String pattern = conf.getPattern("mapreduce.job.jar.unpack.pattern", JobConf.UNPACK_JAR_PATTERN_DEFAULT).pattern();
                rc.setPattern(pattern);
                localResources.put("job.jar", rc);
                LOG.info((Object)("The job-jar file on the remote FS is " + remoteJobJar.toUri().toASCIIString()));
            } else {
                LOG.info((Object)"Job jar is not present. Not adding any jar to the list of resources.");
            }
            Path path = MRApps.getStagingAreaDir(conf, UserGroupInformation.getCurrentUser().getShortUserName());
            Path remoteJobSubmitDir = new Path(path, oldJobId.toString());
            Path remoteJobConfPath = new Path(remoteJobSubmitDir, "job.xml");
            localResources.put("job.xml", TaskAttemptImpl.createLocalResource(remoteFS, remoteJobConfPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION));
            LOG.info((Object)("The job-conf file on the remote FS is " + remoteJobConfPath.toUri().toASCIIString()));
            MRApps.setupDistributedCache(conf, localResources);
            LOG.info((Object)("Adding #" + credentials.numberOfTokens() + " tokens and #" + credentials.numberOfSecretKeys() + " secret keys for NM use for launching container"));
            Credentials taskCredentials = new Credentials(credentials);
            TokenCache.setJobToken(jobToken, taskCredentials);
            DataOutputBuffer containerTokens_dob = new DataOutputBuffer();
            LOG.info((Object)("Size of containertokens_dob is " + taskCredentials.numberOfTokens()));
            taskCredentials.writeTokenStorageToStream(containerTokens_dob);
            taskCredentialsBuffer = ByteBuffer.wrap(containerTokens_dob.getData(), 0, containerTokens_dob.getLength());
            LOG.info((Object)"Putting shuffle token in serviceData");
            byte[] shuffleSecret = TokenCache.getShuffleSecretKey(credentials);
            if (shuffleSecret == null) {
                LOG.warn((Object)"Cannot locate shuffle secret in credentials. Using job token as shuffle secret.");
                shuffleSecret = jobToken.getPassword();
            }
            Token<JobTokenIdentifier> shuffleToken = new Token<JobTokenIdentifier>(jobToken.getIdentifier(), shuffleSecret, jobToken.getKind(), jobToken.getService());
            serviceData.put("mapreduce_shuffle", ShuffleHandler.serializeServiceData(shuffleToken));
            Collection<String> shuffleProviders = conf.getStringCollection("mapreduce.job.shuffle.provider.services");
            if (!shuffleProviders.isEmpty()) {
                Collection<String> auxNames = conf.getStringCollection("yarn.nodemanager.aux-services");
                for (String shuffleProvider : shuffleProviders) {
                    if (shuffleProvider.equals("mapreduce_shuffle")) continue;
                    if (auxNames.contains(shuffleProvider)) {
                        LOG.info((Object)("Adding ShuffleProvider Service: " + shuffleProvider + " to serviceData"));
                        serviceData.put(shuffleProvider, ByteBuffer.allocate(0));
                        continue;
                    }
                    throw new YarnRuntimeException("ShuffleProvider Service: " + shuffleProvider + " was NOT found in the list of aux-services that are available in this NM." + " You may need to specify this ShuffleProvider as an aux-service in your yarn-site.xml");
                }
            }
            MRApps.addToEnvironment(environment, ApplicationConstants.Environment.CLASSPATH.name(), TaskAttemptImpl.getInitialClasspath(conf), conf);
            if (initialAppClasspath != null) {
                MRApps.addToEnvironment(environment, ApplicationConstants.Environment.APP_CLASSPATH.name(), initialAppClasspath, conf);
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException(e);
        }
        environment.put(ApplicationConstants.Environment.SHELL.name(), conf.get("mapreduce.admin.user.shell", "/bin/bash"));
        MRApps.addToEnvironment(environment, ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), MRApps.crossPlatformifyMREnv(conf, ApplicationConstants.Environment.PWD), conf);
        MRApps.setEnvFromInputString(environment, conf.get("mapreduce.admin.user.env", MRJobConfig.DEFAULT_MAPRED_ADMIN_USER_ENV), conf);
        ContainerLaunchContext container = ContainerLaunchContext.newInstance(localResources, environment, null, serviceData, taskCredentialsBuffer, applicationACLs);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ContainerLaunchContext createContainerLaunchContext(Map<ApplicationAccessType, String> applicationACLs, Configuration conf, Token<JobTokenIdentifier> jobToken, Task remoteTask, JobID oldJobId, WrappedJvmID jvmID, TaskAttemptListener taskAttemptListener, Credentials credentials) {
        Object object = commonContainerSpecLock;
        synchronized (object) {
            if (commonContainerSpec == null) {
                commonContainerSpec = TaskAttemptImpl.createCommonContainerLaunchContext(applicationACLs, conf, jobToken, oldJobId, credentials);
            }
        }
        Map<String, String> env = commonContainerSpec.getEnvironment();
        HashMap<String, String> myEnv = new HashMap<String, String>(env.size());
        myEnv.putAll(env);
        MapReduceChildJVM.setVMEnv(myEnv, remoteTask);
        List<String> commands = MapReduceChildJVM.getVMCommand(taskAttemptListener.getAddress(), remoteTask, jvmID);
        HashMap<String, ByteBuffer> myServiceData = new HashMap<String, ByteBuffer>();
        for (Map.Entry<String, ByteBuffer> entry : commonContainerSpec.getServiceData().entrySet()) {
            myServiceData.put(entry.getKey(), entry.getValue().duplicate());
        }
        ContainerLaunchContext container = ContainerLaunchContext.newInstance(commonContainerSpec.getLocalResources(), myEnv, commands, myServiceData, commonContainerSpec.getTokens().duplicate(), applicationACLs);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerId getAssignedContainerID() {
        this.readLock.lock();
        try {
            ContainerId containerId = this.container == null ? null : this.container.getId();
            return containerId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAssignedContainerMgrAddress() {
        this.readLock.lock();
        try {
            String string = this.container == null ? null : StringInterner.weakIntern(this.container.getNodeId().toString());
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLaunchTime() {
        this.readLock.lock();
        try {
            long l = this.launchTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getShuffleFinishTime() {
        this.readLock.lock();
        try {
            long l = this.reportedStatus.shuffleFinishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSortFinishTime() {
        this.readLock.lock();
        try {
            long l = this.reportedStatus.sortFinishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getShufflePort() {
        this.readLock.lock();
        try {
            int n = this.shufflePort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeId getNodeId() {
        this.readLock.lock();
        try {
            NodeId nodeId = this.container == null ? null : this.container.getNodeId();
            return nodeId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeHttpAddress() {
        this.readLock.lock();
        try {
            String string = this.container == null ? null : this.container.getNodeHttpAddress();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeRackName() {
        this.readLock.lock();
        try {
            String string = this.nodeRackName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected abstract Task createRemoteTask();

    @Override
    public TaskAttemptId getID() {
        return this.attemptId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.getInternalState() == TaskAttemptStateInternal.SUCCEEDED || this.getInternalState() == TaskAttemptStateInternal.FAILED || this.getInternalState() == TaskAttemptStateInternal.KILLED;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttemptReport getReport() {
        TaskAttemptReport result = recordFactory.newRecordInstance(TaskAttemptReport.class);
        this.readLock.lock();
        try {
            result.setTaskAttemptId(this.attemptId);
            result.setTaskAttemptState(this.getState());
            result.setProgress(this.reportedStatus.progress);
            result.setStartTime(this.launchTime);
            result.setFinishTime(this.finishTime);
            result.setShuffleFinishTime(this.reportedStatus.shuffleFinishTime);
            result.setDiagnosticInfo(StringUtils.join((CharSequence)LINE_SEPARATOR, this.getDiagnostics()));
            result.setPhase(this.reportedStatus.phase);
            result.setStateString(this.reportedStatus.stateString);
            result.setCounters(TypeConverter.toYarn(this.getCounters()));
            result.setContainerId(this.getAssignedContainerID());
            result.setNodeManagerHost(this.trackerName);
            result.setNodeManagerHttpPort(this.httpPort);
            if (this.container != null) {
                result.setNodeManagerPort(this.container.getNodeId().getPort());
            }
            TaskAttemptReport taskAttemptReport = result;
            return taskAttemptReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDiagnostics() {
        ArrayList<String> result = new ArrayList<String>();
        this.readLock.lock();
        try {
            result.addAll(this.diagnostics);
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Counters getCounters() {
        this.readLock.lock();
        try {
            Counters counters = this.reportedStatus.counters;
            if (counters == null) {
                counters = EMPTY_COUNTERS;
            }
            Counters counters2 = counters;
            return counters2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.reportedStatus.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Phase getPhase() {
        this.readLock.lock();
        try {
            Phase phase = this.reportedStatus.phase;
            return phase;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttemptState getState() {
        this.readLock.lock();
        try {
            TaskAttemptState taskAttemptState = TaskAttemptImpl.getExternalState(this.stateMachine.getCurrentState());
            return taskAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(TaskAttemptEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing " + event.getTaskAttemptID() + " of type " + event.getType()));
        }
        this.writeLock.lock();
        try {
            TaskAttemptStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition((TaskAttemptEventType)((Object)event.getType()), event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle this event at current state for " + this.attemptId), (Throwable)e);
                this.eventHandler.handle(new JobDiagnosticsUpdateEvent(this.attemptId.getTaskId().getJobId(), "Invalid event " + event.getType() + " on TaskAttempt " + this.attemptId));
                this.eventHandler.handle(new JobEvent(this.attemptId.getTaskId().getJobId(), JobEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.attemptId + " TaskAttempt Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public TaskAttemptStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskAttemptStateInternal taskAttemptStateInternal = this.stateMachine.getCurrentState();
            return taskAttemptStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Locality getLocality() {
        return this.locality;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    public Avataar getAvataar() {
        return this.avataar;
    }

    public void setAvataar(Avataar avataar) {
        this.avataar = avataar;
    }

    public TaskAttemptStateInternal recover(JobHistoryParser.TaskAttemptInfo taInfo, OutputCommitter committer, boolean recoverOutput) {
        TaskAttemptUnsuccessfulCompletionEvent tauce;
        TaskAttemptStateInternal attemptState;
        ContainerId containerId = taInfo.getContainerId();
        NodeId containerNodeId = ConverterUtils.toNodeId(taInfo.getHostname() + ":" + taInfo.getPort());
        String nodeHttpAddress = StringInterner.weakIntern(taInfo.getHostname() + ":" + taInfo.getHttpPort());
        this.container = Container.newInstance(containerId, containerNodeId, nodeHttpAddress, null, null, null);
        this.computeRackAndLocality();
        this.launchTime = taInfo.getStartTime();
        this.finishTime = taInfo.getFinishTime() != -1L ? taInfo.getFinishTime() : this.clock.getTime();
        this.shufflePort = taInfo.getShufflePort();
        this.trackerName = taInfo.getHostname();
        this.httpPort = taInfo.getHttpPort();
        this.sendLaunchedEvents();
        this.reportedStatus.id = this.attemptId;
        this.reportedStatus.progress = 1.0f;
        this.reportedStatus.counters = taInfo.getCounters();
        this.reportedStatus.stateString = taInfo.getState();
        this.reportedStatus.phase = Phase.CLEANUP;
        this.reportedStatus.mapFinishTime = taInfo.getMapFinishTime();
        this.reportedStatus.shuffleFinishTime = taInfo.getShuffleFinishTime();
        this.reportedStatus.sortFinishTime = taInfo.getSortFinishTime();
        this.addDiagnosticInfo(taInfo.getError());
        boolean needToClean = false;
        String recoveredState = taInfo.getTaskStatus();
        if (recoverOutput && TaskAttemptState.SUCCEEDED.toString().equals(recoveredState)) {
            TaskAttemptContextImpl tac = new TaskAttemptContextImpl(this.conf, TypeConverter.fromYarn(this.attemptId));
            try {
                committer.recoverTask(tac);
                LOG.info((Object)("Recovered output from task attempt " + this.attemptId));
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to recover task attempt " + this.attemptId), (Throwable)e);
                LOG.info((Object)("Task attempt " + this.attemptId + " will be recovered as KILLED"));
                recoveredState = TaskAttemptState.KILLED.toString();
                needToClean = true;
            }
        }
        if (TaskAttemptState.SUCCEEDED.toString().equals(recoveredState)) {
            attemptState = TaskAttemptStateInternal.SUCCEEDED;
            this.reportedStatus.taskState = TaskAttemptState.SUCCEEDED;
            this.eventHandler.handle(TaskAttemptImpl.createJobCounterUpdateEventTASucceeded(this));
            this.logAttemptFinishedEvent(attemptState);
        } else if (TaskAttemptState.FAILED.toString().equals(recoveredState)) {
            attemptState = TaskAttemptStateInternal.FAILED;
            this.reportedStatus.taskState = TaskAttemptState.FAILED;
            this.eventHandler.handle(TaskAttemptImpl.createJobCounterUpdateEventTAFailed(this, false));
            tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(this, TaskAttemptStateInternal.FAILED);
            this.eventHandler.handle(new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), tauce));
        } else {
            if (!TaskAttemptState.KILLED.toString().equals(recoveredState)) {
                if (String.valueOf(recoveredState).isEmpty()) {
                    LOG.info((Object)("TaskAttempt" + this.attemptId + " had not completed, recovering as KILLED"));
                } else {
                    LOG.warn((Object)("TaskAttempt " + this.attemptId + " found in unexpected state " + recoveredState + ", recovering as KILLED"));
                }
                this.addDiagnosticInfo("Killed during application recovery");
                needToClean = true;
            }
            attemptState = TaskAttemptStateInternal.KILLED;
            this.reportedStatus.taskState = TaskAttemptState.KILLED;
            this.eventHandler.handle(TaskAttemptImpl.createJobCounterUpdateEventTAKilled(this, false));
            tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(this, TaskAttemptStateInternal.KILLED);
            this.eventHandler.handle(new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), tauce));
        }
        if (needToClean) {
            TaskAttemptContextImpl tac = new TaskAttemptContextImpl(this.conf, TypeConverter.fromYarn(this.attemptId));
            try {
                committer.abortTask(tac);
            }
            catch (Exception e) {
                LOG.warn((Object)("Task cleanup failed for attempt " + this.attemptId), (Throwable)e);
            }
        }
        return attemptState;
    }

    private static TaskAttemptState getExternalState(TaskAttemptStateInternal smState) {
        switch (smState) {
            case ASSIGNED: 
            case UNASSIGNED: {
                return TaskAttemptState.STARTING;
            }
            case COMMIT_PENDING: {
                return TaskAttemptState.COMMIT_PENDING;
            }
            case FAILED: {
                return TaskAttemptState.FAILED;
            }
            case KILLED: {
                return TaskAttemptState.KILLED;
            }
            case FAIL_CONTAINER_CLEANUP: 
            case FAIL_TASK_CLEANUP: 
            case KILL_CONTAINER_CLEANUP: 
            case KILL_TASK_CLEANUP: 
            case SUCCESS_CONTAINER_CLEANUP: 
            case RUNNING: {
                return TaskAttemptState.RUNNING;
            }
            case NEW: {
                return TaskAttemptState.NEW;
            }
            case SUCCEEDED: {
                return TaskAttemptState.SUCCEEDED;
            }
        }
        throw new YarnRuntimeException("Attempt to convert invalid stateMachineTaskAttemptState to externalTaskAttemptState: " + (Object)((Object)smState));
    }

    private void setFinishTime() {
        if (this.launchTime != 0L) {
            this.finishTime = this.clock.getTime();
        }
    }

    private void computeRackAndLocality() {
        String cHost;
        NodeId containerNodeId = this.container.getNodeId();
        this.nodeRackName = RackResolver.resolve(containerNodeId.getHost()).getNetworkLocation();
        this.locality = Locality.OFF_SWITCH;
        if (this.dataLocalHosts.size() > 0 && this.dataLocalHosts.contains(cHost = this.resolveHost(containerNodeId.getHost()))) {
            this.locality = Locality.NODE_LOCAL;
        }
        if (this.locality == Locality.OFF_SWITCH && this.dataLocalRacks.contains(this.nodeRackName)) {
            this.locality = Locality.RACK_LOCAL;
        }
    }

    private static void updateMillisCounters(JobCounterUpdateEvent jce, TaskAttemptImpl taskAttempt) {
        int simSlotsRequired;
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        long duration = taskAttempt.getFinishTime() - taskAttempt.getLaunchTime();
        int mbRequired = taskAttempt.getMemoryRequired(taskAttempt.conf, taskType);
        int vcoresRequired = taskAttempt.getCpuRequired(taskAttempt.conf, taskType);
        int minSlotMemSize = taskAttempt.conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int n = simSlotsRequired = minSlotMemSize == 0 ? 0 : (int)Math.ceil((float)mbRequired / (float)minSlotMemSize);
        if (taskType == TaskType.MAP) {
            jce.addCounterUpdate(JobCounter.SLOTS_MILLIS_MAPS, (long)simSlotsRequired * duration);
            jce.addCounterUpdate(JobCounter.MB_MILLIS_MAPS, duration * (long)mbRequired);
            jce.addCounterUpdate(JobCounter.VCORES_MILLIS_MAPS, duration * (long)vcoresRequired);
            jce.addCounterUpdate(JobCounter.MILLIS_MAPS, duration);
        } else {
            jce.addCounterUpdate(JobCounter.SLOTS_MILLIS_REDUCES, (long)simSlotsRequired * duration);
            jce.addCounterUpdate(JobCounter.MB_MILLIS_REDUCES, duration * (long)mbRequired);
            jce.addCounterUpdate(JobCounter.VCORES_MILLIS_REDUCES, duration * (long)vcoresRequired);
            jce.addCounterUpdate(JobCounter.MILLIS_REDUCES, duration);
        }
    }

    private static JobCounterUpdateEvent createJobCounterUpdateEventTASucceeded(TaskAttemptImpl taskAttempt) {
        TaskId taskId = taskAttempt.attemptId.getTaskId();
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskId.getJobId());
        TaskAttemptImpl.updateMillisCounters(jce, taskAttempt);
        return jce;
    }

    private static JobCounterUpdateEvent createJobCounterUpdateEventTAFailed(TaskAttemptImpl taskAttempt, boolean taskAlreadyCompleted) {
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskAttempt.getID().getTaskId().getJobId());
        if (taskType == TaskType.MAP) {
            jce.addCounterUpdate(JobCounter.NUM_FAILED_MAPS, 1L);
        } else {
            jce.addCounterUpdate(JobCounter.NUM_FAILED_REDUCES, 1L);
        }
        if (!taskAlreadyCompleted) {
            TaskAttemptImpl.updateMillisCounters(jce, taskAttempt);
        }
        return jce;
    }

    private static JobCounterUpdateEvent createJobCounterUpdateEventTAKilled(TaskAttemptImpl taskAttempt, boolean taskAlreadyCompleted) {
        TaskType taskType = taskAttempt.getID().getTaskId().getTaskType();
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(taskAttempt.getID().getTaskId().getJobId());
        if (taskType == TaskType.MAP) {
            jce.addCounterUpdate(JobCounter.NUM_KILLED_MAPS, 1L);
        } else {
            jce.addCounterUpdate(JobCounter.NUM_KILLED_REDUCES, 1L);
        }
        if (!taskAlreadyCompleted) {
            TaskAttemptImpl.updateMillisCounters(jce, taskAttempt);
        }
        return jce;
    }

    private static TaskAttemptUnsuccessfulCompletionEvent createTaskAttemptUnsuccessfulCompletionEvent(TaskAttemptImpl taskAttempt, TaskAttemptStateInternal attemptState) {
        TaskAttemptUnsuccessfulCompletionEvent tauce = new TaskAttemptUnsuccessfulCompletionEvent(TypeConverter.fromYarn(taskAttempt.attemptId), TypeConverter.fromYarn(taskAttempt.attemptId.getTaskId().getTaskType()), attemptState.toString(), taskAttempt.finishTime, taskAttempt.container == null ? "UNKNOWN" : taskAttempt.container.getNodeId().getHost(), taskAttempt.container == null ? -1 : taskAttempt.container.getNodeId().getPort(), taskAttempt.nodeRackName == null ? "UNKNOWN" : taskAttempt.nodeRackName, StringUtils.join((CharSequence)LINE_SEPARATOR, taskAttempt.getDiagnostics()), taskAttempt.getCounters(), taskAttempt.getProgressSplitBlock().burst());
        return tauce;
    }

    private void sendLaunchedEvents() {
        JobCounterUpdateEvent jce = new JobCounterUpdateEvent(this.attemptId.getTaskId().getJobId());
        jce.addCounterUpdate(this.attemptId.getTaskId().getTaskType() == TaskType.MAP ? JobCounter.TOTAL_LAUNCHED_MAPS : JobCounter.TOTAL_LAUNCHED_REDUCES, 1L);
        this.eventHandler.handle(jce);
        LOG.info((Object)("TaskAttempt: [" + this.attemptId + "] using containerId: [" + this.container.getId() + " on NM: [" + StringInterner.weakIntern(this.container.getNodeId().toString()) + "]"));
        TaskAttemptStartedEvent tase = new TaskAttemptStartedEvent(TypeConverter.fromYarn(this.attemptId), TypeConverter.fromYarn(this.attemptId.getTaskId().getTaskType()), this.launchTime, this.trackerName, this.httpPort, this.shufflePort, this.container.getId(), this.locality.toString(), this.avataar.toString());
        this.eventHandler.handle(new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), tase));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WrappedProgressSplitsBlock getProgressSplitBlock() {
        this.readLock.lock();
        try {
            if (this.progressSplitBlock == null) {
                this.progressSplitBlock = new WrappedProgressSplitsBlock(this.conf.getInt("yarn.app.mapreduce.am.num-progress-splits", 12));
            }
            WrappedProgressSplitsBlock wrappedProgressSplitsBlock = this.progressSplitBlock;
            return wrappedProgressSplitsBlock;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void updateProgressSplits() {
        double newProgress = this.reportedStatus.progress;
        newProgress = Math.max(Math.min(newProgress, 1.0), 0.0);
        Counters counters = this.reportedStatus.counters;
        if (counters == null) {
            return;
        }
        WrappedProgressSplitsBlock splitsBlock = this.getProgressSplitBlock();
        if (splitsBlock != null) {
            Object physicalBytes;
            Object virtualBytes;
            Object cpuCounter;
            long now = this.clock.getTime();
            long start = this.getLaunchTime();
            if (start != 0L && now - start <= Integer.MAX_VALUE) {
                splitsBlock.getProgressWallclockTime().extend(newProgress, (int)(now - start));
            }
            if ((cpuCounter = counters.findCounter(TaskCounter.CPU_MILLISECONDS)) != null && cpuCounter.getValue() <= Integer.MAX_VALUE) {
                splitsBlock.getProgressCPUTime().extend(newProgress, (int)cpuCounter.getValue());
            }
            if ((virtualBytes = counters.findCounter(TaskCounter.VIRTUAL_MEMORY_BYTES)) != null) {
                splitsBlock.getProgressVirtualMemoryKbytes().extend(newProgress, (int)(virtualBytes.getValue() / 1024L));
            }
            if ((physicalBytes = counters.findCounter(TaskCounter.PHYSICAL_MEMORY_BYTES)) != null) {
                splitsBlock.getProgressPhysicalMemoryKbytes().extend(newProgress, (int)(physicalBytes.getValue() / 1024L));
            }
        }
    }

    protected Set<String> resolveHosts(String[] src) {
        HashSet<String> result = new HashSet<String>();
        if (src != null) {
            for (int i = 0; i < src.length; ++i) {
                if (src[i] == null) continue;
                if (this.isIP(src[i])) {
                    result.add(this.resolveHost(src[i]));
                    continue;
                }
                result.add(src[i]);
            }
        }
        return result;
    }

    protected String resolveHost(String src) {
        String result = src;
        try {
            InetAddress addr = InetAddress.getByName(src);
            result = addr.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn((Object)("Failed to resolve address: " + src + ". Continuing to use the same."));
        }
        return result;
    }

    protected boolean isIP(String src) {
        return ipPattern.matcher(src).matches();
    }

    private void logAttemptFinishedEvent(TaskAttemptStateInternal state) {
        int containerNodePort;
        if (this.getLaunchTime() == 0L) {
            return;
        }
        String containerHostName = this.container == null ? "UNKNOWN" : this.container.getNodeId().getHost();
        int n = containerNodePort = this.container == null ? -1 : this.container.getNodeId().getPort();
        if (this.attemptId.getTaskId().getTaskType() == TaskType.MAP) {
            MapAttemptFinishedEvent mfe = new MapAttemptFinishedEvent(TypeConverter.fromYarn(this.attemptId), TypeConverter.fromYarn(this.attemptId.getTaskId().getTaskType()), state.toString(), this.reportedStatus.mapFinishTime, this.finishTime, containerHostName, containerNodePort, this.nodeRackName == null ? "UNKNOWN" : this.nodeRackName, this.reportedStatus.stateString, this.getCounters(), this.getProgressSplitBlock().burst());
            this.eventHandler.handle(new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), mfe));
        } else {
            ReduceAttemptFinishedEvent rfe = new ReduceAttemptFinishedEvent(TypeConverter.fromYarn(this.attemptId), TypeConverter.fromYarn(this.attemptId.getTaskId().getTaskType()), state.toString(), this.reportedStatus.shuffleFinishTime, this.reportedStatus.sortFinishTime, this.finishTime, containerHostName, containerNodePort, this.nodeRackName == null ? "UNKNOWN" : this.nodeRackName, this.reportedStatus.stateString, this.getCounters(), this.getProgressSplitBlock().burst());
            this.eventHandler.handle(new JobHistoryEvent(this.attemptId.getTaskId().getJobId(), rfe));
        }
    }

    private void addDiagnosticInfo(String diag) {
        if (diag != null && !diag.equals("")) {
            this.diagnostics.add(diag);
        }
    }

    private void initTaskAttemptStatus(TaskAttemptStatusUpdateEvent.TaskAttemptStatus result) {
        Counters counters;
        result.progress = 0.0f;
        result.phase = Phase.STARTING;
        result.stateString = "NEW";
        result.taskState = TaskAttemptState.NEW;
        result.counters = counters = EMPTY_COUNTERS;
    }

    private static class DiagnosticInformationUpdater
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private DiagnosticInformationUpdater() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptDiagnosticsUpdateEvent diagEvent = (TaskAttemptDiagnosticsUpdateEvent)event;
            LOG.info((Object)("Diagnostics report from " + taskAttempt.attemptId + ": " + diagEvent.getDiagnosticInfo()));
            taskAttempt.addDiagnosticInfo(diagEvent.getDiagnosticInfo());
        }
    }

    private static class StatusUpdater
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private StatusUpdater() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptStatusUpdateEvent.TaskAttemptStatus newReportedStatus = ((TaskAttemptStatusUpdateEvent)event).getReportedTaskAttemptStatus();
            taskAttempt.reportedStatus = newReportedStatus;
            ((TaskAttemptImpl)taskAttempt).reportedStatus.taskState = taskAttempt.getState();
            taskAttempt.eventHandler.handle(new SpeculatorEvent(taskAttempt.reportedStatus, taskAttempt.clock.getTime()));
            taskAttempt.updateProgressSplits();
            if (((TaskAttemptImpl)taskAttempt).reportedStatus.fetchFailedMaps != null && ((TaskAttemptImpl)taskAttempt).reportedStatus.fetchFailedMaps.size() > 0) {
                taskAttempt.eventHandler.handle(new JobTaskAttemptFetchFailureEvent(taskAttempt.attemptId, ((TaskAttemptImpl)taskAttempt).reportedStatus.fetchFailedMaps));
            }
        }
    }

    private static class CleanupContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private CleanupContainerTransition() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.taskAttemptListener.unregister(taskAttempt.attemptId, taskAttempt.jvmID);
            if (event instanceof TaskAttemptKillEvent) {
                taskAttempt.addDiagnosticInfo(((TaskAttemptKillEvent)event).getMessage());
            }
            ((TaskAttemptImpl)taskAttempt).reportedStatus.progress = 1.0f;
            taskAttempt.updateProgressSplits();
            taskAttempt.eventHandler.handle(new ContainerLauncherEvent(taskAttempt.attemptId, taskAttempt.container.getId(), StringInterner.weakIntern(taskAttempt.container.getNodeId().toString()), taskAttempt.container.getContainerToken(), ContainerLauncher.EventType.CONTAINER_REMOTE_CLEANUP));
        }
    }

    private static class KilledTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private KilledTransition() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.setFinishTime();
            if (taskAttempt.getLaunchTime() != 0L) {
                taskAttempt.eventHandler.handle(TaskAttemptImpl.createJobCounterUpdateEventTAKilled(taskAttempt, false));
                TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.KILLED);
                taskAttempt.eventHandler.handle(new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), tauce));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for taskAttempt: " + taskAttempt.getID()));
            }
            if (event instanceof TaskAttemptKillEvent) {
                taskAttempt.addDiagnosticInfo(((TaskAttemptKillEvent)event).getMessage());
            }
            taskAttempt.eventHandler.handle(new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_KILLED));
        }
    }

    private static class KilledAfterSuccessTransition
    implements MultipleArcTransition<TaskAttemptImpl, TaskAttemptEvent, TaskAttemptStateInternal> {
        private KilledAfterSuccessTransition() {
        }

        @Override
        public TaskAttemptStateInternal transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            if (taskAttempt.getID().getTaskId().getTaskType() == TaskType.REDUCE) {
                LOG.info((Object)("Ignoring killed event for successful reduce task attempt" + taskAttempt.getID().toString()));
                return TaskAttemptStateInternal.SUCCEEDED;
            }
            if (event instanceof TaskAttemptKillEvent) {
                TaskAttemptKillEvent msgEvent = (TaskAttemptKillEvent)event;
                taskAttempt.addDiagnosticInfo(msgEvent.getMessage());
            }
            assert (taskAttempt.getFinishTime() != 0L);
            assert (taskAttempt.getLaunchTime() != 0L);
            taskAttempt.eventHandler.handle(TaskAttemptImpl.createJobCounterUpdateEventTAKilled(taskAttempt, true));
            TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.KILLED);
            taskAttempt.eventHandler.handle(new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), tauce));
            taskAttempt.eventHandler.handle(new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_KILLED));
            return TaskAttemptStateInternal.KILLED;
        }
    }

    private static class TooManyFetchFailureTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private TooManyFetchFailureTransition() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            Preconditions.checkArgument(taskAttempt.getID().getTaskId().getTaskType() == TaskType.MAP);
            taskAttempt.addDiagnosticInfo("Too Many fetch failures.Failing the attempt");
            if (taskAttempt.getLaunchTime() != 0L) {
                taskAttempt.eventHandler.handle(TaskAttemptImpl.createJobCounterUpdateEventTAFailed(taskAttempt, true));
                TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.FAILED);
                taskAttempt.eventHandler.handle(new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), tauce));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for taskAttempt: " + taskAttempt.getID()));
            }
            taskAttempt.eventHandler.handle(new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_FAILED));
        }
    }

    private static class RecoverTransition
    implements MultipleArcTransition<TaskAttemptImpl, TaskAttemptEvent, TaskAttemptStateInternal> {
        private RecoverTransition() {
        }

        @Override
        public TaskAttemptStateInternal transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptRecoverEvent tare = (TaskAttemptRecoverEvent)event;
            return taskAttempt.recover(tare.getTaskAttemptInfo(), tare.getCommitter(), tare.getRecoverOutput());
        }
    }

    private static class FailedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private FailedTransition() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.setFinishTime();
            if (taskAttempt.getLaunchTime() != 0L) {
                taskAttempt.eventHandler.handle(TaskAttemptImpl.createJobCounterUpdateEventTAFailed(taskAttempt, false));
                TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, TaskAttemptStateInternal.FAILED);
                taskAttempt.eventHandler.handle(new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), tauce));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for taskAttempt: " + taskAttempt.getID()));
            }
            taskAttempt.eventHandler.handle(new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_FAILED));
        }
    }

    private static class SucceededTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private SucceededTransition() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.setFinishTime();
            taskAttempt.eventHandler.handle(TaskAttemptImpl.createJobCounterUpdateEventTASucceeded(taskAttempt));
            taskAttempt.logAttemptFinishedEvent(TaskAttemptStateInternal.SUCCEEDED);
            taskAttempt.eventHandler.handle(new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_SUCCEEDED));
            taskAttempt.eventHandler.handle(new SpeculatorEvent(taskAttempt.reportedStatus, taskAttempt.clock.getTime()));
        }
    }

    private static class TaskCleanupTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private TaskCleanupTransition() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(taskAttempt.conf, TypeConverter.fromYarn(taskAttempt.attemptId));
            taskAttempt.eventHandler.handle(new CommitterTaskAbortEvent(taskAttempt.attemptId, taskContext));
        }
    }

    private static class CommitPendingTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private CommitPendingTransition() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.eventHandler.handle(new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_COMMIT_PENDING));
        }
    }

    private static class LaunchedContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private LaunchedContainerTransition() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent evnt) {
            TaskAttemptContainerLaunchedEvent event = (TaskAttemptContainerLaunchedEvent)evnt;
            taskAttempt.launchTime = taskAttempt.clock.getTime();
            taskAttempt.shufflePort = event.getShufflePort();
            taskAttempt.taskAttemptListener.registerLaunchedTask(taskAttempt.attemptId, taskAttempt.jvmID);
            InetSocketAddress nodeHttpInetAddr = NetUtils.createSocketAddr(taskAttempt.container.getNodeHttpAddress());
            taskAttempt.trackerName = nodeHttpInetAddr.getHostName();
            taskAttempt.httpPort = nodeHttpInetAddr.getPort();
            taskAttempt.sendLaunchedEvents();
            taskAttempt.eventHandler.handle(new SpeculatorEvent(taskAttempt.attemptId, true, taskAttempt.clock.getTime()));
            taskAttempt.remoteTask = null;
            taskAttempt.eventHandler.handle(new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_LAUNCHED));
        }
    }

    private static class DeallocateContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private final TaskAttemptStateInternal finalState;
        private final boolean withdrawsContainerRequest;

        DeallocateContainerTransition(TaskAttemptStateInternal finalState, boolean withdrawsContainerRequest) {
            this.finalState = finalState;
            this.withdrawsContainerRequest = withdrawsContainerRequest;
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.setFinishTime();
            if (event instanceof TaskAttemptKillEvent) {
                taskAttempt.addDiagnosticInfo(((TaskAttemptKillEvent)event).getMessage());
            }
            taskAttempt.eventHandler.handle(new ContainerAllocatorEvent(taskAttempt.attemptId, ContainerAllocator.EventType.CONTAINER_DEALLOCATE));
            if (this.withdrawsContainerRequest) {
                taskAttempt.eventHandler.handle(new SpeculatorEvent(taskAttempt.getID().getTaskId(), -1));
            }
            switch (this.finalState) {
                case FAILED: {
                    taskAttempt.eventHandler.handle(new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_FAILED));
                    break;
                }
                case KILLED: {
                    taskAttempt.eventHandler.handle(new TaskTAttemptEvent(taskAttempt.attemptId, TaskEventType.T_ATTEMPT_KILLED));
                    break;
                }
                default: {
                    LOG.error((Object)("Task final state is not FAILED or KILLED: " + (Object)((Object)this.finalState)));
                }
            }
            if (taskAttempt.getLaunchTime() != 0L) {
                TaskAttemptUnsuccessfulCompletionEvent tauce = TaskAttemptImpl.createTaskAttemptUnsuccessfulCompletionEvent(taskAttempt, this.finalState);
                if (this.finalState == TaskAttemptStateInternal.FAILED) {
                    taskAttempt.eventHandler.handle(TaskAttemptImpl.createJobCounterUpdateEventTAFailed(taskAttempt, false));
                } else if (this.finalState == TaskAttemptStateInternal.KILLED) {
                    taskAttempt.eventHandler.handle(TaskAttemptImpl.createJobCounterUpdateEventTAKilled(taskAttempt, false));
                }
                taskAttempt.eventHandler.handle(new JobHistoryEvent(taskAttempt.attemptId.getTaskId().getJobId(), tauce));
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for taskAttempt: " + taskAttempt.getID()));
            }
        }
    }

    private static class ContainerAssignedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private ContainerAssignedTransition() {
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            Container container;
            TaskAttemptContainerAssignedEvent cEvent = (TaskAttemptContainerAssignedEvent)event;
            taskAttempt.container = container = cEvent.getContainer();
            taskAttempt.remoteTask = taskAttempt.createRemoteTask();
            taskAttempt.jvmID = new WrappedJvmID(taskAttempt.remoteTask.getTaskID().getJobID(), taskAttempt.remoteTask.isMapTask(), taskAttempt.container.getId().getId());
            taskAttempt.taskAttemptListener.registerPendingTask(taskAttempt.remoteTask, taskAttempt.jvmID);
            taskAttempt.computeRackAndLocality();
            ContainerLaunchContext launchContext = TaskAttemptImpl.createContainerLaunchContext(cEvent.getApplicationACLs(), taskAttempt.conf, taskAttempt.jobToken, taskAttempt.remoteTask, taskAttempt.oldJobId, taskAttempt.jvmID, taskAttempt.taskAttemptListener, taskAttempt.credentials);
            taskAttempt.eventHandler.handle(new ContainerRemoteLaunchEvent(taskAttempt.attemptId, launchContext, container, taskAttempt.remoteTask));
            taskAttempt.eventHandler.handle(new SpeculatorEvent(taskAttempt.getID().getTaskId(), -1));
        }
    }

    static class RequestContainerTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        private final boolean rescheduled;

        public RequestContainerTransition(boolean rescheduled) {
            this.rescheduled = rescheduled;
        }

        @Override
        public void transition(TaskAttemptImpl taskAttempt, TaskAttemptEvent event) {
            taskAttempt.eventHandler.handle(new SpeculatorEvent(taskAttempt.getID().getTaskId(), 1));
            if (this.rescheduled) {
                taskAttempt.eventHandler.handle(ContainerRequestEvent.createContainerRequestEventForFailedContainer(taskAttempt.attemptId, taskAttempt.resourceCapability));
            } else {
                taskAttempt.eventHandler.handle(new ContainerRequestEvent(taskAttempt.attemptId, taskAttempt.resourceCapability, taskAttempt.dataLocalHosts.toArray(new String[taskAttempt.dataLocalHosts.size()]), taskAttempt.dataLocalRacks.toArray(new String[taskAttempt.dataLocalRacks.size()])));
            }
        }
    }
}

