/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerNullStateStoreService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreService;
import org.apache.hadoop.util.ReflectionUtils;

public class HistoryServerStateStoreServiceFactory {
    public static HistoryServerStateStoreService getStore(Configuration conf) {
        Class storeClass = HistoryServerNullStateStoreService.class;
        boolean recoveryEnabled = conf.getBoolean("mapreduce.jobhistory.recovery.enable", false);
        if (recoveryEnabled && (storeClass = conf.getClass("mapreduce.jobhistory.recovery.store.class", null, HistoryServerStateStoreService.class)) == null) {
            throw new RuntimeException("Unable to locate storage class, check mapreduce.jobhistory.recovery.store.class");
        }
        return ReflectionUtils.newInstance(storeClass, conf);
    }
}

