/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsServlet;
import org.apache.hadoop.metrics.spi.NoEmitMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.mortbay.util.ajax.JSON;

public class TestMetricsServlet
extends TestCase {
    MetricsContext nc1;
    MetricsContext nc2;
    List<MetricsContext> contexts;
    OutputRecord outputRecord;

    public void setUp() throws IOException {
        this.nc1 = new NoEmitMetricsContext();
        this.nc1.init("test1", ContextFactory.getFactory());
        this.nc2 = new NoEmitMetricsContext();
        this.nc2.init("test2", ContextFactory.getFactory());
        this.contexts = new ArrayList<MetricsContext>();
        this.contexts.add(this.nc1);
        this.contexts.add(this.nc2);
        MetricsRecord r = this.nc1.createRecord("testRecord");
        r.setTag("testTag1", "testTagValue1");
        r.setTag("testTag2", "testTagValue2");
        r.setMetric("testMetric1", 1);
        r.setMetric("testMetric2", 33);
        r.update();
        Map<String, Collection<OutputRecord>> m = this.nc1.getAllRecords();
        TestMetricsServlet.assertEquals((int)1, (int)m.size());
        TestMetricsServlet.assertEquals((int)1, (int)m.values().size());
        Collection<OutputRecord> outputRecords = m.values().iterator().next();
        TestMetricsServlet.assertEquals((int)1, (int)outputRecords.size());
        this.outputRecord = outputRecords.iterator().next();
    }

    public void testTagsMetricsPair() throws IOException {
        MetricsServlet.TagsMetricsPair pair = new MetricsServlet.TagsMetricsPair(this.outputRecord.getTagsCopy(), this.outputRecord.getMetricsCopy());
        String s = JSON.toString((Object)pair);
        TestMetricsServlet.assertEquals((String)"[{\"testTag1\":\"testTagValue1\",\"testTag2\":\"testTagValue2\"},{\"testMetric1\":1,\"testMetric2\":33}]", (String)s);
    }

    public void testGetMap() throws IOException {
        MetricsServlet servlet = new MetricsServlet();
        Map<String, Map<String, List<MetricsServlet.TagsMetricsPair>>> m = servlet.makeMap(this.contexts);
        TestMetricsServlet.assertEquals((String)"Map missing contexts", (int)2, (int)m.size());
        TestMetricsServlet.assertTrue((boolean)m.containsKey("test1"));
        Map<String, List<MetricsServlet.TagsMetricsPair>> m2 = m.get("test1");
        TestMetricsServlet.assertEquals((String)"Missing records", (int)1, (int)m2.size());
        TestMetricsServlet.assertTrue((boolean)m2.containsKey("testRecord"));
        TestMetricsServlet.assertEquals((String)"Wrong number of tags-values pairs.", (int)1, (int)m2.get("testRecord").size());
    }

    public void testPrintMap() throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        MetricsServlet servlet = new MetricsServlet();
        servlet.printMap(out, servlet.makeMap(this.contexts));
        String EXPECTED = "test1\n  testRecord\n    {testTag1=testTagValue1,testTag2=testTagValue2}:\n      testMetric1=1\n      testMetric2=33\ntest2\n";
        TestMetricsServlet.assertEquals((String)EXPECTED, (String)sw.toString());
    }
}

