/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.impl.TestMetricsConfig;
import org.apache.hadoop.metrics2.impl.TestMetricsSystemImpl;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.sink.ganglia.AbstractGangliaSink;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaMetricsTestHelper;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaSink30;
import org.apache.hadoop.metrics2.sink.ganglia.GangliaSink31;
import org.junit.Assert;
import org.junit.Test;

public class TestGangliaMetrics {
    public static final Log LOG = LogFactory.getLog(TestMetricsSystemImpl.class);
    private final String[] expectedMetrics = new String[]{"test.s1rec.C1", "test.s1rec.G1", "test.s1rec.Xxx", "test.s1rec.Yyy", "test.s1rec.S1NumOps", "test.s1rec.S1AvgTime"};

    @Test
    public void testTagsForPrefix() throws Exception {
        ConfigBuilder cb = new ConfigBuilder().add("test.sink.ganglia.tagsForPrefix.all", "*").add("test.sink.ganglia.tagsForPrefix.some", "NumActiveSinks, NumActiveSources").add("test.sink.ganglia.tagsForPrefix.none", "");
        GangliaSink30 sink = new GangliaSink30();
        sink.init(cb.subset("test.sink.ganglia"));
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        tags.add(new MetricsTag(MsInfo.Context, "all"));
        tags.add(new MetricsTag(MsInfo.NumActiveSources, "foo"));
        tags.add(new MetricsTag(MsInfo.NumActiveSinks, "bar"));
        tags.add(new MetricsTag(MsInfo.NumAllSinks, "haa"));
        tags.add(new MetricsTag(MsInfo.Hostname, "host"));
        HashSet<AbstractMetric> metrics = new HashSet<AbstractMetric>();
        MetricsRecordImpl record = new MetricsRecordImpl(MsInfo.Context, 1L, tags, metrics);
        StringBuilder sb = new StringBuilder();
        sink.appendPrefix(record, sb);
        Assert.assertEquals((Object)".NumActiveSources=foo.NumActiveSinks=bar.NumAllSinks=haa", (Object)sb.toString());
        tags.set(0, new MetricsTag(MsInfo.Context, "some"));
        sb = new StringBuilder();
        sink.appendPrefix(record, sb);
        Assert.assertEquals((Object)".NumActiveSources=foo.NumActiveSinks=bar", (Object)sb.toString());
        tags.set(0, new MetricsTag(MsInfo.Context, "none"));
        sb = new StringBuilder();
        sink.appendPrefix(record, sb);
        Assert.assertEquals((Object)"", (Object)sb.toString());
        tags.set(0, new MetricsTag(MsInfo.Context, "nada"));
        sb = new StringBuilder();
        sink.appendPrefix(record, sb);
        Assert.assertEquals((Object)"", (Object)sb.toString());
    }

    @Test
    public void testGangliaMetrics2() throws Exception {
        ConfigBuilder cb = new ConfigBuilder().add("default.period", 10).add("test.sink.gsink30.context", "test").add("test.sink.gsink31.context", "test").save(TestMetricsConfig.getTestFilename("hadoop-metrics2-test"));
        MetricsSystemImpl ms = new MetricsSystemImpl("Test");
        ms.start();
        TestSource s1 = ms.register("s1", "s1 desc", new TestSource("s1rec"));
        s1.c1.incr();
        s1.xxx.incr();
        s1.g1.set(2L);
        s1.yyy.incr(2L);
        s1.s1.add(0L);
        int expectedCountFromGanglia30 = this.expectedMetrics.length;
        int expectedCountFromGanglia31 = 2 * this.expectedMetrics.length;
        GangliaSink30 gsink30 = new GangliaSink30();
        ((AbstractGangliaSink)gsink30).init(cb.subset("test"));
        MockDatagramSocket mockds30 = new MockDatagramSocket();
        GangliaMetricsTestHelper.setDatagramSocket(gsink30, mockds30);
        GangliaSink31 gsink31 = new GangliaSink31();
        ((AbstractGangliaSink)gsink31).init(cb.subset("test"));
        MockDatagramSocket mockds31 = new MockDatagramSocket();
        GangliaMetricsTestHelper.setDatagramSocket(gsink31, mockds31);
        ms.register("gsink30", "gsink30 desc", gsink30);
        ms.register("gsink31", "gsink31 desc", gsink31);
        ms.publishMetricsNow();
        ms.stop();
        this.checkMetrics(mockds30.getCapturedSend(), expectedCountFromGanglia30);
        this.checkMetrics(mockds31.getCapturedSend(), expectedCountFromGanglia31);
    }

    private void checkMetrics(List<byte[]> bytearrlist, int expectedCount) {
        boolean[] foundMetrics = new boolean[this.expectedMetrics.length];
        block0: for (byte[] bytes : bytearrlist) {
            String binaryStr = new String(bytes);
            for (int index = 0; index < this.expectedMetrics.length; ++index) {
                if (binaryStr.indexOf(this.expectedMetrics[index]) < 0) continue;
                foundMetrics[index] = true;
                continue block0;
            }
        }
        for (int index = 0; index < foundMetrics.length; ++index) {
            if (foundMetrics[index]) continue;
            Assert.assertTrue((String)("Missing metrics: " + this.expectedMetrics[index]), (boolean)false);
        }
        Assert.assertEquals((String)"Mismatch in record count: ", (long)expectedCount, (long)bytearrlist.size());
    }

    private class MockDatagramSocket
    extends DatagramSocket {
        private ArrayList<byte[]> capture = new ArrayList();

        @Override
        public void send(DatagramPacket p) throws IOException {
            byte[] bytes = new byte[p.getLength()];
            System.arraycopy(p.getData(), p.getOffset(), bytes, 0, p.getLength());
            this.capture.add(bytes);
        }

        ArrayList<byte[]> getCapturedSend() {
            return this.capture;
        }
    }

    @Metrics(context="test")
    private static class TestSource {
        @Metric(value={"C1 desc"})
        MutableCounterLong c1;
        @Metric(value={"XXX desc"})
        MutableCounterLong xxx;
        @Metric(value={"G1 desc"})
        MutableGaugeLong g1;
        @Metric(value={"YYY desc"})
        MutableGaugeLong yyy;
        @Metric
        MutableRate s1;
        final MetricsRegistry registry;

        TestSource(String recName) {
            this.registry = new MetricsRegistry(recName);
        }
    }
}

