/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.Interns;
import org.junit.Assert;
import org.junit.Test;

public class TestInterns {
    @Test
    public void testInfo() {
        MetricsInfo info = Interns.info("m", "m desc");
        Assert.assertSame((String)"same info", (Object)info, (Object)Interns.info("m", "m desc"));
    }

    @Test
    public void testTag() {
        MetricsTag tag = Interns.tag("t", "t desc", "t value");
        Assert.assertSame((String)"same tag", (Object)tag, (Object)Interns.tag("t", "t desc", "t value"));
    }

    @Test
    public void testInfoOverflow() {
        MetricsInfo i0 = Interns.info("m0", "m desc");
        for (int i = 0; i < 2011; ++i) {
            Interns.info("m" + i, "m desc");
            if (i >= 2010) continue;
            Assert.assertSame((String)"m0 is still there", (Object)i0, (Object)Interns.info("m0", "m desc"));
        }
        Assert.assertNotSame((String)"m0 is gone", (Object)i0, (Object)Interns.info("m0", "m desc"));
        MetricsInfo i1 = Interns.info("m1", "m desc");
        for (int i = 0; i < 100; ++i) {
            Interns.info("m1", "m desc" + i);
            if (i >= 99) continue;
            Assert.assertSame((String)"i1 is still there", (Object)i1, (Object)Interns.info("m1", "m desc"));
        }
        Assert.assertNotSame((String)"i1 is gone", (Object)i1, (Object)Interns.info("m1", "m desc"));
    }

    @Test
    public void testTagOverflow() {
        MetricsTag t0 = Interns.tag("t0", "t desc", "t value");
        for (int i = 0; i < 101; ++i) {
            Interns.tag("t" + i, "t desc", "t value");
            if (i >= 100) continue;
            Assert.assertSame((String)"t0 still there", (Object)t0, (Object)Interns.tag("t0", "t desc", "t value"));
        }
        Assert.assertNotSame((String)"t0 is gone", (Object)t0, (Object)Interns.tag("t0", "t desc", "t value"));
        MetricsTag t1 = Interns.tag("t1", "t desc", "t value");
        for (int i = 0; i < 1000; ++i) {
            Interns.tag("t1", "t desc", "t value" + i);
            if (i >= 999) continue;
            Assert.assertSame((String)"t1 is still there", (Object)t1, (Object)Interns.tag("t1", "t desc", "t value"));
        }
        Assert.assertNotSame((String)"t1 is gone", (Object)t1, (Object)Interns.tag("t1", "t desc", "t value"));
    }
}

