/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.AbstractDNSToSwitchMapping;

public class StaticMapping
extends AbstractDNSToSwitchMapping {
    public static final String KEY_HADOOP_CONFIGURED_NODE_MAPPING = "hadoop.configured.node.mapping";
    private static final Map<String, String> nameToRackMap = new HashMap<String, String>();

    @Override
    public void setConf(Configuration conf) {
        String[] mappings;
        super.setConf(conf);
        if (conf != null && (mappings = conf.getStrings(KEY_HADOOP_CONFIGURED_NODE_MAPPING)) != null) {
            for (String str : mappings) {
                String host = str.substring(0, str.indexOf(61));
                String rack = str.substring(str.indexOf(61) + 1);
                StaticMapping.addNodeToRack(host, rack);
            }
        }
    }

    public void setconf(Configuration conf) {
        this.setConf(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNodeToRack(String name, String rackId) {
        Map<String, String> map = nameToRackMap;
        synchronized (map) {
            nameToRackMap.put(name, rackId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> resolve(List<String> names) {
        ArrayList<String> m = new ArrayList<String>();
        Map<String, String> map = nameToRackMap;
        synchronized (map) {
            for (String name : names) {
                String rackId = nameToRackMap.get(name);
                if (rackId != null) {
                    m.add(rackId);
                    continue;
                }
                m.add("/default-rack");
            }
            return m;
        }
    }

    @Override
    public boolean isSingleSwitch() {
        return this.isSingleSwitchByScriptPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getSwitchMap() {
        Map<String, String> map = nameToRackMap;
        synchronized (map) {
            return new HashMap<String, String>(nameToRackMap);
        }
    }

    public String toString() {
        return "static mapping with single switch = " + this.isSingleSwitch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetMap() {
        Map<String, String> map = nameToRackMap;
        synchronized (map) {
            nameToRackMap.clear();
        }
    }

    @Override
    public void reloadCachedMappings() {
    }

    @Override
    public void reloadCachedMappings(List<String> names) {
    }
}

