/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.AbstractDNSToSwitchMapping;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.junit.Test;

public class TestScriptBasedMapping
extends TestCase {
    @Test
    public void testNoArgsMeansNoResult() {
        Configuration conf = new Configuration();
        conf.setInt("net.topology.script.number.args", 0);
        conf.set("net.topology.script.file.name", "any-filename");
        conf.set("net.topology.script.file.name", "any-filename");
        ScriptBasedMapping mapping = this.createMapping(conf);
        ArrayList<String> names = new ArrayList<String>();
        names.add("some.machine.name");
        names.add("other.machine.name");
        List<String> result = mapping.resolve(names);
        TestScriptBasedMapping.assertNull((String)"Expected an empty list", result);
    }

    @Test
    public void testNoFilenameMeansSingleSwitch() throws Throwable {
        Configuration conf = new Configuration();
        ScriptBasedMapping mapping = this.createMapping(conf);
        TestScriptBasedMapping.assertTrue((String)"Expected to be single switch", (boolean)mapping.isSingleSwitch());
        TestScriptBasedMapping.assertTrue((String)"Expected to be single switch", (boolean)AbstractDNSToSwitchMapping.isMappingSingleSwitch(mapping));
    }

    @Test
    public void testFilenameMeansMultiSwitch() throws Throwable {
        Configuration conf = new Configuration();
        conf.set("net.topology.script.file.name", "any-filename");
        ScriptBasedMapping mapping = this.createMapping(conf);
        TestScriptBasedMapping.assertFalse((String)"Expected to be multi switch", (boolean)mapping.isSingleSwitch());
        mapping.setConf(new Configuration());
        TestScriptBasedMapping.assertTrue((String)"Expected to be single switch", (boolean)mapping.isSingleSwitch());
    }

    @Test
    public void testNullConfig() throws Throwable {
        ScriptBasedMapping mapping = this.createMapping(null);
        TestScriptBasedMapping.assertTrue((String)"Expected to be single switch", (boolean)mapping.isSingleSwitch());
    }

    private ScriptBasedMapping createMapping(Configuration conf) {
        ScriptBasedMapping mapping = new ScriptBasedMapping();
        mapping.setConf(conf);
        return mapping;
    }
}

