/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.channels.Pipe;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestSocketIOWithTimeout {
    static Log LOG = LogFactory.getLog(TestSocketIOWithTimeout.class);
    private static int TIMEOUT = 1000;
    private static String TEST_STRING = "1234567890";
    private MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();

    private void doIO(InputStream in, OutputStream out, int expectedTimeout) throws IOException {
        byte[] buf = new byte[4192];
        while (true) {
            long start = Time.now();
            try {
                if (in != null) {
                    in.read(buf);
                    continue;
                }
                out.write(buf);
            }
            catch (SocketTimeoutException e) {
                long diff = Time.now() - start;
                LOG.info((Object)("Got SocketTimeoutException as expected after " + diff + " millis : " + e.getMessage()));
                Assert.assertTrue((Math.abs((long)expectedTimeout - diff) <= 200L ? 1 : 0) != 0);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSocketIOWithTimeout() throws Exception {
        Pipe pipe = Pipe.open();
        Pipe.SourceChannel source = pipe.source();
        Pipe.SinkChannel sink = pipe.sink();
        try {
            final SocketInputStream in = new SocketInputStream(source, (long)TIMEOUT);
            SocketOutputStream out = new SocketOutputStream(sink, (long)TIMEOUT);
            byte[] writeBytes = TEST_STRING.getBytes();
            byte[] readBytes = new byte[writeBytes.length];
            int byteWithHighBit = -128;
            out.write(writeBytes);
            ((OutputStream)out).write(byteWithHighBit);
            this.doIO(null, out, TIMEOUT);
            in.read(readBytes);
            Assert.assertTrue((boolean)Arrays.equals(writeBytes, readBytes));
            Assert.assertEquals((long)(byteWithHighBit & 0xFF), (long)((InputStream)in).read());
            this.doIO(in, null, TIMEOUT);
            in.setTimeout(TIMEOUT * 2);
            this.doIO(in, null, TIMEOUT * 2);
            in.setTimeout(0L);
            MultithreadedTestUtil.TestingThread thread = new MultithreadedTestUtil.TestingThread(this.ctx){

                @Override
                public void doWork() throws Exception {
                    try {
                        in.read();
                        Assert.fail((String)"Did not fail with interrupt");
                    }
                    catch (InterruptedIOException ste) {
                        LOG.info((Object)("Got expection while reading as expected : " + ste.getMessage()));
                    }
                }
            };
            this.ctx.addThread(thread);
            this.ctx.startThreads();
            Thread.sleep(1000L);
            thread.interrupt();
            this.ctx.stop();
            Assert.assertTrue((boolean)source.isOpen());
            Assert.assertTrue((boolean)sink.isOpen());
            if (!Shell.WINDOWS) {
                try {
                    ((OutputStream)out).write(1);
                    Assert.fail((String)"Did not throw");
                }
                catch (IOException ioe) {
                    GenericTestUtils.assertExceptionContains("stream is closed", ioe);
                }
            }
            ((OutputStream)out).close();
            Assert.assertFalse((boolean)sink.isOpen());
            Assert.assertEquals((long)-1L, (long)((InputStream)in).read());
            ((InputStream)in).close();
            Assert.assertFalse((boolean)source.isOpen());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (sink != null) {
                sink.close();
            }
        }
    }
}

