/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;

public class BreakableStateChangeListener
implements ServiceStateChangeListener {
    private final String name;
    private int eventCount;
    private int failureCount;
    private Service lastService;
    private Service.STATE lastState = Service.STATE.NOTINITED;
    private Service.STATE failingState = Service.STATE.NOTINITED;
    private List<Service.STATE> stateEventList = new ArrayList<Service.STATE>(4);

    public BreakableStateChangeListener() {
        this("BreakableStateChangeListener");
    }

    public BreakableStateChangeListener(String name) {
        this.name = name;
    }

    @Override
    public synchronized void stateChanged(Service service) {
        ++this.eventCount;
        this.lastService = service;
        this.lastState = service.getServiceState();
        this.stateEventList.add(this.lastState);
        if (this.lastState == this.failingState) {
            ++this.failureCount;
            throw new BreakableService.BrokenLifecycleEvent(service, "Failure entering " + (Object)((Object)this.lastState) + " for " + service.getName());
        }
    }

    public synchronized int getEventCount() {
        return this.eventCount;
    }

    public synchronized Service getLastService() {
        return this.lastService;
    }

    public synchronized Service.STATE getLastState() {
        return this.lastState;
    }

    public synchronized void setFailingState(Service.STATE failingState) {
        this.failingState = failingState;
    }

    public synchronized int getFailureCount() {
        return this.failureCount;
    }

    public List<Service.STATE> getStateEventList() {
        return this.stateEventList;
    }

    public synchronized String toString() {
        String s = this.name + " - event count = " + this.eventCount + " last state " + (Object)((Object)this.lastState);
        StringBuilder history = new StringBuilder(this.stateEventList.size() * 10);
        for (Service.STATE state : this.stateEventList) {
            history.append((Object)state).append(" ");
        }
        return s + " [ " + history + "]";
    }
}

