/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.util.RunJar;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestRunJar
extends TestCase {
    private File TEST_ROOT_DIR;
    private static final String TEST_JAR_NAME = "test-runjar.jar";

    @Before
    protected void setUp() throws Exception {
        this.TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp"), ((Object)((Object)this)).getClass().getSimpleName());
        if (!this.TEST_ROOT_DIR.exists()) {
            this.TEST_ROOT_DIR.mkdirs();
        }
        this.makeTestJar();
    }

    @After
    protected void tearDown() {
        FileUtil.fullyDelete(this.TEST_ROOT_DIR);
    }

    private void makeTestJar() throws IOException {
        File jarFile = new File(this.TEST_ROOT_DIR, TEST_JAR_NAME);
        JarOutputStream jstream = new JarOutputStream(new FileOutputStream(jarFile));
        jstream.putNextEntry(new ZipEntry("foobar.txt"));
        jstream.closeEntry();
        jstream.putNextEntry(new ZipEntry("foobaz.txt"));
        jstream.closeEntry();
        jstream.close();
    }

    @Test
    public void testUnJar() throws Exception {
        File unjarDir = new File(this.TEST_ROOT_DIR, "unjar-all");
        TestRunJar.assertFalse((String)"unjar dir shouldn't exist at test start", (boolean)new File(unjarDir, "foobar.txt").exists());
        RunJar.unJar(new File(this.TEST_ROOT_DIR, TEST_JAR_NAME), unjarDir);
        TestRunJar.assertTrue((String)"foobar unpacked", (boolean)new File(unjarDir, "foobar.txt").exists());
        TestRunJar.assertTrue((String)"foobaz unpacked", (boolean)new File(unjarDir, "foobaz.txt").exists());
    }

    public void testUnJarWithPattern() throws Exception {
        File unjarDir = new File(this.TEST_ROOT_DIR, "unjar-pattern");
        TestRunJar.assertFalse((String)"unjar dir shouldn't exist at test start", (boolean)new File(unjarDir, "foobar.txt").exists());
        RunJar.unJar(new File(this.TEST_ROOT_DIR, TEST_JAR_NAME), unjarDir, Pattern.compile(".*baz.*"));
        TestRunJar.assertFalse((String)"foobar not unpacked", (boolean)new File(unjarDir, "foobar.txt").exists());
        TestRunJar.assertTrue((String)"foobaz unpacked", (boolean)new File(unjarDir, "foobaz.txt").exists());
    }
}

