/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.hash;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.hash.Hash;
import org.apache.hadoop.util.hash.JenkinsHash;
import org.apache.hadoop.util.hash.MurmurHash;
import org.junit.Assert;
import org.junit.Test;

public class TestHash {
    static final String LINE = "34563@45kjkksdf/ljfdb9d8fbusd*89uggjsk<dfgjsdfh@sddc2q3esc";

    @Test
    public void testHash() {
        int i;
        int i2;
        int iterations = 30;
        Assert.assertTrue((String)"testHash jenkins error !!!", (0 == Hash.parseHashType("jenkins") ? 1 : 0) != 0);
        Assert.assertTrue((String)"testHash murmur error !!!", (1 == Hash.parseHashType("murmur") ? 1 : 0) != 0);
        Assert.assertTrue((String)"testHash undefined", (-1 == Hash.parseHashType("undefined") ? 1 : 0) != 0);
        Configuration cfg = new Configuration();
        cfg.set("hadoop.util.hash.type", "murmur");
        Assert.assertTrue((String)"testHash", (MurmurHash.getInstance() == Hash.getInstance(cfg) ? 1 : 0) != 0);
        cfg = new Configuration();
        cfg.set("hadoop.util.hash.type", "jenkins");
        Assert.assertTrue((String)"testHash jenkins configuration error !!!", (JenkinsHash.getInstance() == Hash.getInstance(cfg) ? 1 : 0) != 0);
        cfg = new Configuration();
        Assert.assertTrue((String)"testHash undefine configuration error !!!", (MurmurHash.getInstance() == Hash.getInstance(cfg) ? 1 : 0) != 0);
        Assert.assertTrue((String)"testHash error jenkin getInstance !!!", (JenkinsHash.getInstance() == Hash.getInstance(0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"testHash error murmur getInstance !!!", (MurmurHash.getInstance() == Hash.getInstance(1) ? 1 : 0) != 0);
        Assert.assertNull((String)"testHash error invalid getInstance !!!", (Object)Hash.getInstance(-1));
        int murmurHash = Hash.getInstance(1).hash(LINE.getBytes());
        for (i2 = 0; i2 < iterations; ++i2) {
            Assert.assertTrue((String)"multiple evaluation murmur hash error !!!", (murmurHash == Hash.getInstance(1).hash(LINE.getBytes()) ? 1 : 0) != 0);
        }
        murmurHash = Hash.getInstance(1).hash(LINE.getBytes(), 67);
        for (i2 = 0; i2 < iterations; ++i2) {
            Assert.assertTrue((String)"multiple evaluation murmur hash error !!!", (murmurHash == Hash.getInstance(1).hash(LINE.getBytes(), 67) ? 1 : 0) != 0);
        }
        int jenkinsHash = Hash.getInstance(0).hash(LINE.getBytes());
        for (i = 0; i < iterations; ++i) {
            Assert.assertTrue((String)"multiple evaluation jenkins hash error !!!", (jenkinsHash == Hash.getInstance(0).hash(LINE.getBytes()) ? 1 : 0) != 0);
        }
        jenkinsHash = Hash.getInstance(0).hash(LINE.getBytes(), 67);
        for (i = 0; i < iterations; ++i) {
            Assert.assertTrue((String)"multiple evaluation jenkins hash error !!!", (jenkinsHash == Hash.getInstance(0).hash(LINE.getBytes(), 67) ? 1 : 0) != 0);
        }
    }
}

