/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import org.apache.hadoop.yarn.server.api.ApplicationContext;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSController;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebServices;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.TimelineWebServices;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.apache.hadoop.yarn.webapp.YarnWebParams;

public class AHSWebApp
extends WebApp
implements YarnWebParams {
    private final ApplicationHistoryManager applicationHistoryManager;
    private final TimelineStore timelineStore;

    public AHSWebApp(ApplicationHistoryManager applicationHistoryManager, TimelineStore timelineStore) {
        this.applicationHistoryManager = applicationHistoryManager;
        this.timelineStore = timelineStore;
    }

    @Override
    public void setup() {
        this.bind(YarnJacksonJaxbJsonProvider.class);
        this.bind(AHSWebServices.class);
        this.bind(TimelineWebServices.class);
        this.bind(GenericExceptionHandler.class);
        this.bind(ApplicationContext.class).toInstance((Object)this.applicationHistoryManager);
        this.bind(TimelineStore.class).toInstance((Object)this.timelineStore);
        this.route("/", AHSController.class);
        this.route(StringHelper.pajoin("/apps", "app.state"), AHSController.class);
        this.route(StringHelper.pajoin("/app", "app.id"), AHSController.class, "app");
        this.route(StringHelper.pajoin("/appattempt", "appattempt.id"), AHSController.class, "appattempt");
        this.route(StringHelper.pajoin("/container", "container.id"), AHSController.class, "container");
        this.route(StringHelper.pajoin("/logs", "nm.id", "container.id", "entity.string", "app.owner", "log.type"), AHSController.class, "logs");
    }
}

