/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ContainerLocalizer;
import org.apache.hadoop.yarn.server.nodemanager.util.DefaultLCEResourcesHandler;
import org.apache.hadoop.yarn.server.nodemanager.util.LCEResourcesHandler;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class LinuxContainerExecutor
extends ContainerExecutor {
    private static final Log LOG = LogFactory.getLog(LinuxContainerExecutor.class);
    private String nonsecureLocalUser;
    private Pattern nonsecureLocalUserPattern;
    private String containerExecutorExe;
    private LCEResourcesHandler resourcesHandler;
    private boolean containerSchedPriorityIsSet = false;
    private int containerSchedPriorityAdjustment = 0;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.containerExecutorExe = this.getContainerExecutorExecutablePath(conf);
        this.resourcesHandler = ReflectionUtils.newInstance(conf.getClass("yarn.nodemanager.linux-container-executor.resources-handler.class", DefaultLCEResourcesHandler.class, LCEResourcesHandler.class), conf);
        this.resourcesHandler.setConf(conf);
        if (conf.get("yarn.nodemanager.container-executor.os.sched.priority.adjustment") != null) {
            this.containerSchedPriorityIsSet = true;
            this.containerSchedPriorityAdjustment = conf.getInt("yarn.nodemanager.container-executor.os.sched.priority.adjustment", 0);
        }
        this.nonsecureLocalUser = conf.get("yarn.nodemanager.linux-container-executor.nonsecure-mode.local-user", "nobody");
        this.nonsecureLocalUserPattern = Pattern.compile(conf.get("yarn.nodemanager.linux-container-executor.nonsecure-mode.user-pattern", "^[_.A-Za-z0-9][-@_.A-Za-z0-9]{0,255}?[$]?$"));
    }

    void verifyUsernamePattern(String user) {
        if (!UserGroupInformation.isSecurityEnabled() && !this.nonsecureLocalUserPattern.matcher(user).matches()) {
            throw new IllegalArgumentException("Invalid user name '" + user + "'," + " it must match '" + this.nonsecureLocalUserPattern.pattern() + "'");
        }
    }

    String getRunAsUser(String user) {
        return UserGroupInformation.isSecurityEnabled() ? user : this.nonsecureLocalUser;
    }

    protected String getContainerExecutorExecutablePath(Configuration conf) {
        String yarnHomeEnvVar = System.getenv(ApplicationConstants.Environment.HADOOP_YARN_HOME.key());
        File hadoopBin = new File(yarnHomeEnvVar, "bin");
        String defaultPath = new File(hadoopBin, "container-executor").getAbsolutePath();
        return null == conf ? defaultPath : conf.get("yarn.nodemanager.linux-container-executor.path", defaultPath);
    }

    protected void addSchedPriorityCommand(List<String> command) {
        if (this.containerSchedPriorityIsSet) {
            command.addAll(Arrays.asList("nice", "-n", Integer.toString(this.containerSchedPriorityAdjustment)));
        }
    }

    @Override
    public void init() throws IOException {
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.containerExecutorExe, "--checksetup"));
        Object[] commandArray = command.toArray(new String[command.size()]);
        Shell.ShellCommandExecutor shExec = new Shell.ShellCommandExecutor((String[])commandArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("checkLinuxExecutorSetup: " + Arrays.toString(commandArray)));
        }
        try {
            shExec.execute();
        }
        catch (Shell.ExitCodeException e) {
            int exitCode = shExec.getExitCode();
            LOG.warn((Object)("Exit code from container executor initialization is : " + exitCode), (Throwable)e);
            this.logOutput(shExec.getOutput());
            throw new IOException("Linux container executor not configured properly (error=" + exitCode + ")", e);
        }
        this.resourcesHandler.init(this);
    }

    @Override
    public void startLocalizer(Path nmPrivateContainerTokensPath, InetSocketAddress nmAddr, String user, String appId, String locId, List<String> localDirs, List<String> logDirs) throws IOException, InterruptedException {
        this.verifyUsernamePattern(user);
        String runAsUser = this.getRunAsUser(user);
        ArrayList<String> command = new ArrayList<String>();
        this.addSchedPriorityCommand(command);
        command.addAll(Arrays.asList(this.containerExecutorExe, runAsUser, user, Integer.toString(Commands.INITIALIZE_CONTAINER.getValue()), appId, nmPrivateContainerTokensPath.toUri().getPath().toString(), StringUtils.join((CharSequence)",", localDirs), StringUtils.join((CharSequence)",", logDirs)));
        File jvm = new File(new File(System.getProperty("java.home"), "bin"), "java");
        command.add(jvm.toString());
        command.add("-classpath");
        command.add(System.getProperty("java.class.path"));
        String javaLibPath = System.getProperty("java.library.path");
        if (javaLibPath != null) {
            command.add("-Djava.library.path=" + javaLibPath);
        }
        command.add(ContainerLocalizer.class.getName());
        command.add(user);
        command.add(appId);
        command.add(locId);
        command.add(nmAddr.getHostName());
        command.add(Integer.toString(nmAddr.getPort()));
        for (String dir : localDirs) {
            command.add(dir);
        }
        Object[] commandArray = command.toArray(new String[command.size()]);
        Shell.ShellCommandExecutor shExec = new Shell.ShellCommandExecutor((String[])commandArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("initApplication: " + Arrays.toString(commandArray)));
        }
        try {
            shExec.execute();
            if (LOG.isDebugEnabled()) {
                this.logOutput(shExec.getOutput());
            }
        }
        catch (Shell.ExitCodeException e) {
            int exitCode = shExec.getExitCode();
            LOG.warn((Object)("Exit code from container " + locId + " startLocalizer is : " + exitCode), (Throwable)e);
            this.logOutput(shExec.getOutput());
            throw new IOException("Application " + appId + " initialization failed" + " (exitCode=" + exitCode + ") with output: " + shExec.getOutput(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int launchContainer(Container container, Path nmPrivateCotainerScriptPath, Path nmPrivateTokensPath, String user, String appId, Path containerWorkDir, List<String> localDirs, List<String> logDirs) throws IOException {
        Shell shExec;
        block13: {
            this.verifyUsernamePattern(user);
            String runAsUser = this.getRunAsUser(user);
            ContainerId containerId = container.getContainerId();
            String containerIdStr = ConverterUtils.toString(containerId);
            this.resourcesHandler.preExecute(containerId, container.getResource());
            String resourcesOptions = this.resourcesHandler.getResourcesOption(containerId);
            shExec = null;
            try {
                Path pidFilePath = this.getPidFilePath(containerId);
                if (pidFilePath != null) {
                    ArrayList<String> command = new ArrayList<String>();
                    this.addSchedPriorityCommand(command);
                    command.addAll(Arrays.asList(this.containerExecutorExe, runAsUser, user, Integer.toString(Commands.LAUNCH_CONTAINER.getValue()), appId, containerIdStr, containerWorkDir.toString(), nmPrivateCotainerScriptPath.toUri().getPath().toString(), nmPrivateTokensPath.toUri().getPath().toString(), pidFilePath.toString(), StringUtils.join((CharSequence)",", localDirs), StringUtils.join((CharSequence)",", logDirs), resourcesOptions));
                    Object[] commandArray = command.toArray(new String[command.size()]);
                    shExec = new Shell.ShellCommandExecutor((String[])commandArray, null, container.getLaunchContext().getEnvironment());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("launchContainer: " + Arrays.toString(commandArray)));
                    }
                    ((Shell.ShellCommandExecutor)shExec).execute();
                    if (LOG.isDebugEnabled()) {
                        this.logOutput(((Shell.ShellCommandExecutor)shExec).getOutput());
                    }
                    break block13;
                }
                LOG.info((Object)"Container was marked as inactive. Returning terminated error");
                int command = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
                return command;
            }
            catch (Shell.ExitCodeException e) {
                if (null == shExec) {
                    int command = -1;
                    return command;
                }
                int exitCode = shExec.getExitCode();
                LOG.warn((Object)("Exit code from container " + containerId + " is : " + exitCode));
                if (exitCode != ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() && exitCode != ContainerExecutor.ExitCode.TERMINATED.getExitCode()) {
                    LOG.warn((Object)("Exception from container-launch with container ID: " + containerId + " and exit code: " + exitCode), (Throwable)e);
                    this.logOutput(((Shell.ShellCommandExecutor)shExec).getOutput());
                    String diagnostics = "Exception from container-launch: \n" + StringUtils.stringifyException(e) + "\n" + ((Shell.ShellCommandExecutor)shExec).getOutput();
                    container.handle(new ContainerDiagnosticsUpdateEvent(containerId, diagnostics));
                } else {
                    container.handle(new ContainerDiagnosticsUpdateEvent(containerId, "Container killed on request. Exit code is " + exitCode));
                }
                int n = exitCode;
                return n;
            }
            finally {
                this.resourcesHandler.postExecute(containerId);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Output from LinuxContainerExecutor's launchContainer follows:");
            this.logOutput(((Shell.ShellCommandExecutor)shExec).getOutput());
        }
        return 0;
    }

    @Override
    public boolean signalContainer(String user, String pid, ContainerExecutor.Signal signal) throws IOException {
        this.verifyUsernamePattern(user);
        String runAsUser = this.getRunAsUser(user);
        Object[] command = new String[]{this.containerExecutorExe, runAsUser, user, Integer.toString(Commands.SIGNAL_CONTAINER.getValue()), pid, Integer.toString(signal.getValue())};
        Shell.ShellCommandExecutor shExec = new Shell.ShellCommandExecutor((String[])command);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("signalContainer: " + Arrays.toString(command)));
        }
        try {
            shExec.execute();
        }
        catch (Shell.ExitCodeException e) {
            int ret_code = shExec.getExitCode();
            if (ret_code == ResultCode.INVALID_CONTAINER_PID.getValue()) {
                return false;
            }
            LOG.warn((Object)("Error in signalling container " + pid + " with " + (Object)((Object)signal) + "; exit = " + ret_code), (Throwable)e);
            this.logOutput(shExec.getOutput());
            throw new IOException("Problem signalling container " + pid + " with " + (Object)((Object)signal) + "; output: " + shExec.getOutput() + " and exitCode: " + ret_code, e);
        }
        return true;
    }

    @Override
    public void deleteAsUser(String user, Path dir, Path ... baseDirs) {
        this.verifyUsernamePattern(user);
        String runAsUser = this.getRunAsUser(user);
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.containerExecutorExe, runAsUser, user, Integer.toString(Commands.DELETE_AS_USER.getValue()), dir == null ? "" : dir.toUri().getPath()));
        if (baseDirs == null || baseDirs.length == 0) {
            LOG.info((Object)("Deleting absolute path : " + dir));
        } else {
            for (Path baseDir : baseDirs) {
                Path del = dir == null ? baseDir : new Path(baseDir, dir);
                LOG.info((Object)("Deleting path : " + del));
                command.add(baseDir.toUri().getPath());
            }
        }
        Object[] commandArray = command.toArray(new String[command.size()]);
        Shell.ShellCommandExecutor shExec = new Shell.ShellCommandExecutor((String[])commandArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleteAsUser: " + Arrays.toString(commandArray)));
        }
        try {
            shExec.execute();
            if (LOG.isDebugEnabled()) {
                this.logOutput(shExec.getOutput());
            }
        }
        catch (IOException e) {
            int exitCode = shExec.getExitCode();
            LOG.error((Object)("DeleteAsUser for " + dir.toUri().getPath() + " returned with exit code: " + exitCode), (Throwable)e);
            LOG.error((Object)"Output from LinuxContainerExecutor's deleteAsUser follows:");
            this.logOutput(shExec.getOutput());
        }
    }

    public void mountCgroups(List<String> cgroupKVs, String hierarchy) throws IOException {
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.containerExecutorExe, "--mount-cgroups", hierarchy));
        command.addAll(cgroupKVs);
        Object[] commandArray = command.toArray(new String[command.size()]);
        Shell.ShellCommandExecutor shExec = new Shell.ShellCommandExecutor((String[])commandArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mountCgroups: " + Arrays.toString(commandArray)));
        }
        try {
            shExec.execute();
        }
        catch (IOException e) {
            int ret_code = shExec.getExitCode();
            LOG.warn((Object)"Exception in LinuxContainerExecutor mountCgroups ", (Throwable)e);
            this.logOutput(shExec.getOutput());
            throw new IOException("Problem mounting cgroups " + cgroupKVs + "; exit code = " + ret_code + " and output: " + shExec.getOutput(), e);
        }
    }

    static enum ResultCode {
        OK(0),
        INVALID_USER_NAME(2),
        UNABLE_TO_EXECUTE_CONTAINER_SCRIPT(7),
        INVALID_CONTAINER_PID(9),
        INVALID_CONTAINER_EXEC_PERMISSIONS(22),
        INVALID_CONFIG_FILE(24),
        WRITE_CGROUP_FAILED(27);

        private final int value;

        private ResultCode(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    static enum Commands {
        INITIALIZE_CONTAINER(0),
        LAUNCH_CONTAINER(1),
        SIGNAL_CONTAINER(2),
        DELETE_AS_USER(3);

        private int value;

        private Commands(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

