/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.NMAuditLogger;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResourceFailedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResourceLocalizedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationCleanupEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainerStartMonitoringEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainerStopMonitoringEvent;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class ContainerImpl
implements Container {
    private final Lock readLock;
    private final Lock writeLock;
    private final Dispatcher dispatcher;
    private final Credentials credentials;
    private final NodeManagerMetrics metrics;
    private final ContainerLaunchContext launchContext;
    private final ContainerTokenIdentifier containerTokenIdentifier;
    private final ContainerId containerId;
    private final Resource resource;
    private final String user;
    private int exitCode = -1000;
    private final StringBuilder diagnostics;
    private boolean wasLaunched;
    private final Configuration daemonConf;
    private static final Log LOG = LogFactory.getLog(Container.class);
    private final Map<LocalResourceRequest, List<String>> pendingResources = new HashMap<LocalResourceRequest, List<String>>();
    private final Map<Path, List<String>> localizedResources = new HashMap<Path, List<String>>();
    private final List<LocalResourceRequest> publicRsrcs = new ArrayList<LocalResourceRequest>();
    private final List<LocalResourceRequest> privateRsrcs = new ArrayList<LocalResourceRequest>();
    private final List<LocalResourceRequest> appRsrcs = new ArrayList<LocalResourceRequest>();
    private static final ContainerDoneTransition CONTAINER_DONE_TRANSITION = new ContainerDoneTransition();
    private static final ContainerDiagnosticsUpdateTransition UPDATE_DIAGNOSTICS_TRANSITION = new ContainerDiagnosticsUpdateTransition();
    private static StateMachineFactory<ContainerImpl, ContainerState, ContainerEventType, ContainerEvent> stateMachineFactory = new StateMachineFactory<ContainerImpl, ContainerState, ContainerEventType, ContainerEvent>(ContainerState.NEW).addTransition(ContainerState.NEW, EnumSet.of(ContainerState.LOCALIZING, ContainerState.LOCALIZED, ContainerState.LOCALIZATION_FAILED), ContainerEventType.INIT_CONTAINER, new RequestResourcesTransition()).addTransition(ContainerState.NEW, ContainerState.NEW, ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition<ContainerImpl, ContainerEvent>)UPDATE_DIAGNOSTICS_TRANSITION).addTransition(ContainerState.NEW, ContainerState.DONE, ContainerEventType.KILL_CONTAINER, (SingleArcTransition<ContainerImpl, ContainerEvent>)new KillOnNewTransition()).addTransition(ContainerState.LOCALIZING, EnumSet.of(ContainerState.LOCALIZING, ContainerState.LOCALIZED), ContainerEventType.RESOURCE_LOCALIZED, new LocalizedTransition()).addTransition(ContainerState.LOCALIZING, ContainerState.LOCALIZATION_FAILED, ContainerEventType.RESOURCE_FAILED, (SingleArcTransition<ContainerImpl, ContainerEvent>)new ResourceFailedTransition()).addTransition(ContainerState.LOCALIZING, ContainerState.LOCALIZING, ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition<ContainerImpl, ContainerEvent>)UPDATE_DIAGNOSTICS_TRANSITION).addTransition(ContainerState.LOCALIZING, ContainerState.KILLING, ContainerEventType.KILL_CONTAINER, (SingleArcTransition<ContainerImpl, ContainerEvent>)new KillDuringLocalizationTransition()).addTransition(ContainerState.LOCALIZATION_FAILED, ContainerState.DONE, ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition<ContainerImpl, ContainerEvent>)CONTAINER_DONE_TRANSITION).addTransition(ContainerState.LOCALIZATION_FAILED, ContainerState.LOCALIZATION_FAILED, ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition<ContainerImpl, ContainerEvent>)UPDATE_DIAGNOSTICS_TRANSITION).addTransition(ContainerState.LOCALIZATION_FAILED, ContainerState.LOCALIZATION_FAILED, ContainerEventType.KILL_CONTAINER).addTransition(ContainerState.LOCALIZATION_FAILED, ContainerState.LOCALIZATION_FAILED, ContainerEventType.RESOURCE_LOCALIZED).addTransition(ContainerState.LOCALIZATION_FAILED, ContainerState.LOCALIZATION_FAILED, ContainerEventType.RESOURCE_FAILED).addTransition(ContainerState.LOCALIZED, ContainerState.RUNNING, ContainerEventType.CONTAINER_LAUNCHED, (SingleArcTransition<ContainerImpl, ContainerEvent>)new LaunchTransition()).addTransition(ContainerState.LOCALIZED, ContainerState.EXITED_WITH_FAILURE, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition<ContainerImpl, ContainerEvent>)new ExitedWithFailureTransition(true)).addTransition(ContainerState.LOCALIZED, ContainerState.LOCALIZED, ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition<ContainerImpl, ContainerEvent>)UPDATE_DIAGNOSTICS_TRANSITION).addTransition(ContainerState.LOCALIZED, ContainerState.KILLING, ContainerEventType.KILL_CONTAINER, (SingleArcTransition<ContainerImpl, ContainerEvent>)new KillTransition()).addTransition(ContainerState.RUNNING, ContainerState.EXITED_WITH_SUCCESS, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, (SingleArcTransition<ContainerImpl, ContainerEvent>)new ExitedWithSuccessTransition(true)).addTransition(ContainerState.RUNNING, ContainerState.EXITED_WITH_FAILURE, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition<ContainerImpl, ContainerEvent>)new ExitedWithFailureTransition(true)).addTransition(ContainerState.RUNNING, ContainerState.RUNNING, ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition<ContainerImpl, ContainerEvent>)UPDATE_DIAGNOSTICS_TRANSITION).addTransition(ContainerState.RUNNING, ContainerState.KILLING, ContainerEventType.KILL_CONTAINER, (SingleArcTransition<ContainerImpl, ContainerEvent>)new KillTransition()).addTransition(ContainerState.RUNNING, ContainerState.EXITED_WITH_FAILURE, ContainerEventType.CONTAINER_KILLED_ON_REQUEST, (SingleArcTransition<ContainerImpl, ContainerEvent>)new KilledExternallyTransition()).addTransition(ContainerState.EXITED_WITH_SUCCESS, ContainerState.DONE, ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition<ContainerImpl, ContainerEvent>)CONTAINER_DONE_TRANSITION).addTransition(ContainerState.EXITED_WITH_SUCCESS, ContainerState.EXITED_WITH_SUCCESS, ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition<ContainerImpl, ContainerEvent>)UPDATE_DIAGNOSTICS_TRANSITION).addTransition(ContainerState.EXITED_WITH_SUCCESS, ContainerState.EXITED_WITH_SUCCESS, ContainerEventType.KILL_CONTAINER).addTransition(ContainerState.EXITED_WITH_FAILURE, ContainerState.DONE, ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition<ContainerImpl, ContainerEvent>)CONTAINER_DONE_TRANSITION).addTransition(ContainerState.EXITED_WITH_FAILURE, ContainerState.EXITED_WITH_FAILURE, ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition<ContainerImpl, ContainerEvent>)UPDATE_DIAGNOSTICS_TRANSITION).addTransition(ContainerState.EXITED_WITH_FAILURE, ContainerState.EXITED_WITH_FAILURE, ContainerEventType.KILL_CONTAINER).addTransition(ContainerState.KILLING, ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, ContainerEventType.CONTAINER_KILLED_ON_REQUEST, (SingleArcTransition<ContainerImpl, ContainerEvent>)new ContainerKilledTransition()).addTransition(ContainerState.KILLING, ContainerState.KILLING, ContainerEventType.RESOURCE_LOCALIZED, (SingleArcTransition<ContainerImpl, ContainerEvent>)new LocalizedResourceDuringKillTransition()).addTransition(ContainerState.KILLING, ContainerState.KILLING, ContainerEventType.RESOURCE_FAILED).addTransition(ContainerState.KILLING, ContainerState.KILLING, ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition<ContainerImpl, ContainerEvent>)UPDATE_DIAGNOSTICS_TRANSITION).addTransition(ContainerState.KILLING, ContainerState.KILLING, ContainerEventType.KILL_CONTAINER).addTransition(ContainerState.KILLING, ContainerState.EXITED_WITH_SUCCESS, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, (SingleArcTransition<ContainerImpl, ContainerEvent>)new ExitedWithSuccessTransition(false)).addTransition(ContainerState.KILLING, ContainerState.EXITED_WITH_FAILURE, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition<ContainerImpl, ContainerEvent>)new ExitedWithFailureTransition(false)).addTransition(ContainerState.KILLING, ContainerState.DONE, ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition<ContainerImpl, ContainerEvent>)CONTAINER_DONE_TRANSITION).addTransition(ContainerState.KILLING, ContainerState.KILLING, ContainerEventType.CONTAINER_LAUNCHED).addTransition(ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, ContainerState.DONE, ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition<ContainerImpl, ContainerEvent>)CONTAINER_DONE_TRANSITION).addTransition(ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition<ContainerImpl, ContainerEvent>)UPDATE_DIAGNOSTICS_TRANSITION).addTransition(ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, ContainerEventType.KILL_CONTAINER).addTransition(ContainerState.DONE, ContainerState.DONE, ContainerEventType.KILL_CONTAINER).addTransition(ContainerState.DONE, ContainerState.DONE, ContainerEventType.INIT_CONTAINER).addTransition(ContainerState.DONE, ContainerState.DONE, ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition<ContainerImpl, ContainerEvent>)UPDATE_DIAGNOSTICS_TRANSITION).addTransition(ContainerState.DONE, ContainerState.DONE, ContainerEventType.RESOURCE_FAILED).installTopology();
    private final StateMachine<ContainerState, ContainerEventType, ContainerEvent> stateMachine;

    public ContainerImpl(Configuration conf, Dispatcher dispatcher, ContainerLaunchContext launchContext, Credentials creds, NodeManagerMetrics metrics, ContainerTokenIdentifier containerTokenIdentifier) {
        this.daemonConf = conf;
        this.dispatcher = dispatcher;
        this.launchContext = launchContext;
        this.containerTokenIdentifier = containerTokenIdentifier;
        this.containerId = containerTokenIdentifier.getContainerID();
        this.resource = containerTokenIdentifier.getResource();
        this.diagnostics = new StringBuilder();
        this.credentials = creds;
        this.metrics = metrics;
        this.user = containerTokenIdentifier.getApplicationSubmitter();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.stateMachine = stateMachineFactory.make(this);
    }

    public org.apache.hadoop.yarn.api.records.ContainerState getCurrentState() {
        switch (this.stateMachine.getCurrentState()) {
            case NEW: 
            case LOCALIZING: 
            case LOCALIZATION_FAILED: 
            case LOCALIZED: 
            case RUNNING: 
            case EXITED_WITH_SUCCESS: 
            case EXITED_WITH_FAILURE: 
            case KILLING: 
            case CONTAINER_CLEANEDUP_AFTER_KILL: 
            case CONTAINER_RESOURCES_CLEANINGUP: {
                return org.apache.hadoop.yarn.api.records.ContainerState.RUNNING;
            }
        }
        return org.apache.hadoop.yarn.api.records.ContainerState.COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUser() {
        this.readLock.lock();
        try {
            String string = this.user;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Path, List<String>> getLocalizedResources() {
        this.readLock.lock();
        try {
            if (ContainerState.LOCALIZED == this.getContainerState()) {
                Map<Path, List<String>> map = this.localizedResources;
                return map;
            }
            Map<Path, List<String>> map = null;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credentials getCredentials() {
        this.readLock.lock();
        try {
            Credentials credentials = this.credentials;
            return credentials;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerState getContainerState() {
        this.readLock.lock();
        try {
            ContainerState containerState = this.stateMachine.getCurrentState();
            return containerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerLaunchContext getLaunchContext() {
        this.readLock.lock();
        try {
            ContainerLaunchContext containerLaunchContext = this.launchContext;
            return containerLaunchContext;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerStatus cloneAndGetContainerStatus() {
        this.readLock.lock();
        try {
            ContainerStatus containerStatus = BuilderUtils.newContainerStatus(this.containerId, this.getCurrentState(), this.diagnostics.toString(), this.exitCode);
            return containerStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerId getContainerId() {
        return this.containerId;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerTokenIdentifier getContainerTokenIdentifier() {
        this.readLock.lock();
        try {
            ContainerTokenIdentifier containerTokenIdentifier = this.containerTokenIdentifier;
            return containerTokenIdentifier;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void finished() {
        ApplicationId applicationId = this.containerId.getApplicationAttemptId().getApplicationId();
        switch (this.getContainerState()) {
            case EXITED_WITH_SUCCESS: {
                this.metrics.endRunningContainer();
                this.metrics.completedContainer();
                NMAuditLogger.logSuccess(this.user, "Container Finished - Succeeded", "ContainerImpl", applicationId, this.containerId);
                break;
            }
            case EXITED_WITH_FAILURE: {
                if (this.wasLaunched) {
                    this.metrics.endRunningContainer();
                }
            }
            case LOCALIZATION_FAILED: {
                this.metrics.failedContainer();
                NMAuditLogger.logFailure(this.user, "Container Finished - Failed", "ContainerImpl", "Container failed with state: " + (Object)((Object)this.getContainerState()), applicationId, this.containerId);
                break;
            }
            case CONTAINER_CLEANEDUP_AFTER_KILL: {
                if (this.wasLaunched) {
                    this.metrics.endRunningContainer();
                }
            }
            case NEW: {
                this.metrics.killedContainer();
                NMAuditLogger.logSuccess(this.user, "Container Finished - Killed", "ContainerImpl", applicationId, this.containerId);
            }
        }
        this.metrics.releaseContainer(this.resource);
        EventHandler eventHandler = this.dispatcher.getEventHandler();
        eventHandler.handle(new ApplicationContainerFinishedEvent(this.containerId));
        eventHandler.handle(new ContainerStopMonitoringEvent(this.containerId));
        eventHandler.handle(new LogHandlerContainerFinishedEvent(this.containerId, this.exitCode));
    }

    public void cleanup() {
        HashMap<LocalResourceVisibility, Collection<LocalResourceRequest>> rsrc = new HashMap<LocalResourceVisibility, Collection<LocalResourceRequest>>();
        if (!this.publicRsrcs.isEmpty()) {
            rsrc.put(LocalResourceVisibility.PUBLIC, this.publicRsrcs);
        }
        if (!this.privateRsrcs.isEmpty()) {
            rsrc.put(LocalResourceVisibility.PRIVATE, this.privateRsrcs);
        }
        if (!this.appRsrcs.isEmpty()) {
            rsrc.put(LocalResourceVisibility.APPLICATION, this.appRsrcs);
        }
        this.dispatcher.getEventHandler().handle(new ContainerLocalizationCleanupEvent(this, rsrc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ContainerEvent event) {
        try {
            this.writeLock.lock();
            ContainerId containerID = event.getContainerID();
            LOG.debug((Object)("Processing " + containerID + " of type " + event.getType()));
            ContainerState oldState = this.stateMachine.getCurrentState();
            ContainerState newState = null;
            try {
                newState = this.stateMachine.doTransition((ContainerEventType)((Object)event.getType()), event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.warn((Object)("Can't handle this event at current state: Current: [" + (Object)((Object)oldState) + "], eventType: [" + event.getType() + "]"), (Throwable)e);
            }
            if (oldState != newState) {
                LOG.info((Object)("Container " + containerID + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState)));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.readLock.lock();
        try {
            String string = ConverterUtils.toString(this.containerId);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    static /* synthetic */ ContainerLaunchContext access$000(ContainerImpl x0) {
        return x0.launchContext;
    }

    static /* synthetic */ String access$300(ContainerImpl x0) {
        return x0.user;
    }

    static /* synthetic */ List access$600(ContainerImpl x0) {
        return x0.publicRsrcs;
    }

    static /* synthetic */ List access$700(ContainerImpl x0) {
        return x0.privateRsrcs;
    }

    static /* synthetic */ List access$800(ContainerImpl x0) {
        return x0.appRsrcs;
    }

    static class ContainerDiagnosticsUpdateTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerDiagnosticsUpdateTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerDiagnosticsUpdateEvent updateEvent = (ContainerDiagnosticsUpdateEvent)event;
            container.diagnostics.append(updateEvent.getDiagnosticsUpdate()).append("\n");
        }
    }

    static class KillOnNewTransition
    extends ContainerDoneTransition {
        KillOnNewTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerKillEvent killEvent = (ContainerKillEvent)event;
            container.exitCode = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
            container.diagnostics.append(killEvent.getDiagnostic()).append("\n");
            container.diagnostics.append("Container is killed before being launched.\n");
            super.transition(container, event);
        }
    }

    static class ContainerDoneTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.finished();
            if (container.getCurrentState() != org.apache.hadoop.yarn.api.records.ContainerState.NEW) {
                container.dispatcher.getEventHandler().handle(new AuxServicesEvent(AuxServicesEventType.CONTAINER_STOP, container));
            }
        }
    }

    static class ContainerKilledTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerKilledTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerExitEvent exitEvent = (ContainerExitEvent)event;
            container.exitCode = exitEvent.getExitCode();
            if (exitEvent.getDiagnosticInfo() != null) {
                container.diagnostics.append(exitEvent.getDiagnosticInfo()).append('\n');
            }
            container.cleanup();
        }
    }

    static class KillTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        KillTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.dispatcher.getEventHandler().handle(new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            ContainerKillEvent killEvent = (ContainerKillEvent)event;
            container.diagnostics.append(killEvent.getDiagnostic()).append("\n");
        }
    }

    static class LocalizedResourceDuringKillTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        LocalizedResourceDuringKillTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceLocalizedEvent rsrcEvent = (ContainerResourceLocalizedEvent)event;
            List syms = (List)container.pendingResources.remove(rsrcEvent.getResource());
            if (null == syms) {
                LOG.warn((Object)("Localized unknown resource " + rsrcEvent.getResource() + " for container " + container.containerId));
                assert (false);
                return;
            }
            container.localizedResources.put(rsrcEvent.getLocation(), syms);
        }
    }

    static class KillDuringLocalizationTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        KillDuringLocalizationTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.cleanup();
            container.metrics.endInitingContainer();
            ContainerKillEvent killEvent = (ContainerKillEvent)event;
            container.exitCode = ContainerExecutor.ExitCode.TERMINATED.getExitCode();
            container.diagnostics.append(killEvent.getDiagnostic()).append("\n");
            container.diagnostics.append("Container is killed before being launched.\n");
        }
    }

    static class ResourceFailedTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ResourceFailedTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceFailedEvent rsrcFailedEvent = (ContainerResourceFailedEvent)event;
            container.diagnostics.append(rsrcFailedEvent.getDiagnosticMessage() + "\n");
            container.cleanup();
            container.metrics.endInitingContainer();
        }
    }

    static class KilledExternallyTransition
    extends ExitedWithFailureTransition {
        KilledExternallyTransition() {
            super(true);
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            super.transition(container, event);
            container.diagnostics.append("Killed by external signal\n");
        }
    }

    static class ExitedWithFailureTransition
    extends ContainerTransition {
        boolean clCleanupRequired;

        public ExitedWithFailureTransition(boolean clCleanupRequired) {
            this.clCleanupRequired = clCleanupRequired;
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerExitEvent exitEvent = (ContainerExitEvent)event;
            container.exitCode = exitEvent.getExitCode();
            if (exitEvent.getDiagnosticInfo() != null) {
                container.diagnostics.append(exitEvent.getDiagnosticInfo()).append('\n');
            }
            if (this.clCleanupRequired) {
                container.dispatcher.getEventHandler().handle(new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            }
            container.cleanup();
        }
    }

    static class ExitedWithSuccessTransition
    extends ContainerTransition {
        boolean clCleanupRequired;

        public ExitedWithSuccessTransition(boolean clCleanupRequired) {
            this.clCleanupRequired = clCleanupRequired;
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.exitCode = 0;
            if (this.clCleanupRequired) {
                container.dispatcher.getEventHandler().handle(new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            }
            container.cleanup();
        }
    }

    static class LaunchTransition
    extends ContainerTransition {
        LaunchTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            long pmemBytes = (long)(container.getResource().getMemory() * 1024) * 1024L;
            float pmemRatio = container.daemonConf.getFloat("yarn.nodemanager.vmem-pmem-ratio", 2.1f);
            long vmemBytes = (long)(pmemRatio * (float)pmemBytes);
            container.dispatcher.getEventHandler().handle(new ContainerStartMonitoringEvent(container.containerId, vmemBytes, pmemBytes));
            container.metrics.runningContainer();
            container.wasLaunched = true;
        }
    }

    static class LocalizedTransition
    implements MultipleArcTransition<ContainerImpl, ContainerEvent, ContainerState> {
        LocalizedTransition() {
        }

        @Override
        public ContainerState transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceLocalizedEvent rsrcEvent = (ContainerResourceLocalizedEvent)event;
            List syms = (List)container.pendingResources.remove(rsrcEvent.getResource());
            if (null == syms) {
                LOG.warn((Object)("Localized unknown resource " + rsrcEvent.getResource() + " for container " + container.containerId));
                assert (false);
                return ContainerState.LOCALIZING;
            }
            container.localizedResources.put(rsrcEvent.getLocation(), syms);
            if (!container.pendingResources.isEmpty()) {
                return ContainerState.LOCALIZING;
            }
            container.dispatcher.getEventHandler().handle(new ContainersLauncherEvent(container, ContainersLauncherEventType.LAUNCH_CONTAINER));
            container.metrics.endInitingContainer();
            return ContainerState.LOCALIZED;
        }
    }

    static class RequestResourcesTransition
    implements MultipleArcTransition<ContainerImpl, ContainerEvent, ContainerState> {
        RequestResourcesTransition() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public ContainerState transition(ContainerImpl container, ContainerEvent event) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class ContainerTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
        }
    }
}

