/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.math.LongRange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop.shaded.com.google.common.util.concurrent.Futures;
import org.apache.flink.hadoop.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMoveEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;

public class ClientRMService
extends AbstractService
implements ApplicationClientProtocol {
    private static final ArrayList<ApplicationReport> EMPTY_APPS_REPORT = new ArrayList();
    private static final Log LOG = LogFactory.getLog(ClientRMService.class);
    private final AtomicInteger applicationCounter = new AtomicInteger(0);
    private final YarnScheduler scheduler;
    private final RMContext rmContext;
    private final RMAppManager rmAppManager;
    private Server server;
    protected RMDelegationTokenSecretManager rmDTSecretManager;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    InetSocketAddress clientBindAddress;
    private final ApplicationACLsManager applicationsACLsManager;
    private final QueueACLsManager queueACLsManager;

    public ClientRMService(RMContext rmContext, YarnScheduler scheduler, RMAppManager rmAppManager, ApplicationACLsManager applicationACLsManager, QueueACLsManager queueACLsManager, RMDelegationTokenSecretManager rmDTSecretManager) {
        super(ClientRMService.class.getName());
        this.scheduler = scheduler;
        this.rmContext = rmContext;
        this.rmAppManager = rmAppManager;
        this.applicationsACLsManager = applicationACLsManager;
        this.queueACLsManager = queueACLsManager;
        this.rmDTSecretManager = rmDTSecretManager;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.clientBindAddress = this.getBindAddress(conf);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create(conf);
        this.server = rpc.getServer(ApplicationClientProtocol.class, this, this.clientBindAddress, conf, this.rmDTSecretManager, conf.getInt("yarn.resourcemanager.client.thread-count", 50));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            InputStream inputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, "hadoop-policy.xml");
            if (inputStream != null) {
                conf.addResource(inputStream);
            }
            this.refreshServiceAcls(conf, RMPolicyProvider.getInstance());
        }
        this.server.start();
        this.clientBindAddress = conf.updateConnectAddr("yarn.resourcemanager.address", this.server.getListenerAddress());
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.clientBindAddress;
    }

    private boolean checkAccess(UserGroupInformation callerUGI, String owner, ApplicationAccessType operationPerformed, RMApp application) {
        return this.applicationsACLsManager.checkAccess(callerUGI, operationPerformed, owner, application.getApplicationId()) || this.queueACLsManager.checkAccess(callerUGI, QueueACL.ADMINISTER_QUEUE, application.getQueue());
    }

    ApplicationId getNewApplicationId() {
        ApplicationId applicationId = BuilderUtils.newApplicationId(this.recordFactory, ResourceManager.getClusterTimeStamp(), this.applicationCounter.incrementAndGet());
        LOG.info((Object)("Allocated new applicationId: " + applicationId.getId()));
        return applicationId;
    }

    @Override
    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException {
        GetNewApplicationResponse response = this.recordFactory.newRecordInstance(GetNewApplicationResponse.class);
        response.setApplicationId(this.getNewApplicationId());
        response.setMaximumResourceCapability(this.scheduler.getMaximumResourceCapability());
        return response;
    }

    @Override
    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException {
        UserGroupInformation callerUGI;
        ApplicationId applicationId = request.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException(ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + applicationId + "' doesn't exist in RM.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        ApplicationReport report = application.createAndGetApplicationReport(callerUGI.getUserName(), allowAccess);
        GetApplicationReportResponse response = this.recordFactory.newRecordInstance(GetApplicationReportResponse.class);
        response.setApplicationReport(report);
        return response;
    }

    @Override
    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        RMAppAttempt appAttempt;
        UserGroupInformation callerUGI;
        ApplicationAttemptId appAttemptId = request.getApplicationAttemptId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException(ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(appAttemptId.getApplicationId());
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + request.getApplicationAttemptId().getApplicationId() + "' doesn't exist in RM.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetApplicationAttemptReportResponse response = null;
        if (allowAccess) {
            appAttempt = application.getAppAttempts().get(appAttemptId);
            if (appAttempt == null) {
                throw new ApplicationAttemptNotFoundException("ApplicationAttempt " + appAttemptId + " Not Found in RM");
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilage to see this attempt " + appAttemptId);
        }
        ApplicationAttemptReport attemptReport = appAttempt.createApplicationAttemptReport();
        response = GetApplicationAttemptReportResponse.newInstance(attemptReport);
        return response;
    }

    @Override
    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        ArrayList<ApplicationAttemptReport> listAttempts;
        UserGroupInformation callerUGI;
        ApplicationId appId = request.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException(ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(appId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + appId + "' doesn't exist in RM.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetApplicationAttemptsResponse response = null;
        if (allowAccess) {
            Map<ApplicationAttemptId, RMAppAttempt> attempts = application.getAppAttempts();
            listAttempts = new ArrayList<ApplicationAttemptReport>();
            Iterator<Map.Entry<ApplicationAttemptId, RMAppAttempt>> iter = attempts.entrySet().iterator();
            while (iter.hasNext()) {
                listAttempts.add(iter.next().getValue().createApplicationAttemptReport());
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilage to see this aplication " + appId);
        }
        response = GetApplicationAttemptsResponse.newInstance(listAttempts);
        return response;
    }

    @Override
    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        RMContainer rmConatiner;
        UserGroupInformation callerUGI;
        ContainerId containerId = request.getContainerId();
        ApplicationAttemptId appAttemptId = containerId.getApplicationAttemptId();
        ApplicationId appId = appAttemptId.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException(ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(appId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + appId + "' doesn't exist in RM.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetContainerReportResponse response = null;
        if (allowAccess) {
            RMAppAttempt appAttempt = application.getAppAttempts().get(appAttemptId);
            if (appAttempt == null) {
                throw new ApplicationAttemptNotFoundException("ApplicationAttempt " + appAttemptId + " Not Found in RM");
            }
            rmConatiner = this.rmContext.getScheduler().getRMContainer(containerId);
            if (rmConatiner == null) {
                throw new ContainerNotFoundException("Container with id " + containerId + " not found");
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilage to see this aplication " + appId);
        }
        response = GetContainerReportResponse.newInstance(rmConatiner.createContainerReport());
        return response;
    }

    @Override
    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        ArrayList<ContainerReport> listContainers;
        UserGroupInformation callerUGI;
        ApplicationAttemptId appAttemptId = request.getApplicationAttemptId();
        ApplicationId appId = appAttemptId.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException(ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(appId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + appId + "' doesn't exist in RM.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetContainersResponse response = null;
        if (allowAccess) {
            RMAppAttempt appAttempt = application.getAppAttempts().get(appAttemptId);
            if (appAttempt == null) {
                throw new ApplicationAttemptNotFoundException("ApplicationAttempt " + appAttemptId + " Not Found in RM");
            }
            Collection<Object> rmContainers = Collections.emptyList();
            SchedulerAppReport schedulerAppReport = this.rmContext.getScheduler().getSchedulerAppInfo(appAttemptId);
            if (schedulerAppReport != null) {
                rmContainers = schedulerAppReport.getLiveContainers();
            }
            listContainers = new ArrayList<ContainerReport>();
            for (RMContainer rMContainer : rmContainers) {
                listContainers.add(rMContainer.createContainerReport());
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilage to see this aplication " + appId);
        }
        response = GetContainersResponse.newInstance(listContainers);
        return response;
    }

    @Override
    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException {
        ApplicationSubmissionContext submissionContext = request.getApplicationSubmissionContext();
        ApplicationId applicationId = submissionContext.getApplicationId();
        String user = null;
        try {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException ie) {
            LOG.warn((Object)"Unable to get the current user.", (Throwable)ie);
            RMAuditLogger.logFailure(user, "Submit Application Request", ie.getMessage(), "ClientRMService", "Exception in submitting application", applicationId);
            throw RPCUtil.getRemoteException(ie);
        }
        if (this.rmContext.getRMApps().get(applicationId) != null) {
            LOG.info((Object)("This is an earlier submitted application: " + applicationId));
            return SubmitApplicationResponse.newInstance();
        }
        if (submissionContext.getQueue() == null) {
            submissionContext.setQueue("default");
        }
        if (submissionContext.getApplicationName() == null) {
            submissionContext.setApplicationName("N/A");
        }
        if (submissionContext.getApplicationType() == null) {
            submissionContext.setApplicationType("YARN");
        } else if (submissionContext.getApplicationType().length() > 20) {
            submissionContext.setApplicationType(submissionContext.getApplicationType().substring(0, 20));
        }
        try {
            this.rmAppManager.submitApplication(submissionContext, System.currentTimeMillis(), user);
            LOG.info((Object)("Application with id " + applicationId.getId() + " submitted by user " + user));
            RMAuditLogger.logSuccess(user, "Submit Application Request", "ClientRMService", applicationId);
        }
        catch (YarnException e) {
            LOG.info((Object)("Exception in submitting application with id " + applicationId.getId()), (Throwable)e);
            RMAuditLogger.logFailure(user, "Submit Application Request", e.getMessage(), "ClientRMService", "Exception in submitting application", applicationId);
            throw e;
        }
        SubmitApplicationResponse response = this.recordFactory.newRecordInstance(SubmitApplicationResponse.class);
        return response;
    }

    @Override
    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException {
        UserGroupInformation callerUGI;
        ApplicationId applicationId = request.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            RMAuditLogger.logFailure("UNKNOWN", "Kill Application Request", "UNKNOWN", "ClientRMService", "Error getting UGI", applicationId);
            throw RPCUtil.getRemoteException(ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            RMAuditLogger.logFailure(callerUGI.getUserName(), "Kill Application Request", "UNKNOWN", "ClientRMService", "Trying to kill an absent application", applicationId);
            throw new ApplicationNotFoundException("Trying to kill an absent application " + applicationId);
        }
        if (!this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.MODIFY_APP, application)) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Kill Application Request", "User doesn't have permissions to " + ApplicationAccessType.MODIFY_APP.toString(), "ClientRMService", "Unauthorized user", applicationId);
            throw RPCUtil.getRemoteException(new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + ApplicationAccessType.MODIFY_APP.name() + " on " + applicationId));
        }
        if (application.isAppFinalStateStored()) {
            RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Kill Application Request", "ClientRMService", applicationId);
            return KillApplicationResponse.newInstance(true);
        }
        this.rmContext.getDispatcher().getEventHandler().handle(new RMAppEvent(applicationId, RMAppEventType.KILL));
        return KillApplicationResponse.newInstance(application.getApplicationSubmissionContext().getUnmanagedAM());
    }

    @Override
    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException {
        GetClusterMetricsResponse response = this.recordFactory.newRecordInstance(GetClusterMetricsResponse.class);
        YarnClusterMetrics ymetrics = this.recordFactory.newRecordInstance(YarnClusterMetrics.class);
        ymetrics.setNumNodeManagers(this.rmContext.getRMNodes().size());
        response.setClusterMetrics(ymetrics);
        return response;
    }

    @Override
    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException {
        return this.getApplications(request, true);
    }

    @InterfaceAudience.Private
    public GetApplicationsResponse getApplications(GetApplicationsRequest request, boolean caseSensitive) throws YarnException {
        Iterator<RMApp> appsIter;
        UserGroupInformation callerUGI;
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException(ie);
        }
        Set<String> applicationTypes = request.getApplicationTypes();
        EnumSet<YarnApplicationState> applicationStates = request.getApplicationStates();
        Set<String> users = request.getUsers();
        Set<String> queues = request.getQueues();
        Set<String> tags = request.getApplicationTags();
        long limit = request.getLimit();
        LongRange start = request.getStartRange();
        LongRange finish = request.getFinishRange();
        ApplicationsRequestScope scope = request.getScope();
        final ConcurrentMap<ApplicationId, RMApp> apps = this.rmContext.getRMApps();
        if (queues != null && !queues.isEmpty()) {
            final ArrayList<List<ApplicationAttemptId>> queueAppLists = new ArrayList<List<ApplicationAttemptId>>();
            for (String queue : queues) {
                List<ApplicationAttemptId> appsInQueue = this.scheduler.getAppsInQueue(queue);
                if (appsInQueue == null || appsInQueue.isEmpty()) continue;
                queueAppLists.add(appsInQueue);
            }
            appsIter = new Iterator<RMApp>(){
                Iterator<List<ApplicationAttemptId>> appListIter;
                Iterator<ApplicationAttemptId> schedAppsIter;
                {
                    this.appListIter = queueAppLists.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.schedAppsIter != null && this.schedAppsIter.hasNext() || this.appListIter.hasNext();
                }

                @Override
                public RMApp next() {
                    if (this.schedAppsIter == null || !this.schedAppsIter.hasNext()) {
                        this.schedAppsIter = this.appListIter.next().iterator();
                    }
                    return (RMApp)apps.get(this.schedAppsIter.next().getApplicationId());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported");
                }
            };
        } else {
            appsIter = apps.values().iterator();
        }
        ArrayList<ApplicationReport> reports = new ArrayList<ApplicationReport>();
        while (appsIter.hasNext() && (long)reports.size() < limit) {
            String appTypeToMatch;
            RMApp application = (RMApp)appsIter.next();
            boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
            if (scope == ApplicationsRequestScope.OWN && !callerUGI.getUserName().equals(application.getUser()) || scope == ApplicationsRequestScope.VIEWABLE && !allowAccess || applicationTypes != null && !applicationTypes.isEmpty() && !applicationTypes.contains(appTypeToMatch = caseSensitive ? application.getApplicationType() : application.getApplicationType().toLowerCase()) || applicationStates != null && !applicationStates.isEmpty() && !applicationStates.contains((Object)application.createApplicationState()) || users != null && !users.isEmpty() && !users.contains(application.getUser()) || start != null && !start.containsLong(application.getStartTime()) || finish != null && !finish.containsLong(application.getFinishTime())) continue;
            if (tags != null && !tags.isEmpty()) {
                Set<String> appTags = application.getApplicationTags();
                if (appTags == null || appTags.isEmpty()) continue;
                boolean match = false;
                for (String tag : tags) {
                    if (!appTags.contains(tag)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
            }
            reports.add(application.createAndGetApplicationReport(callerUGI.getUserName(), allowAccess));
        }
        GetApplicationsResponse response = this.recordFactory.newRecordInstance(GetApplicationsResponse.class);
        response.setApplicationList(reports);
        return response;
    }

    @Override
    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException {
        GetClusterNodesResponse response = this.recordFactory.newRecordInstance(GetClusterNodesResponse.class);
        EnumSet<NodeState> nodeStates = request.getNodeStates();
        if (nodeStates == null || nodeStates.isEmpty()) {
            nodeStates = EnumSet.allOf(NodeState.class);
        }
        List<RMNode> nodes = RMServerUtils.queryRMNodes(this.rmContext, nodeStates);
        ArrayList<NodeReport> nodeReports = new ArrayList<NodeReport>(nodes.size());
        for (RMNode nodeInfo : nodes) {
            nodeReports.add(this.createNodeReports(nodeInfo));
        }
        response.setNodeReports(nodeReports);
        return response;
    }

    @Override
    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException {
        GetQueueInfoResponse response = this.recordFactory.newRecordInstance(GetQueueInfoResponse.class);
        try {
            QueueInfo queueInfo = this.scheduler.getQueueInfo(request.getQueueName(), request.getIncludeChildQueues(), request.getRecursive());
            ArrayList<ApplicationReport> appReports = EMPTY_APPS_REPORT;
            if (request.getIncludeApplications()) {
                List<ApplicationAttemptId> apps = this.scheduler.getAppsInQueue(request.getQueueName());
                appReports = new ArrayList(apps.size());
                for (ApplicationAttemptId app : apps) {
                    RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(app.getApplicationId());
                    appReports.add(rmApp.createAndGetApplicationReport(null, true));
                }
            }
            queueInfo.setApplications(appReports);
            response.setQueueInfo(queueInfo);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Failed to getQueueInfo for " + request.getQueueName()), (Throwable)ioe);
        }
        return response;
    }

    private NodeReport createNodeReports(RMNode rmNode) {
        SchedulerNodeReport schedulerNodeReport = this.scheduler.getNodeReport(rmNode.getNodeID());
        Resource used = BuilderUtils.newResource(0, 0);
        int numContainers = 0;
        if (schedulerNodeReport != null) {
            used = schedulerNodeReport.getUsedResource();
            numContainers = schedulerNodeReport.getNumContainers();
        }
        NodeReport report = BuilderUtils.newNodeReport(rmNode.getNodeID(), rmNode.getState(), rmNode.getHttpAddress(), rmNode.getRackName(), used, rmNode.getTotalCapability(), numContainers, rmNode.getHealthReport(), rmNode.getLastHealthReportTime());
        return report;
    }

    @Override
    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException {
        GetQueueUserAclsInfoResponse response = this.recordFactory.newRecordInstance(GetQueueUserAclsInfoResponse.class);
        response.setUserAclsInfoList(this.scheduler.getQueueUserAclInfo());
        return response;
    }

    @Override
    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be issued only with kerberos authentication");
            }
            GetDelegationTokenResponse response = this.recordFactory.newRecordInstance(GetDelegationTokenResponse.class);
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            Text owner = new Text(ugi.getUserName());
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(owner, new Text(request.getRenewer()), realUser);
            Token<RMDelegationTokenIdentifier> realRMDTtoken = new Token<RMDelegationTokenIdentifier>(tokenIdentifier, this.rmDTSecretManager);
            response.setRMDelegationToken(BuilderUtils.newDelegationToken(realRMDTtoken.getIdentifier(), realRMDTtoken.getKind().toString(), realRMDTtoken.getPassword(), realRMDTtoken.getService().toString()));
            return response;
        }
        catch (IOException io) {
            throw RPCUtil.getRemoteException(io);
        }
    }

    @Override
    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be renewed only with kerberos authentication");
            }
            org.apache.hadoop.yarn.api.records.Token protoToken = request.getDelegationToken();
            Token<RMDelegationTokenIdentifier> token = new Token<RMDelegationTokenIdentifier>(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
            String user = this.getRenewerForToken(token);
            long nextExpTime = this.rmDTSecretManager.renewToken(token, user);
            RenewDelegationTokenResponse renewResponse = Records.newRecord(RenewDelegationTokenResponse.class);
            renewResponse.setNextExpirationTime(nextExpTime);
            return renewResponse;
        }
        catch (IOException e) {
            throw RPCUtil.getRemoteException(e);
        }
    }

    @Override
    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be cancelled only with kerberos authentication");
            }
            org.apache.hadoop.yarn.api.records.Token protoToken = request.getDelegationToken();
            Token<RMDelegationTokenIdentifier> token = new Token<RMDelegationTokenIdentifier>(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
            String user = this.getRenewerForToken(token);
            this.rmDTSecretManager.cancelToken(token, user);
            return Records.newRecord(CancelDelegationTokenResponse.class);
        }
        catch (IOException e) {
            throw RPCUtil.getRemoteException(e);
        }
    }

    @Override
    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException {
        UserGroupInformation callerUGI;
        ApplicationId applicationId = request.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            RMAuditLogger.logFailure("UNKNOWN", "Move Application Request", "UNKNOWN", "ClientRMService", "Error getting UGI", applicationId);
            throw RPCUtil.getRemoteException(ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            RMAuditLogger.logFailure(callerUGI.getUserName(), "Move Application Request", "UNKNOWN", "ClientRMService", "Trying to move an absent application", applicationId);
            throw new ApplicationNotFoundException("Trying to move an absent application " + applicationId);
        }
        if (!this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.MODIFY_APP, application)) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Move Application Request", "User doesn't have permissions to " + ApplicationAccessType.MODIFY_APP.toString(), "ClientRMService", "Unauthorized user", applicationId);
            throw RPCUtil.getRemoteException(new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + ApplicationAccessType.MODIFY_APP.name() + " on " + applicationId));
        }
        if (EnumSet.of(RMAppState.NEW, new RMAppState[]{RMAppState.NEW_SAVING, RMAppState.FAILED, RMAppState.FINAL_SAVING, RMAppState.FINISHING, RMAppState.FINISHED, RMAppState.KILLED, RMAppState.KILLING, RMAppState.FAILED}).contains((Object)application.getState())) {
            String msg = "App in " + (Object)((Object)application.getState()) + " state cannot be moved.";
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Move Application Request", "UNKNOWN", "ClientRMService", msg);
            throw new YarnException(msg);
        }
        SettableFuture<Object> future = SettableFuture.create();
        this.rmContext.getDispatcher().getEventHandler().handle(new RMAppMoveEvent(applicationId, request.getTargetQueue(), future));
        try {
            Futures.get(future, YarnException.class);
        }
        catch (YarnException ex) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Move Application Request", "UNKNOWN", "ClientRMService", ex.getMessage());
            throw ex;
        }
        RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Move Application Request", "ClientRMService", applicationId);
        MoveApplicationAcrossQueuesResponse response = this.recordFactory.newRecordInstance(MoveApplicationAcrossQueuesResponse.class);
        return response;
    }

    private String getRenewerForToken(Token<RMDelegationTokenIdentifier> token) throws IOException {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        return loginUser.getUserName().equals(user.getUserName()) ? token.decodeIdentifier().getRenewer().toString() : user.getShortUserName();
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            return EnumSet.of(UserGroupInformation.AuthenticationMethod.KERBEROS, UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, UserGroupInformation.AuthenticationMethod.CERTIFICATE).contains((Object)UserGroupInformation.getCurrentUser().getRealAuthenticationMethod());
        }
        return true;
    }

    @VisibleForTesting
    public Server getServer() {
        return this.server;
    }
}

