/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.amlauncher;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptLaunchFailedEvent;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class AMLauncher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(AMLauncher.class);
    private ContainerManagementProtocol containerMgrProxy;
    private final RMAppAttempt application;
    private final Configuration conf;
    private final AMLauncherEventType eventType;
    private final RMContext rmContext;
    private final Container masterContainer;
    private final EventHandler handler;

    public AMLauncher(RMContext rmContext, RMAppAttempt application, AMLauncherEventType eventType, Configuration conf) {
        this.application = application;
        this.conf = conf;
        this.eventType = eventType;
        this.rmContext = rmContext;
        this.handler = rmContext.getDispatcher().getEventHandler();
        this.masterContainer = application.getMasterContainer();
    }

    private void connect() throws IOException {
        ContainerId masterContainerID = this.masterContainer.getId();
        this.containerMgrProxy = this.getContainerMgrProxy(masterContainerID);
    }

    private void launch() throws IOException, YarnException {
        this.connect();
        ContainerId masterContainerID = this.masterContainer.getId();
        ApplicationSubmissionContext applicationContext = this.application.getSubmissionContext();
        LOG.info((Object)("Setting up container " + this.masterContainer + " for AM " + this.application.getAppAttemptId()));
        ContainerLaunchContext launchContext = this.createAMContainerLaunchContext(applicationContext, masterContainerID);
        StartContainerRequest scRequest = StartContainerRequest.newInstance(launchContext, this.masterContainer.getContainerToken());
        ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
        list.add(scRequest);
        StartContainersRequest allRequests = StartContainersRequest.newInstance(list);
        StartContainersResponse response = this.containerMgrProxy.startContainers(allRequests);
        if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(masterContainerID)) {
            Throwable t = response.getFailedRequests().get(masterContainerID).deSerialize();
            this.parseAndThrowException(t);
        } else {
            LOG.info((Object)("Done launching container " + this.masterContainer + " for AM " + this.application.getAppAttemptId()));
        }
    }

    private void cleanup() throws IOException, YarnException {
        this.connect();
        ContainerId containerId = this.masterContainer.getId();
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        StopContainersRequest stopRequest = StopContainersRequest.newInstance(containerIds);
        StopContainersResponse response = this.containerMgrProxy.stopContainers(stopRequest);
        if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
            Throwable t = response.getFailedRequests().get(containerId).deSerialize();
            this.parseAndThrowException(t);
        }
    }

    protected ContainerManagementProtocol getContainerMgrProxy(ContainerId containerId) {
        NodeId node = this.masterContainer.getNodeId();
        final InetSocketAddress containerManagerBindAddress = NetUtils.createSocketAddrForHost(node.getHost(), node.getPort());
        final YarnRPC rpc = YarnRPC.create(this.conf);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser(containerId.getApplicationAttemptId().toString());
        String user = ((RMApp)this.rmContext.getRMApps().get(containerId.getApplicationAttemptId().getApplicationId())).getUser();
        org.apache.hadoop.yarn.api.records.Token token = this.rmContext.getNMTokenSecretManager().createNMToken(containerId.getApplicationAttemptId(), node, user);
        currentUser.addToken(ConverterUtils.convertFromYarn(token, containerManagerBindAddress));
        return currentUser.doAs(new PrivilegedAction<ContainerManagementProtocol>(){

            @Override
            public ContainerManagementProtocol run() {
                return (ContainerManagementProtocol)rpc.getProxy(ContainerManagementProtocol.class, containerManagerBindAddress, AMLauncher.this.conf);
            }
        });
    }

    private ContainerLaunchContext createAMContainerLaunchContext(ApplicationSubmissionContext applicationMasterContext, ContainerId containerID) throws IOException {
        ContainerLaunchContext container = applicationMasterContext.getAMContainerSpec();
        LOG.info((Object)("Command to launch container " + containerID + " : " + StringUtils.arrayToString(container.getCommands().toArray(new String[0]))));
        this.setupTokens(container, containerID);
        return container;
    }

    private void setupTokens(ContainerLaunchContext container, ContainerId containerID) throws IOException {
        Token<AMRMTokenIdentifier> amrmToken;
        Map<String, String> environment = container.getEnvironment();
        environment.put("APPLICATION_WEB_PROXY_BASE", this.application.getWebProxyBase());
        ApplicationId applicationId = this.application.getAppAttemptId().getApplicationId();
        environment.put("APP_SUBMIT_TIME_ENV", String.valueOf(((RMApp)this.rmContext.getRMApps().get(applicationId)).getSubmitTime()));
        environment.put("MAX_APP_ATTEMPTS", String.valueOf(((RMApp)this.rmContext.getRMApps().get(applicationId)).getMaxAppAttempts()));
        Credentials credentials = new Credentials();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        if (container.getTokens() != null) {
            dibb.reset(container.getTokens());
            credentials.readTokenStorageStream(dibb);
        }
        if ((amrmToken = this.getAMRMToken()) != null) {
            credentials.addToken(amrmToken.getService(), amrmToken);
        }
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream(dob);
        container.setTokens(ByteBuffer.wrap(dob.getData(), 0, dob.getLength()));
    }

    @VisibleForTesting
    protected Token<AMRMTokenIdentifier> getAMRMToken() {
        return this.application.getAMRMToken();
    }

    @Override
    public void run() {
        switch (this.eventType) {
            case LAUNCH: {
                try {
                    LOG.info((Object)("Launching master" + this.application.getAppAttemptId()));
                    this.launch();
                    this.handler.handle(new RMAppAttemptEvent(this.application.getAppAttemptId(), RMAppAttemptEventType.LAUNCHED));
                }
                catch (Exception ie) {
                    String message = "Error launching " + this.application.getAppAttemptId() + ". Got exception: " + StringUtils.stringifyException(ie);
                    LOG.info((Object)message);
                    this.handler.handle(new RMAppAttemptLaunchFailedEvent(this.application.getAppAttemptId(), message));
                }
                break;
            }
            case CLEANUP: {
                try {
                    LOG.info((Object)("Cleaning master " + this.application.getAppAttemptId()));
                    this.cleanup();
                }
                catch (IOException ie) {
                    LOG.info((Object)"Error cleaning master ", (Throwable)ie);
                }
                catch (YarnException e) {
                    StringBuilder sb = new StringBuilder("Container ");
                    sb.append(this.masterContainer.getId().toString());
                    sb.append(" is not handled by this NodeManager");
                    if (e.getMessage().contains(sb.toString())) break;
                    LOG.info((Object)"Error cleaning master ", (Throwable)e);
                }
                break;
            }
            default: {
                LOG.warn((Object)("Received unknown event-type " + (Object)((Object)this.eventType) + ". Ignoring."));
            }
        }
    }

    private void parseAndThrowException(Throwable t) throws YarnException, IOException {
        if (t instanceof YarnException) {
            throw (YarnException)t;
        }
        if (t instanceof SecretManager.InvalidToken) {
            throw (SecretManager.InvalidToken)t;
        }
        throw (IOException)t;
    }
}

