/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.util.resource.Resources;

public abstract class AbstractYarnScheduler
implements ResourceScheduler {
    protected RMContext rmContext;
    protected Map<ApplicationId, SchedulerApplication> applications;
    protected static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList<Container>();
    protected static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource(0), null, null, null);

    public synchronized List<Container> getTransferredContainers(ApplicationAttemptId currentAttempt) {
        ApplicationId appId = currentAttempt.getApplicationId();
        SchedulerApplication app = this.applications.get(appId);
        ArrayList<Container> containerList = new ArrayList<Container>();
        RMApp appImpl = (RMApp)this.rmContext.getRMApps().get(appId);
        if (appImpl.getApplicationSubmissionContext().getUnmanagedAM()) {
            return containerList;
        }
        Collection<RMContainer> liveContainers = app.getCurrentAppAttempt().getLiveContainers();
        ContainerId amContainerId = ((RMApp)this.rmContext.getRMApps().get(appId)).getCurrentAppAttempt().getMasterContainer().getId();
        for (RMContainer rmContainer : liveContainers) {
            if (rmContainer.getContainerId().equals(amContainerId)) continue;
            containerList.add(rmContainer.getContainer());
        }
        return containerList;
    }

    public Map<ApplicationId, SchedulerApplication> getSchedulerApplications() {
        return this.applications;
    }

    @Override
    public String moveApplication(ApplicationId appId, String newQueue) throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support moving apps between queues");
    }
}

