/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class CapacitySchedulerConfiguration
extends Configuration {
    private static final Log LOG = LogFactory.getLog(CapacitySchedulerConfiguration.class);
    private static final String CS_CONFIGURATION_FILE = "capacity-scheduler.xml";
    @InterfaceAudience.Private
    public static final String PREFIX = "yarn.scheduler.capacity.";
    @InterfaceAudience.Private
    public static final String DOT = ".";
    @InterfaceAudience.Private
    public static final String MAXIMUM_APPLICATIONS_SUFFIX = "maximum-applications";
    @InterfaceAudience.Private
    public static final String MAXIMUM_SYSTEM_APPLICATIONS = "yarn.scheduler.capacity.maximum-applications";
    @InterfaceAudience.Private
    public static final String MAXIMUM_AM_RESOURCE_SUFFIX = "maximum-am-resource-percent";
    @InterfaceAudience.Private
    public static final String MAXIMUM_APPLICATION_MASTERS_RESOURCE_PERCENT = "yarn.scheduler.capacity.maximum-am-resource-percent";
    @InterfaceAudience.Private
    public static final String QUEUES = "queues";
    @InterfaceAudience.Private
    public static final String CAPACITY = "capacity";
    @InterfaceAudience.Private
    public static final String MAXIMUM_CAPACITY = "maximum-capacity";
    @InterfaceAudience.Private
    public static final String USER_LIMIT = "minimum-user-limit-percent";
    @InterfaceAudience.Private
    public static final String USER_LIMIT_FACTOR = "user-limit-factor";
    @InterfaceAudience.Private
    public static final String STATE = "state";
    @InterfaceAudience.Private
    public static final int DEFAULT_MAXIMUM_SYSTEM_APPLICATIIONS = 10000;
    @InterfaceAudience.Private
    public static final float DEFAULT_MAXIMUM_APPLICATIONMASTERS_RESOURCE_PERCENT = 0.1f;
    @InterfaceAudience.Private
    public static final float UNDEFINED = -1.0f;
    @InterfaceAudience.Private
    public static final float MINIMUM_CAPACITY_VALUE = 0.0f;
    @InterfaceAudience.Private
    public static final float MAXIMUM_CAPACITY_VALUE = 100.0f;
    @InterfaceAudience.Private
    public static final float DEFAULT_MAXIMUM_CAPACITY_VALUE = -1.0f;
    @InterfaceAudience.Private
    public static final int DEFAULT_USER_LIMIT = 100;
    @InterfaceAudience.Private
    public static final float DEFAULT_USER_LIMIT_FACTOR = 1.0f;
    @InterfaceAudience.Private
    public static final String ALL_ACL = "*";
    @InterfaceAudience.Private
    public static final String NONE_ACL = " ";
    @InterfaceAudience.Private
    public static final String ENABLE_USER_METRICS = "yarn.scheduler.capacity.user-metrics.enable";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_ENABLE_USER_METRICS = false;
    @InterfaceAudience.Private
    public static final String RESOURCE_CALCULATOR_CLASS = "yarn.scheduler.capacity.resource-calculator";
    @InterfaceAudience.Private
    public static final Class<? extends ResourceCalculator> DEFAULT_RESOURCE_CALCULATOR_CLASS = DefaultResourceCalculator.class;
    @InterfaceAudience.Private
    public static final String ROOT = "root";
    @InterfaceAudience.Private
    public static final String NODE_LOCALITY_DELAY = "yarn.scheduler.capacity.node-locality-delay";
    @InterfaceAudience.Private
    public static final int DEFAULT_NODE_LOCALITY_DELAY = -1;
    @InterfaceAudience.Private
    public static final String SCHEDULE_ASYNCHRONOUSLY_PREFIX = "yarn.scheduler.capacity.schedule-asynchronously";
    @InterfaceAudience.Private
    public static final String SCHEDULE_ASYNCHRONOUSLY_ENABLE = "yarn.scheduler.capacity.schedule-asynchronously.enable";
    @InterfaceAudience.Private
    public static final boolean DEFAULT_SCHEDULE_ASYNCHRONOUSLY_ENABLE = false;

    public CapacitySchedulerConfiguration() {
        this(new Configuration());
    }

    public CapacitySchedulerConfiguration(Configuration configuration) {
        this(configuration, true);
    }

    public CapacitySchedulerConfiguration(Configuration configuration, boolean useLocalConfigurationProvider) {
        super(configuration);
        if (useLocalConfigurationProvider) {
            this.addResource(CS_CONFIGURATION_FILE);
        }
    }

    private String getQueuePrefix(String queue) {
        String queueName = PREFIX + queue + DOT;
        return queueName;
    }

    public int getMaximumSystemApplications() {
        int maxApplications = this.getInt(MAXIMUM_SYSTEM_APPLICATIONS, 10000);
        return maxApplications;
    }

    public float getMaximumApplicationMasterResourcePercent() {
        return this.getFloat(MAXIMUM_APPLICATION_MASTERS_RESOURCE_PERCENT, 0.1f);
    }

    public int getMaximumApplicationsPerQueue(String queue) {
        int maxApplicationsPerQueue = this.getInt(this.getQueuePrefix(queue) + MAXIMUM_APPLICATIONS_SUFFIX, -1);
        return maxApplicationsPerQueue;
    }

    public float getMaximumApplicationMasterResourcePerQueuePercent(String queue) {
        return this.getFloat(this.getQueuePrefix(queue) + MAXIMUM_AM_RESOURCE_SUFFIX, this.getMaximumApplicationMasterResourcePercent());
    }

    public float getCapacity(String queue) {
        float capacity;
        float f = capacity = queue.equals(ROOT) ? 100.0f : this.getFloat(this.getQueuePrefix(queue) + CAPACITY, -1.0f);
        if (capacity < 0.0f || capacity > 100.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + capacity + " for queue " + queue);
        }
        LOG.debug((Object)("CSConf - getCapacity: queuePrefix=" + this.getQueuePrefix(queue) + ", capacity=" + capacity));
        return capacity;
    }

    public void setCapacity(String queue, float capacity) {
        if (queue.equals(ROOT)) {
            throw new IllegalArgumentException("Cannot set capacity, root queue has a fixed capacity of 100.0f");
        }
        this.setFloat(this.getQueuePrefix(queue) + CAPACITY, capacity);
        LOG.debug((Object)("CSConf - setCapacity: queuePrefix=" + this.getQueuePrefix(queue) + ", capacity=" + capacity));
    }

    public float getMaximumCapacity(String queue) {
        float maxCapacity = this.getFloat(this.getQueuePrefix(queue) + MAXIMUM_CAPACITY, 100.0f);
        maxCapacity = maxCapacity == -1.0f ? 100.0f : maxCapacity;
        return maxCapacity;
    }

    public void setMaximumCapacity(String queue, float maxCapacity) {
        if (maxCapacity > 100.0f) {
            throw new IllegalArgumentException("Illegal maximum-capacity of " + maxCapacity + " for queue " + queue);
        }
        this.setFloat(this.getQueuePrefix(queue) + MAXIMUM_CAPACITY, maxCapacity);
        LOG.debug((Object)("CSConf - setMaxCapacity: queuePrefix=" + this.getQueuePrefix(queue) + ", maxCapacity=" + maxCapacity));
    }

    public int getUserLimit(String queue) {
        int userLimit = this.getInt(this.getQueuePrefix(queue) + USER_LIMIT, 100);
        return userLimit;
    }

    public void setUserLimit(String queue, int userLimit) {
        this.setInt(this.getQueuePrefix(queue) + USER_LIMIT, userLimit);
        LOG.debug((Object)("here setUserLimit: queuePrefix=" + this.getQueuePrefix(queue) + ", userLimit=" + this.getUserLimit(queue)));
    }

    public float getUserLimitFactor(String queue) {
        float userLimitFactor = this.getFloat(this.getQueuePrefix(queue) + USER_LIMIT_FACTOR, 1.0f);
        return userLimitFactor;
    }

    public void setUserLimitFactor(String queue, float userLimitFactor) {
        this.setFloat(this.getQueuePrefix(queue) + USER_LIMIT_FACTOR, userLimitFactor);
    }

    public QueueState getState(String queue) {
        String state = this.get(this.getQueuePrefix(queue) + STATE);
        return state != null ? QueueState.valueOf(state.toUpperCase()) : QueueState.RUNNING;
    }

    private static String getAclKey(QueueACL acl) {
        return "acl_" + acl.toString().toLowerCase();
    }

    public AccessControlList getAcl(String queue, QueueACL acl) {
        String queuePrefix = this.getQueuePrefix(queue);
        String defaultAcl = queue.equals(ROOT) ? ALL_ACL : NONE_ACL;
        String aclString = this.get(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), defaultAcl);
        return new AccessControlList(aclString);
    }

    public void setAcl(String queue, QueueACL acl, String aclString) {
        String queuePrefix = this.getQueuePrefix(queue);
        this.set(queuePrefix + CapacitySchedulerConfiguration.getAclKey(acl), aclString);
    }

    public Map<QueueACL, AccessControlList> getAcls(String queue) {
        HashMap<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
        for (QueueACL acl : QueueACL.values()) {
            acls.put(acl, this.getAcl(queue, acl));
        }
        return acls;
    }

    public void setAcls(String queue, Map<QueueACL, AccessControlList> acls) {
        for (Map.Entry<QueueACL, AccessControlList> e : acls.entrySet()) {
            this.setAcl(queue, e.getKey(), e.getValue().getAclString());
        }
    }

    public String[] getQueues(String queue) {
        LOG.debug((Object)("CSConf - getQueues called for: queuePrefix=" + this.getQueuePrefix(queue)));
        String[] queues = this.getStrings(this.getQueuePrefix(queue) + QUEUES);
        LOG.debug((Object)("CSConf - getQueues: queuePrefix=" + this.getQueuePrefix(queue) + ", queues=" + (queues == null ? "" : StringUtils.arrayToString(queues))));
        return queues;
    }

    public void setQueues(String queue, String[] subQueues) {
        this.set(this.getQueuePrefix(queue) + QUEUES, StringUtils.arrayToString(subQueues));
        LOG.debug((Object)("CSConf - setQueues: qPrefix=" + this.getQueuePrefix(queue) + ", queues=" + StringUtils.arrayToString(subQueues)));
    }

    public Resource getMinimumAllocation() {
        int minimumMemory = this.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int minimumCores = this.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        return Resources.createResource(minimumMemory, minimumCores);
    }

    public Resource getMaximumAllocation() {
        int maximumMemory = this.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        int maximumCores = this.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        return Resources.createResource(maximumMemory, maximumCores);
    }

    public boolean getEnableUserMetrics() {
        return this.getBoolean(ENABLE_USER_METRICS, false);
    }

    public int getNodeLocalityDelay() {
        int delay = this.getInt(NODE_LOCALITY_DELAY, -1);
        return delay == -1 ? 0 : delay;
    }

    public ResourceCalculator getResourceCalculator() {
        return ReflectionUtils.newInstance(this.getClass(RESOURCE_CALCULATOR_CLASS, DEFAULT_RESOURCE_CALCULATOR_CLASS, ResourceCalculator.class), this);
    }

    public boolean getUsePortForNodeName() {
        return this.getBoolean("yarn.scheduler.include-port-in-node-name", false);
    }

    public void setResourceComparator(Class<? extends ResourceCalculator> resourceCalculatorClass) {
        this.setClass(RESOURCE_CALCULATOR_CLASS, resourceCalculatorClass, ResourceCalculator.class);
    }

    public boolean getScheduleAynschronously() {
        return this.getBoolean(SCHEDULE_ASYNCHRONOUSLY_ENABLE, false);
    }

    public void setScheduleAynschronously(boolean async) {
        this.setBoolean(SCHEDULE_ASYNCHRONOUSLY_ENABLE, async);
    }
}

