/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.ComputeFairShares;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FairSharePolicy
extends SchedulingPolicy {
    @VisibleForTesting
    public static final String NAME = "fair";
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private FairShareComparator comparator = new FairShareComparator();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Comparator<Schedulable> getComparator() {
        return this.comparator;
    }

    @Override
    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        ComputeFairShares.computeShares(schedulables, totalResources, ResourceType.MEMORY);
    }

    @Override
    public byte getApplicableDepth() {
        return 7;
    }

    private static class FairShareComparator
    implements Comparator<Schedulable>,
    Serializable {
        private static final long serialVersionUID = 5564969375856699313L;

        private FairShareComparator() {
        }

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            Resource minShare1 = Resources.min(RESOURCE_CALCULATOR, null, s1.getMinShare(), s1.getDemand());
            Resource minShare2 = Resources.min(RESOURCE_CALCULATOR, null, s2.getMinShare(), s2.getDemand());
            boolean s1Needy = Resources.lessThan(RESOURCE_CALCULATOR, null, s1.getResourceUsage(), minShare1);
            boolean s2Needy = Resources.lessThan(RESOURCE_CALCULATOR, null, s2.getResourceUsage(), minShare2);
            Resource one = Resources.createResource(1);
            double minShareRatio1 = (double)s1.getResourceUsage().getMemory() / (double)Resources.max(RESOURCE_CALCULATOR, null, minShare1, one).getMemory();
            double minShareRatio2 = (double)s2.getResourceUsage().getMemory() / (double)Resources.max(RESOURCE_CALCULATOR, null, minShare2, one).getMemory();
            double useToWeightRatio1 = (float)s1.getResourceUsage().getMemory() / s1.getWeights().getWeight(ResourceType.MEMORY);
            double useToWeightRatio2 = (float)s2.getResourceUsage().getMemory() / s2.getWeights().getWeight(ResourceType.MEMORY);
            int res = 0;
            res = s1Needy && !s2Needy ? -1 : (s2Needy && !s1Needy ? 1 : (s1Needy && s2Needy ? (int)Math.signum(minShareRatio1 - minShareRatio2) : (int)Math.signum(useToWeightRatio1 - useToWeightRatio2)));
            if (res == 0 && (res = (int)Math.signum(s1.getStartTime() - s2.getStartTime())) == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }
    }
}

