/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationStatisticsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FifoSchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.StatisticsItemInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@Singleton
@Path(value="/ws/v1/cluster")
public class RMWebServices {
    private static final Log LOG = LogFactory.getLog((String)RMWebServices.class.getName());
    private static final String EMPTY = "";
    private static final String ANY = "*";
    private final ResourceManager rm;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final Configuration conf;
    @Context
    private HttpServletResponse response;

    @Inject
    public RMWebServices(ResourceManager rm, Configuration conf) {
        this.rm = rm;
        this.conf = conf;
    }

    protected Boolean hasAccess(RMApp app, HttpServletRequest hsr) {
        String remoteUser = hsr.getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser(remoteUser);
        }
        if (callerUGI != null && !this.rm.getApplicationACLsManager().checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, app.getUser(), app.getApplicationId()) && !this.rm.getQueueACLsManager().checkAccess(callerUGI, QueueACL.ADMINISTER_QUEUE, app.getQueue())) {
            return false;
        }
        return true;
    }

    private void init() {
        this.response.setContentType(null);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public ClusterInfo get() {
        return this.getClusterInfo();
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json", "application/xml"})
    public ClusterInfo getClusterInfo() {
        this.init();
        return new ClusterInfo(this.rm);
    }

    @GET
    @Path(value="/metrics")
    @Produces(value={"application/json", "application/xml"})
    public ClusterMetricsInfo getClusterMetricsInfo() {
        this.init();
        return new ClusterMetricsInfo(this.rm, this.rm.getRMContext());
    }

    @GET
    @Path(value="/scheduler")
    @Produces(value={"application/json", "application/xml"})
    public SchedulerTypeInfo getSchedulerInfo() {
        SchedulerInfo sinfo;
        this.init();
        ResourceScheduler rs = this.rm.getResourceScheduler();
        if (rs instanceof CapacityScheduler) {
            CapacityScheduler cs = (CapacityScheduler)rs;
            CSQueue root = cs.getRootQueue();
            sinfo = new CapacitySchedulerInfo(root);
        } else if (rs instanceof FairScheduler) {
            FairScheduler fs = (FairScheduler)rs;
            sinfo = new FairSchedulerInfo(fs);
        } else if (rs instanceof FifoScheduler) {
            sinfo = new FifoSchedulerInfo(this.rm);
        } else {
            throw new NotFoundException("Unknown scheduler configured");
        }
        return new SchedulerTypeInfo(sinfo);
    }

    @GET
    @Path(value="/nodes")
    @Produces(value={"application/json", "application/xml"})
    public NodesInfo getNodes(@QueryParam(value="states") String states) {
        EnumSet<NodeState> acceptedStates;
        this.init();
        ResourceScheduler sched = this.rm.getResourceScheduler();
        if (sched == null) {
            throw new NotFoundException("Null ResourceScheduler instance");
        }
        if (states == null) {
            acceptedStates = EnumSet.allOf(NodeState.class);
        } else {
            acceptedStates = EnumSet.noneOf(NodeState.class);
            for (String stateStr : states.split(",")) {
                acceptedStates.add(NodeState.valueOf(stateStr.toUpperCase()));
            }
        }
        List<RMNode> rmNodes = RMServerUtils.queryRMNodes(this.rm.getRMContext(), acceptedStates);
        NodesInfo nodesInfo = new NodesInfo();
        for (RMNode rmNode : rmNodes) {
            NodeInfo nodeInfo = new NodeInfo(rmNode, sched);
            if (EnumSet.of(NodeState.LOST, NodeState.DECOMMISSIONED, NodeState.REBOOTED).contains((Object)rmNode.getState())) {
                nodeInfo.setNodeHTTPAddress(EMPTY);
            }
            nodesInfo.add(nodeInfo);
        }
        return nodesInfo;
    }

    @GET
    @Path(value="/nodes/{nodeId}")
    @Produces(value={"application/json", "application/xml"})
    public NodeInfo getNode(@PathParam(value="nodeId") String nodeId) {
        this.init();
        if (nodeId == null || nodeId.isEmpty()) {
            throw new NotFoundException("nodeId, " + nodeId + ", is empty or null");
        }
        ResourceScheduler sched = this.rm.getResourceScheduler();
        if (sched == null) {
            throw new NotFoundException("Null ResourceScheduler instance");
        }
        NodeId nid = ConverterUtils.toNodeId(nodeId);
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        boolean isInactive = false;
        if (ni == null) {
            ni = (RMNode)this.rm.getRMContext().getInactiveRMNodes().get(nid.getHost());
            if (ni == null) {
                throw new NotFoundException("nodeId, " + nodeId + ", is not found");
            }
            isInactive = true;
        }
        NodeInfo nodeInfo = new NodeInfo(ni, sched);
        if (isInactive) {
            nodeInfo.setNodeHTTPAddress(EMPTY);
        }
        return nodeInfo;
    }

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json", "application/xml"})
    public AppsInfo getApps(@Context HttpServletRequest hsr, @QueryParam(value="state") String stateQuery, @QueryParam(value="states") Set<String> statesQuery, @QueryParam(value="finalStatus") String finalStatusQuery, @QueryParam(value="user") String userQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="limit") String count, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd, @QueryParam(value="applicationTypes") Set<String> applicationTypes, @QueryParam(value="applicationTags") Set<String> applicationTags) {
        Set<String> appStates;
        Set<String> appTags;
        boolean checkCount = false;
        boolean checkStart = false;
        boolean checkEnd = false;
        boolean checkAppTypes = false;
        boolean checkAppStates = false;
        boolean checkAppTags = false;
        long countNum = 0L;
        long sBegin = 0L;
        long sEnd = Long.MAX_VALUE;
        long fBegin = 0L;
        long fEnd = Long.MAX_VALUE;
        this.init();
        if (count != null && !count.isEmpty()) {
            checkCount = true;
            countNum = Long.parseLong(count);
            if (countNum <= 0L) {
                throw new BadRequestException("limit value must be greater then 0");
            }
        }
        if (startedBegin != null && !startedBegin.isEmpty()) {
            checkStart = true;
            sBegin = Long.parseLong(startedBegin);
            if (sBegin < 0L) {
                throw new BadRequestException("startedTimeBegin must be greater than 0");
            }
        }
        if (startedEnd != null && !startedEnd.isEmpty()) {
            checkStart = true;
            sEnd = Long.parseLong(startedEnd);
            if (sEnd < 0L) {
                throw new BadRequestException("startedTimeEnd must be greater than 0");
            }
        }
        if (sBegin > sEnd) {
            throw new BadRequestException("startedTimeEnd must be greater than startTimeBegin");
        }
        if (finishBegin != null && !finishBegin.isEmpty()) {
            checkEnd = true;
            fBegin = Long.parseLong(finishBegin);
            if (fBegin < 0L) {
                throw new BadRequestException("finishTimeBegin must be greater than 0");
            }
        }
        if (finishEnd != null && !finishEnd.isEmpty()) {
            checkEnd = true;
            fEnd = Long.parseLong(finishEnd);
            if (fEnd < 0L) {
                throw new BadRequestException("finishTimeEnd must be greater than 0");
            }
        }
        if (fBegin > fEnd) {
            throw new BadRequestException("finishTimeEnd must be greater than finishTimeBegin");
        }
        Set<String> appTypes = RMWebServices.parseQueries(applicationTypes, false);
        if (!appTypes.isEmpty()) {
            checkAppTypes = true;
        }
        if (!(appTags = RMWebServices.parseQueries(applicationTags, false)).isEmpty()) {
            checkAppTags = true;
        }
        if (stateQuery != null && !stateQuery.isEmpty()) {
            statesQuery.add(stateQuery);
        }
        if (!(appStates = RMWebServices.parseQueries(statesQuery, true)).isEmpty()) {
            checkAppStates = true;
        }
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        if (checkStart) {
            request.setStartRange(sBegin, sEnd);
        }
        if (checkEnd) {
            request.setFinishRange(fBegin, fEnd);
        }
        if (checkCount) {
            request.setLimit(countNum);
        }
        if (checkAppTypes) {
            request.setApplicationTypes(appTypes);
        }
        if (checkAppTags) {
            request.setApplicationTags(appTags);
        }
        if (checkAppStates) {
            request.setApplicationStates(appStates);
        }
        if (queueQuery != null && !queueQuery.isEmpty()) {
            ResourceScheduler rs = this.rm.getResourceScheduler();
            if (rs instanceof CapacityScheduler) {
                CapacityScheduler cs = (CapacityScheduler)rs;
                try {
                    cs.getQueueInfo(queueQuery, false, false);
                }
                catch (IOException e) {
                    throw new BadRequestException(e.getMessage());
                }
            }
            HashSet<String> queues = new HashSet<String>(1);
            queues.add(queueQuery);
            request.setQueues(queues);
        }
        if (userQuery != null && !userQuery.isEmpty()) {
            HashSet<String> users = new HashSet<String>(1);
            users.add(userQuery);
            request.setUsers(users);
        }
        List<ApplicationReport> appReports = null;
        try {
            appReports = this.rm.getClientRMService().getApplications(request, false).getApplicationList();
        }
        catch (YarnException e) {
            LOG.error((Object)"Unable to retrieve apps from ClientRMService", (Throwable)e);
            throw new YarnRuntimeException("Unable to retrieve apps from ClientRMService", e);
        }
        ConcurrentMap<ApplicationId, RMApp> apps = this.rm.getRMContext().getRMApps();
        AppsInfo allApps = new AppsInfo();
        for (ApplicationReport report : appReports) {
            RMApp rmapp = (RMApp)apps.get(report.getApplicationId());
            if (finalStatusQuery != null && !finalStatusQuery.isEmpty()) {
                FinalApplicationStatus.valueOf(finalStatusQuery);
                if (!rmapp.getFinalApplicationStatus().toString().equalsIgnoreCase(finalStatusQuery)) continue;
            }
            AppInfo app = new AppInfo(rmapp, this.hasAccess(rmapp, hsr), WebAppUtils.getHttpSchemePrefix(this.conf));
            allApps.add(app);
        }
        return allApps;
    }

    @GET
    @Path(value="/appstatistics")
    @Produces(value={"application/json", "application/xml"})
    public ApplicationStatisticsInfo getAppStatistics(@Context HttpServletRequest hsr, @QueryParam(value="states") Set<String> stateQueries, @QueryParam(value="applicationTypes") Set<String> typeQueries) {
        this.init();
        Set<String> states = RMWebServices.parseQueries(stateQueries, true);
        Set<String> types = RMWebServices.parseQueries(typeQueries, false);
        if (types.size() == 0) {
            types.add(ANY);
        } else if (types.size() != 1) {
            throw new BadRequestException("# of applicationTypes = " + types.size() + ", we temporarily support at most one applicationType");
        }
        if (states.size() == 0) {
            for (YarnApplicationState state : YarnApplicationState.values()) {
                states.add(state.toString().toLowerCase());
            }
        }
        Map<YarnApplicationState, Map<String, Long>> scoreboard = RMWebServices.buildScoreboard(states, types);
        ConcurrentMap<ApplicationId, RMApp> apps = this.rm.getRMContext().getRMApps();
        for (RMApp rmapp : apps.values()) {
            YarnApplicationState state = rmapp.createApplicationState();
            String type = rmapp.getApplicationType().trim().toLowerCase();
            if (!states.contains(state.toString().toLowerCase())) continue;
            if (types.contains(ANY)) {
                RMWebServices.countApp(scoreboard, state, ANY);
                continue;
            }
            if (!types.contains(type)) continue;
            RMWebServices.countApp(scoreboard, state, type);
        }
        ApplicationStatisticsInfo appStatInfo = new ApplicationStatisticsInfo();
        for (Map.Entry<YarnApplicationState, Map<String, Long>> partScoreboard : scoreboard.entrySet()) {
            for (Map.Entry<String, Long> statEntry : partScoreboard.getValue().entrySet()) {
                StatisticsItemInfo statItem = new StatisticsItemInfo(partScoreboard.getKey(), statEntry.getKey(), statEntry.getValue());
                appStatInfo.add(statItem);
            }
        }
        return appStatInfo;
    }

    private static Set<String> parseQueries(Set<String> queries, boolean isState) {
        HashSet<String> params = new HashSet<String>();
        if (!queries.isEmpty()) {
            for (String query : queries) {
                String[] paramStrs;
                if (query == null || query.trim().isEmpty()) continue;
                for (String paramStr : paramStrs = query.split(",")) {
                    if (paramStr == null || paramStr.trim().isEmpty()) continue;
                    if (isState) {
                        try {
                            YarnApplicationState.valueOf(paramStr.trim().toUpperCase());
                        }
                        catch (RuntimeException e) {
                            YarnApplicationState[] stateArray = YarnApplicationState.values();
                            String allAppStates = Arrays.toString((Object[])stateArray);
                            throw new BadRequestException("Invalid application-state " + paramStr.trim() + " specified. It should be one of " + allAppStates);
                        }
                    }
                    params.add(paramStr.trim().toLowerCase());
                }
            }
        }
        return params;
    }

    private static Map<YarnApplicationState, Map<String, Long>> buildScoreboard(Set<String> states, Set<String> types) {
        HashMap<YarnApplicationState, Map<String, Long>> scoreboard = new HashMap<YarnApplicationState, Map<String, Long>>();
        assert (!states.isEmpty());
        for (String state : states) {
            HashMap<String, Long> partScoreboard = new HashMap<String, Long>();
            scoreboard.put(YarnApplicationState.valueOf(state.toUpperCase()), partScoreboard);
            for (String type : types) {
                partScoreboard.put(type, 0L);
            }
        }
        return scoreboard;
    }

    private static void countApp(Map<YarnApplicationState, Map<String, Long>> scoreboard, YarnApplicationState state, String type) {
        Map<String, Long> partScoreboard = scoreboard.get((Object)state);
        Long count = partScoreboard.get(type);
        partScoreboard.put(type, count + 1L);
    }

    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json", "application/xml"})
    public AppInfo getApp(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) {
        this.init();
        if (appId == null || appId.isEmpty()) {
            throw new NotFoundException("appId, " + appId + ", is empty or null");
        }
        ApplicationId id = ConverterUtils.toApplicationId(recordFactory, appId);
        if (id == null) {
            throw new NotFoundException("appId is null");
        }
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(id);
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        return new AppInfo(app, this.hasAccess(app, hsr), hsr.getScheme() + "://");
    }

    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json", "application/xml"})
    public AppAttemptsInfo getAppAttempts(@PathParam(value="appid") String appId) {
        this.init();
        if (appId == null || appId.isEmpty()) {
            throw new NotFoundException("appId, " + appId + ", is empty or null");
        }
        ApplicationId id = ConverterUtils.toApplicationId(recordFactory, appId);
        if (id == null) {
            throw new NotFoundException("appId is null");
        }
        RMApp app = (RMApp)this.rm.getRMContext().getRMApps().get(id);
        if (app == null) {
            throw new NotFoundException("app with id: " + appId + " not found");
        }
        AppAttemptsInfo appAttemptsInfo = new AppAttemptsInfo();
        for (RMAppAttempt attempt : app.getAppAttempts().values()) {
            AppAttemptInfo attemptInfo = new AppAttemptInfo(attempt, app.getUser());
            appAttemptsInfo.add(attemptInfo);
        }
        return appAttemptsInfo;
    }
}

