/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.types.DataType;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public final class CliUtils {
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");

    private CliUtils() {
    }

    public static void repeatChar(AttributedStringBuilder sb, char c, int count) {
        IntStream.range(0, count).forEach(i -> sb.append(c));
    }

    public static void normalizeColumn(AttributedStringBuilder sb, String col, int maxWidth) {
        if (col.length() > maxWidth) {
            sb.append(col, 0, maxWidth - 1);
            sb.append('~');
        } else {
            CliUtils.repeatChar(sb, ' ', maxWidth - col.length());
            sb.append(col);
        }
    }

    public static List<AttributedString> formatTwoLineHelpOptions(int width, List<Tuple2<String, String>> options) {
        AttributedStringBuilder line1 = new AttributedStringBuilder();
        AttributedStringBuilder line2 = new AttributedStringBuilder();
        int columns = (int)Math.ceil((double)options.size() / 2.0);
        int space = (width - " ".length() - columns * 13) / columns;
        Iterator<Tuple2<String, String>> iter = options.iterator();
        while (iter.hasNext()) {
            Tuple2<String, String> option = iter.next();
            line1.style(AttributedStyle.DEFAULT.inverse());
            line1.append((CharSequence)option.f0);
            line1.style(AttributedStyle.DEFAULT);
            line1.append(' ');
            line1.append((CharSequence)option.f1);
            CliUtils.repeatChar(line1, ' ', 11 - ((String)option.f1).length() + space);
            if (!iter.hasNext()) continue;
            option = iter.next();
            line2.style(AttributedStyle.DEFAULT.inverse());
            line2.append((CharSequence)option.f0);
            line2.style(AttributedStyle.DEFAULT);
            line2.append(' ');
            line2.append((CharSequence)option.f1);
            CliUtils.repeatChar(line2, ' ', 11 - ((String)option.f1).length() + space);
        }
        return Arrays.asList(line1.toAttributedString(), line2.toAttributedString());
    }

    public static String[] typesToString(DataType[] types) {
        String[] typesAsString = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            typesAsString[i] = types[i].toString();
        }
        return typesAsString;
    }

    public static boolean createFile(Path filePath) {
        try {
            Path parent = filePath.getParent();
            if (parent == null) {
                return false;
            }
            if (Files.notExists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (Files.notExists(filePath, new LinkOption[0])) {
                Files.createFile(filePath, new FileAttribute[0]);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ZoneId getSessionTimeZone(ReadableConfig sessionConfig) {
        String zone = (String)sessionConfig.get(TableConfigOptions.LOCAL_TIME_ZONE);
        return ((String)TableConfigOptions.LOCAL_TIME_ZONE.defaultValue()).equals(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
    }
}

