/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.com.google.common.primitives;

import java.io.Serializable;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.annotations.Beta;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.primitives.Longs;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.primitives.UnsignedLongs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible(serializable=true)
public class UnsignedLong
extends Number
implements Comparable<UnsignedLong>,
Serializable {
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    public static final UnsignedLong ZERO = new UnsignedLong(0L);
    public static final UnsignedLong ONE = new UnsignedLong(1L);
    public static final UnsignedLong MAX_VALUE = new UnsignedLong(-1L);
    private final long value;

    protected UnsignedLong(long value) {
        this.value = value;
    }

    public static UnsignedLong asUnsigned(long value) {
        return new UnsignedLong(value);
    }

    public static UnsignedLong valueOf(BigInteger value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.signum() >= 0 && value.bitLength() <= 64, "value (%s) is outside the range for an unsigned long value", value);
        return UnsignedLong.asUnsigned(value.longValue());
    }

    public static UnsignedLong valueOf(String string) {
        return UnsignedLong.valueOf(string, 10);
    }

    public static UnsignedLong valueOf(String string, int radix) {
        return UnsignedLong.asUnsigned(UnsignedLongs.parseUnsignedLong(string, radix));
    }

    public UnsignedLong add(UnsignedLong val) {
        Preconditions.checkNotNull(val);
        return UnsignedLong.asUnsigned(this.value + val.value);
    }

    public UnsignedLong subtract(UnsignedLong val) {
        Preconditions.checkNotNull(val);
        return UnsignedLong.asUnsigned(this.value - val.value);
    }

    public UnsignedLong multiply(UnsignedLong val) {
        Preconditions.checkNotNull(val);
        return UnsignedLong.asUnsigned(this.value * val.value);
    }

    public UnsignedLong divide(UnsignedLong val) {
        Preconditions.checkNotNull(val);
        return UnsignedLong.asUnsigned(UnsignedLongs.divide(this.value, val.value));
    }

    public UnsignedLong remainder(UnsignedLong val) {
        Preconditions.checkNotNull(val);
        return UnsignedLong.asUnsigned(UnsignedLongs.remainder(this.value, val.value));
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        float fValue = this.value & Long.MAX_VALUE;
        if (this.value < 0L) {
            fValue += 9.223372E18f;
        }
        return fValue;
    }

    @Override
    public double doubleValue() {
        double dValue = this.value & Long.MAX_VALUE;
        if (this.value < 0L) {
            dValue += 9.223372036854776E18;
        }
        return dValue;
    }

    public BigInteger bigIntegerValue() {
        BigInteger bigInt = BigInteger.valueOf(this.value & Long.MAX_VALUE);
        if (this.value < 0L) {
            bigInt = bigInt.setBit(63);
        }
        return bigInt;
    }

    @Override
    public int compareTo(UnsignedLong o) {
        Preconditions.checkNotNull(o);
        return UnsignedLongs.compare(this.value, o.value);
    }

    public int hashCode() {
        return Longs.hashCode(this.value);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UnsignedLong) {
            UnsignedLong other = (UnsignedLong)obj;
            return this.value == other.value;
        }
        return false;
    }

    public String toString() {
        return UnsignedLongs.toString(this.value);
    }

    public String toString(int radix) {
        return UnsignedLongs.toString(this.value, radix);
    }
}

