/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.com.nimbusds.jose;

import org.apache.flink.fs.openstackhadoop.shaded.net.jcip.annotations.Immutable;
import org.apache.flink.fs.openstackhadoop.shaded.net.minidev.json.JSONAware;
import org.apache.flink.fs.openstackhadoop.shaded.net.minidev.json.JSONObject;

@Immutable
public final class JOSEObjectType
implements JSONAware {
    public static final JOSEObjectType JOSE = new JOSEObjectType("JOSE");
    public static final JOSEObjectType JOSE_JSON = new JOSEObjectType("JOSE+JSON");
    public static final JOSEObjectType JWT = new JOSEObjectType("JWT");
    private final String type;

    public JOSEObjectType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("The object type must not be null");
        }
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof JOSEObjectType && this.toString().equals(object.toString());
    }

    public String toString() {
        return this.type;
    }

    @Override
    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(JSONObject.escape(this.type));
        sb.append('\"');
        return sb.toString();
    }
}

