/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.BeanUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.DynaBean;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.DynaProperty;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.MethodUtils;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.NestedNullException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.WeakFastHashMap;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.WrapDynaBean;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.expression.Resolver;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.collections.FastHashMap;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;

public class PropertyUtilsBean {
    private Resolver resolver = new DefaultResolver();
    private WeakFastHashMap descriptorsCache = null;
    private WeakFastHashMap mappedDescriptorsCache = null;
    private static final Class[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Class[] LIST_CLASS_PARAMETER = new Class[]{class$java$util$List == null ? (class$java$util$List = PropertyUtilsBean.class$("java.util.List")) : class$java$util$List};
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private Log log = LogFactory.getLog(class$org$apache$commons$beanutils$PropertyUtils == null ? (class$org$apache$commons$beanutils$PropertyUtils = PropertyUtilsBean.class$("org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.beanutils.PropertyUtils")) : class$org$apache$commons$beanutils$PropertyUtils);
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$apache$commons$beanutils$PropertyUtils;

    protected static PropertyUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getPropertyUtils();
    }

    public PropertyUtilsBean() {
        this.descriptorsCache = new WeakFastHashMap();
        this.descriptorsCache.setFast(true);
        this.mappedDescriptorsCache = new WeakFastHashMap();
        this.mappedDescriptorsCache.setFast(true);
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver == null ? new DefaultResolver() : resolver;
    }

    public void clearDescriptors() {
        this.descriptorsCache.clear();
        this.mappedDescriptorsCache.clear();
        Introspector.flushCaches();
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!this.isReadable(orig, name) || !this.isWriteable(dest, name)) continue;
                try {
                    Object value = ((DynaBean)orig).get(name);
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name, value);
                        continue;
                    }
                    this.setSimpleProperty(dest, name, value);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + name + "' on class '" + dest.getClass() + "'", e);
                }
            }
        } else if (orig instanceof Map) {
            Iterator entries = ((Map)orig).entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String name = (String)entry.getKey();
                if (!this.isWriteable(dest, name)) continue;
                try {
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name, entry.getValue());
                        continue;
                    }
                    this.setSimpleProperty(dest, name, entry.getValue());
                }
                catch (NoSuchMethodException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + name + "' on class '" + dest.getClass() + "'", e);
                }
            }
        } else {
            PropertyDescriptor[] origDescriptors = this.getPropertyDescriptors(orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!this.isReadable(orig, name) || !this.isWriteable(dest, name)) continue;
                try {
                    Object value = this.getSimpleProperty(orig, name);
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name, value);
                        continue;
                    }
                    this.setSimpleProperty(dest, name, value);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + name + "' on class '" + dest.getClass() + "'", e);
                }
            }
        }
    }

    public Map describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        HashMap<String, Object> description = new HashMap<String, Object>();
        if (bean instanceof DynaBean) {
            DynaProperty[] descriptors = ((DynaBean)bean).getDynaClass().getDynaProperties();
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                description.put(name, this.getProperty(bean, name));
            }
        } else {
            PropertyDescriptor[] descriptors = this.getPropertyDescriptors(bean);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if (descriptors[i].getReadMethod() == null) continue;
                description.put(name, this.getProperty(bean, name));
            }
        }
        return description;
    }

    public Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        int index = -1;
        try {
            index = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "' " + e.getMessage());
        }
        if (index < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getIndexedProperty(bean, name, index);
    }

    public Object getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            if (bean.getClass().isArray()) {
                return Array.get(bean, index);
            }
            if (bean instanceof List) {
                return ((List)bean).get(index);
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            return ((DynaBean)bean).get(name, index);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
            if (readMethod != null) {
                Object[] subscript = new Object[]{new Integer(index)};
                try {
                    return this.invokeMethod(readMethod, bean, subscript);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof IndexOutOfBoundsException) {
                        throw (IndexOutOfBoundsException)e.getTargetException();
                    }
                    throw e;
                }
            }
        }
        if ((readMethod = this.getReadMethod(bean.getClass(), descriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no " + "getter method on bean class '" + bean.getClass() + "'");
        }
        Object value = this.invokeMethod(readMethod, bean, EMPTY_OBJECT_ARRAY);
        if (!value.getClass().isArray()) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean.getClass() + "'");
            }
            return ((List)value).get(index);
        }
        try {
            return Array.get(value, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Size: " + Array.getLength(value) + " for property '" + name + "'");
        }
    }

    public Object getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        String key = null;
        try {
            key = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "' " + e.getMessage());
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getMappedProperty(bean, name, key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class " + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor != null) return ((DynaBean)bean).get(name, key);
            throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean.getClass() + "'");
        }
        Object result = null;
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method readMethod = ((MappedPropertyDescriptor)descriptor).getMappedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            Object[] keyArray = new Object[]{key};
            return this.invokeMethod(readMethod, bean, keyArray);
        }
        Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
        if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
        Object invokeResult = this.invokeMethod(readMethod, bean, EMPTY_OBJECT_ARRAY);
        if (!(invokeResult instanceof Map)) return result;
        return ((Map)invokeResult).get(key);
    }

    public FastHashMap getMappedPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            return null;
        }
        return (FastHashMap)this.mappedDescriptorsCache.get(beanClass);
    }

    public FastHashMap getMappedPropertyDescriptors(Object bean) {
        if (bean == null) {
            return null;
        }
        return this.getMappedPropertyDescriptors(bean.getClass());
    }

    public Object getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            nestedBean = bean instanceof Map ? this.getPropertyOfMapBean((Map)bean, next) : (this.resolver.isMapped(next) ? this.getMappedProperty(bean, next) : (this.resolver.isIndexed(next) ? this.getIndexedProperty(bean, next) : this.getSimpleProperty(bean, next)));
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        bean = bean instanceof Map ? this.getPropertyOfMapBean((Map)bean, name) : (this.resolver.isMapped(name) ? this.getMappedProperty(bean, name) : (this.resolver.isIndexed(name) ? this.getIndexedProperty(bean, name) : this.getSimpleProperty(bean, name)));
        return bean;
    }

    protected Object getPropertyOfMapBean(Map bean, String propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name;
        if (this.resolver.isMapped(propertyName) && ((name = this.resolver.getProperty(propertyName)) == null || name.length() == 0)) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        return bean.get(propertyName);
    }

    public Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name);
    }

    public PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = this.getProperty(bean, next);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        if ((name = this.resolver.getProperty(name)) == null) {
            return null;
        }
        PropertyDescriptor[] descriptors = this.getPropertyDescriptors(bean);
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                if (!name.equals(descriptors[i].getName())) continue;
                return descriptors[i];
            }
        }
        PropertyDescriptor result = null;
        FastHashMap mappedDescriptors = this.getMappedPropertyDescriptors(bean);
        if (mappedDescriptors == null) {
            mappedDescriptors = new FastHashMap();
            mappedDescriptors.setFast(true);
            this.mappedDescriptorsCache.put(bean.getClass(), mappedDescriptors);
        }
        if ((result = (PropertyDescriptor)mappedDescriptors.get(name)) == null) {
            try {
                result = new MappedPropertyDescriptor(name, (Class)bean.getClass());
            }
            catch (IntrospectionException ie) {
                // empty catch block
            }
            if (result != null) {
                mappedDescriptors.put(name, result);
            }
        }
        return result;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] descriptors = null;
        descriptors = (PropertyDescriptor[])this.descriptorsCache.get(beanClass);
        if (descriptors != null) {
            return descriptors;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        for (int i = 0; i < descriptors.length; ++i) {
            String methodName;
            Method readMethod;
            if (!(descriptors[i] instanceof IndexedPropertyDescriptor)) continue;
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)descriptors[i];
            String propName = descriptor.getName().substring(0, 1).toUpperCase() + descriptor.getName().substring(1);
            if (descriptor.getReadMethod() == null && (readMethod = MethodUtils.getMatchingAccessibleMethod(beanClass, methodName = descriptor.getIndexedReadMethod() != null ? descriptor.getIndexedReadMethod().getName() : "get" + propName, EMPTY_CLASS_PARAMETERS)) != null) {
                try {
                    descriptor.setReadMethod(readMethod);
                }
                catch (Exception e) {
                    this.log.error("Error setting indexed property read method", e);
                }
            }
            if (descriptor.getWriteMethod() != null) continue;
            methodName = descriptor.getIndexedWriteMethod() != null ? descriptor.getIndexedWriteMethod().getName() : "set" + propName;
            Method writeMethod = MethodUtils.getMatchingAccessibleMethod(beanClass, methodName, LIST_CLASS_PARAMETER);
            if (writeMethod == null) {
                Method[] methods = beanClass.getMethods();
                for (int j = 0; j < methods.length; ++j) {
                    Class<?>[] parameterTypes;
                    if (!methods[j].getName().equals(methodName) || (parameterTypes = methods[j].getParameterTypes()).length != 1 || !(class$java$util$List == null ? PropertyUtilsBean.class$("java.util.List") : class$java$util$List).isAssignableFrom(parameterTypes[0])) continue;
                    writeMethod = methods[j];
                    break;
                }
            }
            if (writeMethod == null) continue;
            try {
                descriptor.setWriteMethod(writeMethod);
                continue;
            }
            catch (Exception e) {
                this.log.error("Error setting indexed property write method", e);
            }
        }
        this.descriptorsCache.put(beanClass, descriptors);
        return descriptors;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        return this.getPropertyDescriptors(bean.getClass());
    }

    public Class getPropertyEditorClass(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor != null) {
            return descriptor.getPropertyEditorClass();
        }
        return null;
    }

    public Class getPropertyType(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object descriptor;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = this.getProperty(bean, next);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean instanceof DynaBean) {
            descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                return null;
            }
            Class type = ((DynaProperty)descriptor).getType();
            if (type == null) {
                return null;
            }
            if (type.isArray()) {
                return type.getComponentType();
            }
            return type;
        }
        descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            return null;
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType();
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            return ((MappedPropertyDescriptor)descriptor).getMappedPropertyType();
        }
        return ((PropertyDescriptor)descriptor).getPropertyType();
    }

    public Method getReadMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getReadMethod());
    }

    Method getReadMethod(Class clazz, PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(clazz, descriptor.getReadMethod());
    }

    public Object getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean).getDynaClass() + "'");
            }
            return ((DynaBean)bean).get(name);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method in class '" + bean.getClass() + "'");
        }
        Object value = this.invokeMethod(readMethod, bean, EMPTY_OBJECT_ARRAY);
        return value;
    }

    public Method getWriteMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getWriteMethod());
    }

    Method getWriteMethod(Class clazz, PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(clazz, descriptor.getWriteMethod());
    }

    public boolean isReadable(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            try {
                nestedBean = this.getProperty(bean, next);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean instanceof WrapDynaBean) {
            bean = ((WrapDynaBean)bean).getInstance();
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean, name);
            if (desc != null) {
                Method readMethod = this.getReadMethod(bean.getClass(), desc);
                if (readMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        readMethod = ((IndexedPropertyDescriptor)desc).getIndexedReadMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        readMethod = ((MappedPropertyDescriptor)desc).getMappedReadMethod();
                    }
                    readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
                }
                return readMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isWriteable(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            try {
                nestedBean = this.getProperty(bean, next);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean instanceof WrapDynaBean) {
            bean = ((WrapDynaBean)bean).getInstance();
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            PropertyDescriptor desc = this.getPropertyDescriptor(bean, name);
            if (desc != null) {
                Method writeMethod = this.getWriteMethod(bean.getClass(), desc);
                if (writeMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        writeMethod = ((IndexedPropertyDescriptor)desc).getIndexedWriteMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        writeMethod = ((MappedPropertyDescriptor)desc).getMappedWriteMethod();
                    }
                    writeMethod = MethodUtils.getAccessibleMethod(bean.getClass(), writeMethod);
                }
                return writeMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void setIndexedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        int index = -1;
        try {
            index = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setIndexedProperty(bean, name, index, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIndexedProperty(Object bean, String name, int index, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            if (bean.getClass().isArray()) {
                Array.set(bean, index, value);
                return;
            }
            if (bean instanceof List) {
                ((List)bean).set(index, value);
                return;
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            ((DynaBean)bean).set(name, index, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            Method writeMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod();
            writeMethod = MethodUtils.getAccessibleMethod(bean.getClass(), writeMethod);
            if (writeMethod != null) {
                Object[] subscript = new Object[]{new Integer(index), value};
                try {
                    if (this.log.isTraceEnabled()) {
                        String valueClassName = value == null ? "<null>" : value.getClass().getName();
                        this.log.trace("setSimpleProperty: Invoking method " + writeMethod + " with index=" + index + ", value=" + value + " (class " + valueClassName + ")");
                    }
                    this.invokeMethod(writeMethod, bean, subscript);
                    return;
                }
                catch (InvocationTargetException e) {
                    if (!(e.getTargetException() instanceof IndexOutOfBoundsException)) throw e;
                    throw (IndexOutOfBoundsException)e.getTargetException();
                }
            }
        }
        if ((readMethod = this.getReadMethod(bean.getClass(), descriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean.getClass() + "'");
        }
        Object array = this.invokeMethod(readMethod, bean, EMPTY_OBJECT_ARRAY);
        if (!array.getClass().isArray()) {
            if (!(array instanceof List)) throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean.getClass() + "'");
            ((List)array).set(index, value);
            return;
        } else {
            Array.set(array, index, value);
        }
    }

    public void setMappedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        String key = null;
        try {
            key = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setMappedProperty(bean, name, key, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMappedProperty(Object bean, String name, String key, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            ((DynaBean)bean).set(name, key, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method mappedWriteMethod = ((MappedPropertyDescriptor)descriptor).getMappedWriteMethod();
            mappedWriteMethod = MethodUtils.getAccessibleMethod(bean.getClass(), mappedWriteMethod);
            if (mappedWriteMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped setter method" + "on bean class '" + bean.getClass() + "'");
            Object[] params = new Object[]{key, value};
            if (this.log.isTraceEnabled()) {
                String valueClassName = value == null ? "<null>" : value.getClass().getName();
                this.log.trace("setSimpleProperty: Invoking method " + mappedWriteMethod + " with key=" + key + ", value=" + value + " (class " + valueClassName + ")");
            }
            this.invokeMethod(mappedWriteMethod, bean, params);
            return;
        } else {
            Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            Object invokeResult = this.invokeMethod(readMethod, bean, EMPTY_OBJECT_ARRAY);
            if (!(invokeResult instanceof Map)) return;
            ((Map)invokeResult).put(key, value);
        }
    }

    public void setNestedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String next = this.resolver.next(name);
            Object nestedBean = null;
            nestedBean = bean instanceof Map ? this.getPropertyOfMapBean((Map)bean, next) : (this.resolver.isMapped(next) ? this.getMappedProperty(bean, next) : (this.resolver.isIndexed(next) ? this.getIndexedProperty(bean, next) : this.getSimpleProperty(bean, next)));
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
        }
        if (bean instanceof Map) {
            this.setPropertyOfMapBean((Map)bean, name, value);
        } else if (this.resolver.isMapped(name)) {
            this.setMappedProperty(bean, name, value);
        } else if (this.resolver.isIndexed(name)) {
            this.setIndexedProperty(bean, name, value);
        } else {
            this.setSimpleProperty(bean, name, value);
        }
    }

    protected void setPropertyOfMapBean(Map bean, String propertyName, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name;
        if (this.resolver.isMapped(propertyName) && ((name = this.resolver.getProperty(propertyName)) == null || name.length() == 0)) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        bean.put(propertyName, value);
    }

    public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.setNestedProperty(bean, name, value);
    }

    public void setSimpleProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean).getDynaClass() + "'");
            }
            ((DynaBean)bean).set(name, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method writeMethod = this.getWriteMethod(bean.getClass(), descriptor);
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method in class '" + bean.getClass() + "'");
        }
        Object[] values = new Object[]{value};
        if (this.log.isTraceEnabled()) {
            String valueClassName = value == null ? "<null>" : value.getClass().getName();
            this.log.trace("setSimpleProperty: Invoking method " + writeMethod + " with value " + value + " (class " + valueClassName + ")");
        }
        this.invokeMethod(writeMethod, bean, values);
    }

    private Object invokeMethod(Method method, Object bean, Object[] values) throws IllegalAccessException, InvocationTargetException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified - this should have been checked before reaching this method");
        }
        try {
            return method.invoke(bean, values);
        }
        catch (NullPointerException cause) {
            IllegalArgumentException e;
            String valueString = "";
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        valueString = valueString + ", ";
                    }
                    valueString = values[i] == null ? valueString + "<null>" : valueString + values[i].getClass().getName();
                }
            }
            String expectedString = "";
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i = 0; i < parTypes.length; ++i) {
                    if (i > 0) {
                        expectedString = expectedString + ", ";
                    }
                    expectedString = expectedString + parTypes[i].getName();
                }
            }
            if (!BeanUtils.initCause(e = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\""), cause)) {
                this.log.error("Method invocation failed", cause);
            }
            throw e;
        }
        catch (IllegalArgumentException cause) {
            IllegalArgumentException e;
            String valueString = "";
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        valueString = valueString + ", ";
                    }
                    valueString = values[i] == null ? valueString + "<null>" : valueString + values[i].getClass().getName();
                }
            }
            String expectedString = "";
            Class<?>[] parTypes = method.getParameterTypes();
            if (parTypes != null) {
                for (int i = 0; i < parTypes.length; ++i) {
                    if (i > 0) {
                        expectedString = expectedString + ", ";
                    }
                    expectedString = expectedString + parTypes[i].getName();
                }
            }
            if (!BeanUtils.initCause(e = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\""), cause)) {
                this.log.error("Method invocation failed", cause);
            }
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

