/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.crypto.random;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Random;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configurable;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class OsSecureRandom
extends Random
implements Closeable,
Configurable {
    public static final Log LOG = LogFactory.getLog(OsSecureRandom.class);
    private static final long serialVersionUID = 6391500337172057900L;
    private transient Configuration conf;
    private final int RESERVOIR_LENGTH = 8192;
    private String randomDevPath;
    private transient FileInputStream stream;
    private final byte[] reservoir = new byte[8192];
    private int pos = this.reservoir.length;

    private void fillReservoir(int min) {
        if (this.pos >= this.reservoir.length - min) {
            try {
                if (this.stream == null) {
                    this.stream = new FileInputStream(new File(this.randomDevPath));
                }
                IOUtils.readFully(this.stream, this.reservoir, 0, this.reservoir.length);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to fill reservoir", e);
            }
            this.pos = 0;
        }
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        this.conf = conf;
        this.randomDevPath = conf.get("hadoop.security.random.device.file.path", "/dev/urandom");
        this.close();
    }

    @Override
    public synchronized Configuration getConf() {
        return this.conf;
    }

    @Override
    public synchronized void nextBytes(byte[] bytes) {
        int off = 0;
        int n = 0;
        while (off < bytes.length) {
            this.fillReservoir(0);
            n = Math.min(bytes.length - off, this.reservoir.length - this.pos);
            System.arraycopy(this.reservoir, this.pos, bytes, off, n);
            off += n;
            this.pos += n;
        }
    }

    @Override
    protected synchronized int next(int nbits) {
        this.fillReservoir(4);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = n << 8 | this.reservoir[this.pos++] & 0xFF;
        }
        return n & -1 >> 32 - nbits;
    }

    @Override
    public synchronized void close() {
        if (this.stream != null) {
            IOUtils.cleanup(LOG, this.stream);
            this.stream = null;
        }
    }
}

