/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.permission;

import java.util.List;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Objects;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.permission.AclEntry;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.permission.FsAction;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class AclStatus {
    private final String owner;
    private final String group;
    private final boolean stickyBit;
    private final List<AclEntry> entries;
    private final FsPermission permission;

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isStickyBit() {
        return this.stickyBit;
    }

    public List<AclEntry> getEntries() {
        return this.entries;
    }

    public FsPermission getPermission() {
        return this.permission;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        AclStatus other = (AclStatus)o;
        return Objects.equal(this.owner, other.owner) && Objects.equal(this.group, other.group) && this.stickyBit == other.stickyBit && Objects.equal(this.entries, other.entries);
    }

    public int hashCode() {
        return Objects.hashCode(this.owner, this.group, this.stickyBit, this.entries);
    }

    public String toString() {
        return "owner: " + this.owner + ", group: " + this.group + ", acl: {" + "entries: " + this.entries + ", stickyBit: " + this.stickyBit + '}';
    }

    private AclStatus(String owner, String group, boolean stickyBit, Iterable<AclEntry> entries, FsPermission permission) {
        this.owner = owner;
        this.group = group;
        this.stickyBit = stickyBit;
        this.entries = Lists.newArrayList(entries);
        this.permission = permission;
    }

    public FsAction getEffectivePermission(AclEntry entry) {
        return this.getEffectivePermission(entry, this.permission);
    }

    public FsAction getEffectivePermission(AclEntry entry, FsPermission permArg) throws IllegalArgumentException {
        Preconditions.checkArgument(this.permission != null || permArg != null, "Permission bits are not available to calculate effective permission");
        if (this.permission != null) {
            permArg = this.permission;
        }
        if (entry.getName() != null || entry.getType() == AclEntryType.GROUP) {
            if (entry.getScope() == AclEntryScope.ACCESS) {
                FsAction entryPerm = entry.getPermission();
                return entryPerm.and(permArg.getGroupAction());
            }
            Preconditions.checkArgument(this.entries.contains(entry) && this.entries.size() >= 3, "Passed default ACL entry not found in the list of ACLs");
            FsAction defaultMask = this.entries.get(this.entries.size() - 2).getPermission();
            FsAction entryPerm = entry.getPermission();
            return entryPerm.and(defaultMask);
        }
        return entry.getPermission();
    }

    public static class Builder {
        private String owner;
        private String group;
        private boolean stickyBit;
        private List<AclEntry> entries = Lists.newArrayList();
        private FsPermission permission = null;

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder addEntry(AclEntry e) {
            this.entries.add(e);
            return this;
        }

        public Builder addEntries(Iterable<AclEntry> entries) {
            for (AclEntry e : entries) {
                this.entries.add(e);
            }
            return this;
        }

        public Builder stickyBit(boolean stickyBit) {
            this.stickyBit = stickyBit;
            return this;
        }

        public Builder setPermission(FsPermission permission) {
            this.permission = permission;
            return this;
        }

        public AclStatus build() {
            return new AclStatus(this.owner, this.group, this.stickyBit, this.entries, this.permission);
        }
    }
}

