/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.util.Deque;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.GlobPattern;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell.PathData;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell.find.BaseExpression;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell.find.ExpressionFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell.find.FilterExpression;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.shell.find.Result;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.StringUtils;

final class Name
extends BaseExpression {
    private static final String[] USAGE = new String[]{"-name pattern", "-iname pattern"};
    private static final String[] HELP = new String[]{"Evaluates as true if the basename of the file matches the", "pattern using standard file system globbing.", "If -iname is used then the match is case insensitive."};
    private GlobPattern globPattern;
    private boolean caseSensitive = true;

    public static void registerExpression(ExpressionFactory factory) throws IOException {
        factory.addClass(Name.class, "-name");
        factory.addClass(Iname.class, "-iname");
    }

    public Name() {
        this(true);
    }

    private Name(boolean caseSensitive) {
        this.setUsage(USAGE);
        this.setHelp(HELP);
        this.setCaseSensitive(caseSensitive);
    }

    private void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public void addArguments(Deque<String> args) {
        this.addArguments(args, 1);
    }

    @Override
    public void prepare() throws IOException {
        String argPattern = this.getArgument(1);
        if (!this.caseSensitive) {
            argPattern = StringUtils.toLowerCase(argPattern);
        }
        this.globPattern = new GlobPattern(argPattern);
    }

    @Override
    public Result apply(PathData item, int depth) throws IOException {
        String name = this.getPath(item).getName();
        if (!this.caseSensitive) {
            name = StringUtils.toLowerCase(name);
        }
        if (this.globPattern.matches(name)) {
            return Result.PASS;
        }
        return Result.FAIL;
    }

    static class Iname
    extends FilterExpression {
        public Iname() {
            super(new Name(false));
        }
    }
}

