/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.http;

import java.net.URI;
import java.util.Properties;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.exceptions.SwiftConfigurationException;

public final class RestClientBindings {
    private static final Log LOG = LogFactory.getLog(RestClientBindings.class);
    public static final String E_INVALID_NAME = "Invalid swift hostname '%s': hostname must in form container.service";

    public static String buildSwiftInstancePrefix(String service) {
        return "fs.swift.service." + service;
    }

    private static SwiftConfigurationException invalidName(String hostname) {
        return new SwiftConfigurationException(String.format(E_INVALID_NAME, hostname));
    }

    public static String extractContainerName(String hostname) throws SwiftConfigurationException {
        int i = hostname.indexOf(".");
        if (i <= 0) {
            throw RestClientBindings.invalidName(hostname);
        }
        return hostname.substring(0, i);
    }

    public static String extractContainerName(URI uri) throws SwiftConfigurationException {
        return RestClientBindings.extractContainerName(uri.getHost());
    }

    public static String extractServiceName(String hostname) throws SwiftConfigurationException {
        int i = hostname.indexOf(".");
        if (i <= 0) {
            throw RestClientBindings.invalidName(hostname);
        }
        String service = hostname.substring(i + 1);
        if (service.isEmpty() || service.contains(".")) {
            throw RestClientBindings.invalidName(hostname);
        }
        return service;
    }

    public static String extractServiceName(URI uri) throws SwiftConfigurationException {
        return RestClientBindings.extractServiceName(uri.getHost());
    }

    public static Properties bind(URI fsURI, Configuration conf) throws SwiftConfigurationException {
        String host = fsURI.getHost();
        if (host == null || host.isEmpty()) {
            throw RestClientBindings.invalidName(host);
        }
        String container = RestClientBindings.extractContainerName(host);
        String service = RestClientBindings.extractServiceName(host);
        String prefix = RestClientBindings.buildSwiftInstancePrefix(service);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filesystem " + fsURI + " is using configuration keys " + prefix);
        }
        Properties props = new Properties();
        props.setProperty("fs.swift.SERVICE-NAME", service);
        props.setProperty("fs.swift.CONTAINER-NAME", container);
        RestClientBindings.copy(conf, prefix + ".auth.url", props, "fs.swift.auth.url", true);
        RestClientBindings.copy(conf, prefix + ".username", props, "fs.swift.username", true);
        RestClientBindings.copy(conf, prefix + ".apikey", props, "fs.swift.apikey", false);
        RestClientBindings.copy(conf, prefix + ".password", props, "fs.swift.password", props.contains("fs.swift.apikey"));
        RestClientBindings.copy(conf, prefix + ".tenant", props, "fs.swift.tenant", false);
        RestClientBindings.copy(conf, prefix + ".region", props, "fs.swift.region", false);
        RestClientBindings.copy(conf, prefix + ".http.port", props, "fs.swift.http.port", false);
        RestClientBindings.copy(conf, prefix + ".https.port", props, "fs.swift.https.port", false);
        RestClientBindings.copyBool(conf, prefix + ".public", props, "fs.swift.public", false);
        RestClientBindings.copyBool(conf, prefix + ".location-aware", props, "fs.swift.location-aware", false);
        return props;
    }

    private static void copyBool(Configuration conf, String confKey, Properties props, String propsKey, boolean defVal) {
        boolean b = conf.getBoolean(confKey, defVal);
        props.setProperty(propsKey, Boolean.toString(b));
    }

    private static void set(Properties props, String key, String optVal) {
        if (optVal != null) {
            props.setProperty(key, optVal);
        }
    }

    public static void copy(Configuration conf, String confKey, Properties props, String propsKey, boolean required) throws SwiftConfigurationException {
        String val = conf.get(confKey);
        if (val != null) {
            val = val.trim();
        }
        if (required && val == null) {
            throw new SwiftConfigurationException("Missing mandatory configuration option: " + confKey);
        }
        RestClientBindings.set(props, propsKey, val);
    }
}

