/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.fs.swift.util;

public class Duration {
    private final long started;
    private long finished;

    public Duration() {
        this.finished = this.started = this.time();
    }

    private long time() {
        return System.currentTimeMillis();
    }

    public void finished() {
        this.finished = this.time();
    }

    public String getDurationString() {
        return Duration.humanTime(this.value());
    }

    public static String humanTime(long time) {
        long seconds = time / 1000L;
        long minutes = seconds / 60L;
        return String.format("%d:%02d:%03d", minutes, seconds % 60L, time % 1000L);
    }

    public String toString() {
        return this.getDurationString();
    }

    public long value() {
        return this.finished - this.started;
    }
}

