/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.protocol;

import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.protocol.HdfsFileStatus;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DirectoryListing {
    private HdfsFileStatus[] partialListing;
    private int remainingEntries;

    public DirectoryListing(HdfsFileStatus[] partialListing, int remainingEntries) {
        if (partialListing == null) {
            throw new IllegalArgumentException("partial listing should not be null");
        }
        if (partialListing.length == 0 && remainingEntries != 0) {
            throw new IllegalArgumentException("Partial listing is empty but the number of remaining entries is not zero");
        }
        this.partialListing = partialListing;
        this.remainingEntries = remainingEntries;
    }

    public HdfsFileStatus[] getPartialListing() {
        return this.partialListing;
    }

    public int getRemainingEntries() {
        return this.remainingEntries;
    }

    public boolean hasMore() {
        return this.remainingEntries != 0;
    }

    public byte[] getLastName() {
        if (this.partialListing.length == 0) {
            return null;
        }
        return this.partialListing[this.partialListing.length - 1].getLocalNameInBytes();
    }
}

