/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.qjournal.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import javax.servlet.ServletContext;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.DFSUtil;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.qjournal.server.GetJournalEditServlet;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.http.HttpServer2;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class JournalNodeHttpServer {
    public static final String JN_ATTRIBUTE_KEY = "localjournal";
    private HttpServer2 httpServer;
    private final JournalNode localJournalNode;
    private final Configuration conf;

    JournalNodeHttpServer(Configuration conf, JournalNode jn) {
        this.conf = conf;
        this.localJournalNode = jn;
    }

    void start() throws IOException {
        InetSocketAddress httpAddr = JournalNodeHttpServer.getAddress(this.conf);
        String httpsAddrString = this.conf.get("dfs.journalnode.https-address", "0.0.0.0:8481");
        InetSocketAddress httpsAddr = NetUtils.createSocketAddr(httpsAddrString);
        HttpServer2.Builder builder = DFSUtil.httpServerTemplateForNNAndJN(this.conf, httpAddr, httpsAddr, "journal", "dfs.journalnode.kerberos.internal.spnego.principal", "dfs.journalnode.keytab.file");
        this.httpServer = builder.build();
        this.httpServer.setAttribute(JN_ATTRIBUTE_KEY, this.localJournalNode);
        this.httpServer.setAttribute("current.conf", this.conf);
        this.httpServer.addInternalServlet("getJournal", "/getJournal", GetJournalEditServlet.class, true);
        this.httpServer.start();
    }

    void stop() throws IOException {
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Deprecated
    public InetSocketAddress getAddress() {
        InetSocketAddress addr = this.httpServer.getConnectorAddress(0);
        assert (addr.getPort() != 0);
        return addr;
    }

    URI getServerURI() {
        InetSocketAddress addr = this.httpServer.getConnectorAddress(0);
        return URI.create(DFSUtil.getHttpClientScheme(this.conf) + "://" + NetUtils.getHostPortString(addr));
    }

    private static InetSocketAddress getAddress(Configuration conf) {
        String addr = conf.get("dfs.journalnode.http-address", "0.0.0.0:8480");
        return NetUtils.createSocketAddr(addr, 8480, "dfs.journalnode.http-address");
    }

    public static Journal getJournalFromContext(ServletContext context, String jid) throws IOException {
        JournalNode jn = (JournalNode)context.getAttribute(JN_ATTRIBUTE_KEY);
        return jn.getOrCreateJournal(jid);
    }

    public static Configuration getConfFromContext(ServletContext context) {
        return (Configuration)context.getAttribute("current.conf");
    }
}

