/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.protocol.Block;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;

@InterfaceAudience.Private
public class DatanodeUtil {
    public static final String UNLINK_BLOCK_SUFFIX = ".unlinked";
    public static final String DISK_ERROR = "Possible disk error: ";
    private static final String SEP = System.getProperty("file.separator");

    static IOException getCauseIfDiskError(IOException ioe) {
        if (ioe.getMessage() != null && ioe.getMessage().startsWith(DISK_ERROR)) {
            return (IOException)ioe.getCause();
        }
        return null;
    }

    public static File createTmpFile(Block b, File f) throws IOException {
        boolean fileCreated;
        if (f.exists()) {
            throw new IOException("Failed to create temporary file for " + b + ".  File " + f + " should not be present, but is.");
        }
        try {
            fileCreated = f.createNewFile();
        }
        catch (IOException ioe) {
            throw new IOException("Possible disk error: Failed to create " + f, ioe);
        }
        if (!fileCreated) {
            throw new IOException("Failed to create temporary file for " + b + ".  File " + f + " should be creatable, but is already present.");
        }
        return f;
    }

    public static String getMetaName(String blockName, long generationStamp) {
        return blockName + "_" + generationStamp + ".meta";
    }

    public static File getUnlinkTmpFile(File f) {
        return new File(f.getParentFile(), f.getName() + UNLINK_BLOCK_SUFFIX);
    }

    public static boolean dirNoFilesRecursive(File dir) throws IOException {
        File[] contents = dir.listFiles();
        if (contents == null) {
            throw new IOException("Cannot list contents of " + dir);
        }
        for (File f : contents) {
            if (f.isDirectory() && (!f.isDirectory() || DatanodeUtil.dirNoFilesRecursive(f))) continue;
            return false;
        }
        return true;
    }

    public static File idToBlockDir(File root, long blockId) {
        int d1 = (int)(blockId >> 16 & 0x1FL);
        int d2 = (int)(blockId >> 8 & 0x1FL);
        String path = "subdir" + d1 + SEP + "subdir" + d2;
        return new File(root, path);
    }

    public static FileInputStream getMetaDataInputStream(ExtendedBlock b, FsDatasetSpi<?> data) throws IOException {
        LengthInputStream lin = data.getMetaDataInputStream(b);
        if (lin == null) {
            throw new FileNotFoundException("Meta file for " + b + " not found.");
        }
        return (FileInputStream)lin.getWrappedStream();
    }
}

