/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.tools;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import org.apache.flink.fs.openstackhadoop.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.ha.HAServiceTarget;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.ha.NodeFencer;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.DFSUtil;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.hdfs.tools.DFSZKFailoverController;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class NNHAServiceTarget
extends HAServiceTarget {
    private static final String NAMESERVICE_ID_KEY = "nameserviceid";
    private static final String NAMENODE_ID_KEY = "namenodeid";
    private final InetSocketAddress addr;
    private final InetSocketAddress lifelineAddr;
    private InetSocketAddress zkfcAddr;
    private NodeFencer fencer;
    private BadFencingConfigurationException fenceConfigError;
    private final String nnId;
    private final String nsId;
    private final boolean autoFailoverEnabled;

    public NNHAServiceTarget(Configuration conf, String nsId, String nnId) {
        int port;
        Preconditions.checkNotNull(nnId);
        if (nsId == null && (nsId = DFSUtil.getOnlyNameServiceIdOrNull(conf)) == null) {
            String errorString = "Unable to determine the name service ID.";
            Object[] dfsNames = conf.getStrings("dfs.nameservices");
            if (dfsNames != null && dfsNames.length > 1) {
                errorString = "Unable to determine the name service ID. This is an HA configuration with multiple name services configured. dfs.nameservices is set to " + Arrays.toString(dfsNames) + ". Please re-run with the -ns option.";
            }
            throw new IllegalArgumentException(errorString);
        }
        assert (nsId != null);
        HdfsConfiguration targetConf = new HdfsConfiguration(conf);
        NameNode.initializeGenericKeys(targetConf, nsId, nnId);
        String serviceAddr = DFSUtil.getNamenodeServiceAddr(targetConf, nsId, nnId);
        if (serviceAddr == null) {
            throw new IllegalArgumentException("Unable to determine service address for namenode '" + nnId + "'");
        }
        this.addr = NetUtils.createSocketAddr(serviceAddr, 8020);
        String lifelineAddrStr = DFSUtil.getNamenodeLifelineAddr(targetConf, nsId, nnId);
        this.lifelineAddr = lifelineAddrStr != null ? NetUtils.createSocketAddr(lifelineAddrStr) : null;
        this.autoFailoverEnabled = targetConf.getBoolean("dfs.ha.automatic-failover.enabled", false);
        if (this.autoFailoverEnabled && (port = DFSZKFailoverController.getZkfcPort(targetConf)) != 0) {
            this.setZkfcPort(port);
        }
        try {
            this.fencer = NodeFencer.create(targetConf, "dfs.ha.fencing.methods");
        }
        catch (BadFencingConfigurationException e) {
            this.fenceConfigError = e;
        }
        this.nnId = nnId;
        this.nsId = nsId;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.addr;
    }

    @Override
    public InetSocketAddress getHealthMonitorAddress() {
        return this.lifelineAddr;
    }

    @Override
    public InetSocketAddress getZKFCAddress() {
        Preconditions.checkState(this.autoFailoverEnabled, "ZKFC address not relevant when auto failover is off");
        assert (this.zkfcAddr != null);
        return this.zkfcAddr;
    }

    void setZkfcPort(int port) {
        assert (this.autoFailoverEnabled);
        this.zkfcAddr = new InetSocketAddress(this.addr.getAddress(), port);
    }

    @Override
    public void checkFencingConfigured() throws BadFencingConfigurationException {
        if (this.fenceConfigError != null) {
            throw this.fenceConfigError;
        }
        if (this.fencer == null) {
            throw new BadFencingConfigurationException("No fencer configured for " + this);
        }
    }

    @Override
    public NodeFencer getFencer() {
        return this.fencer;
    }

    public String toString() {
        return "NameNode at " + (this.lifelineAddr != null ? this.lifelineAddr : this.addr);
    }

    public String getNameServiceId() {
        return this.nsId;
    }

    public String getNameNodeId() {
        return this.nnId;
    }

    @Override
    protected void addFencingParameters(Map<String, String> ret) {
        super.addFencingParameters(ret);
        ret.put(NAMESERVICE_ID_KEY, this.getNameServiceId());
        ret.put(NAMENODE_ID_KEY, this.getNameNodeId());
    }

    @Override
    public boolean isAutoFailoverEnabled() {
        return this.autoFailoverEnabled;
    }
}

