/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.concurrent;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.openstackhadoop.shaded.org.apache.hadoop.util.concurrent.ExecutorHelper;

public class HadoopScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Log LOG = LogFactory.getLog(HadoopScheduledThreadPoolExecutor.class);

    public HadoopScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public HadoopScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public HadoopScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public HadoopScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("beforeExecute in thread: " + Thread.currentThread().getName() + ", runnable type: " + r.getClass().getName());
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        ExecutorHelper.logThrowableFromAfterExecute(r, t);
    }
}

