/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.testutils;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.internal.AssumptionViolatedException;

public class CommonTestUtils {
    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T createCopySerializable(T original) throws IOException {
        if (original == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(original);
        oos.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            Serializable copy;
            Serializable serializable = copy = (Serializable)ois.readObject();
            return (T)serializable;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static String createTempFile(String contents) throws IOException {
        File f = File.createTempFile("flink_test_", ".tmp");
        f.deleteOnExit();
        try (BufferedWriter out = new BufferedWriter(new FileWriter(f));){
            out.write(contents);
        }
        return f.toURI().toString();
    }

    public static void assumeJava8() {
        try {
            String javaVersionString = System.getProperty("java.runtime.version").substring(0, 3);
            float javaVersion = Float.parseFloat(javaVersionString);
            Assume.assumeTrue((javaVersion >= 1.8f ? 1 : 0) != 0);
        }
        catch (AssumptionViolatedException e) {
            System.out.println("Skipping CassandraConnectorITCase, because the JDK is < Java 8+");
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Cannot determine Java version: " + e.getMessage()));
        }
    }

    public static void setEnv(Map<String, String> newenv) {
        CommonTestUtils.setEnv(newenv, true);
    }

    public static void setEnv(Map<String, String> newenv, boolean clearExisting) {
        try {
            Map<String, String> env = System.getenv();
            Class<?> clazz = env.getClass();
            Field field = clazz.getDeclaredField("m");
            field.setAccessible(true);
            Map map = (Map)field.get(env);
            if (clearExisting) {
                map.clear();
            }
            map.putAll(newenv);
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            try {
                Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
                theCaseInsensitiveEnvironmentField.setAccessible(true);
                Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
                if (clearExisting) {
                    cienv.clear();
                }
                cienv.putAll(newenv);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }
}

