/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.AggregateDataSet;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.PartitionITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001=\u0011q\u0002U1si&$\u0018n\u001c8J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001c9fe\u0006$xN]:\u000b\u0005\u00151\u0011!B:dC2\f'BA\u0004\t\u0003\r\t\u0007/\u001b\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003vi&d'BA\u000b\t\u0003\u0011!Xm\u001d;\n\u0005]\u0011\"\u0001G'vYRL\u0007\u000f\\3Qe><'/Y7t)\u0016\u001cHOQ1tK\"A\u0011\u0004\u0001B\u0001B\u0003%!$\u0001\u0003n_\u0012,\u0007CA\u000e,\u001d\ta\u0012F\u0004\u0002\u001eQ9\u0011ad\n\b\u0003?\u0019r!\u0001I\u0013\u000f\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rr\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011Q\u0003C\u0005\u0003'QI!A\u000b\n\u000215+H\u000e^5qY\u0016\u0004&o\\4sC6\u001cH+Z:u\u0005\u0006\u001cX-\u0003\u0002-[\t\tB+Z:u\u000bb,7-\u001e;j_:lu\u000eZ3\u000b\u0005)\u0012\u0002\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\b\u0006\u00022gA\u0011!\u0007A\u0007\u0002\u0005!)\u0011D\fa\u00015!9Q\u0007\u0001a\u0001\n\u00131\u0014A\u0003:fgVdG\u000fU1uQV\tq\u0007\u0005\u00029{9\u0011\u0011h\u000f\t\u0003CiR\u0011!B\u0005\u0003yi\na\u0001\u0015:fI\u00164\u0017B\u0001 @\u0005\u0019\u0019FO]5oO*\u0011AH\u000f\u0005\b\u0003\u0002\u0001\r\u0011\"\u0003C\u00039\u0011Xm];miB\u000bG\u000f[0%KF$\"aQ$\u0011\u0005\u0011+U\"\u0001\u001e\n\u0005\u0019S$\u0001B+oSRDq\u0001\u0013!\u0002\u0002\u0003\u0007q'A\u0002yIEBaA\u0013\u0001!B\u00139\u0014a\u0003:fgVdG\u000fU1uQ\u0002Bq\u0001\u0014\u0001A\u0002\u0013%a'\u0001\u0005fqB,7\r^3e\u0011\u001dq\u0005\u00011A\u0005\n=\u000bA\"\u001a=qK\u000e$X\rZ0%KF$\"a\u0011)\t\u000f!k\u0015\u0011!a\u0001o!1!\u000b\u0001Q!\n]\n\u0011\"\u001a=qK\u000e$X\r\u001a\u0011\t\u000fQ\u0003!\u0019!C\u0005+\u0006Yq\f^3na\u001a{G\u000eZ3s+\u00051\u0006CA,]\u001b\u0005A&BA-[\u0003\u0015\u0011X\u000f\\3t\u0015\tYF\"A\u0003kk:LG/\u0003\u0002^1\nyA+Z7q_J\f'/\u001f$pY\u0012,'\u000f\u0003\u0004`\u0001\u0001\u0006IAV\u0001\r?R,W\u000e\u001d$pY\u0012,'\u000f\t\u0005\u0006C\u0002!\t!V\u0001\u000bi\u0016l\u0007OR8mI\u0016\u0014\bF\u00011d!\t!W-D\u0001[\u0013\t1'L\u0001\u0003Sk2,\u0007\"\u00025\u0001\t\u0003I\u0017A\u00022fM>\u0014X\rF\u0001DQ\t97\u000e\u0005\u0002eY&\u0011QN\u0017\u0002\u0007\u0005\u00164wN]3\t\u000b=\u0004A\u0011A5\u0002\u000b\u00054G/\u001a:)\u00059\f\bC\u00013s\u0013\t\u0019(LA\u0003BMR,'\u000fC\u0003v\u0001\u0011\u0005\u0011.\u0001\fuKN$X)\u001c9us\"\u000b7\u000f\u001b)beRLG/[8oQ\t!x\u000f\u0005\u0002eq&\u0011\u0011P\u0017\u0002\u0005)\u0016\u001cH\u000fC\u0003|\u0001\u0011\u0005\u0011.A\fuKN$X)\u001c9usJ\u000bgnZ3QCJ$\u0018\u000e^5p]\"\u0012!p\u001e\u0005\u0006}\u0002!\t![\u0001\u001ei\u0016\u001cH\u000fS1tQB\u000b'\u000f^5uS>t')\u001f+va2,g)[3mI\"\u0012Qp\u001e\u0005\u0007\u0003\u0007\u0001A\u0011A5\u0002=Q,7\u000f\u001e*b]\u001e,\u0007+\u0019:uSRLwN\u001c\"z)V\u0004H.\u001a$jK2$\u0007fAA\u0001o\"1\u0011\u0011\u0002\u0001\u0005\u0002%\fa\u0004^3ti\"\u000b7\u000f\u001b)beRLG/[8o\u0005f\\U-_*fY\u0016\u001cGo\u001c:)\u0007\u0005\u001dq\u000f\u0003\u0004\u0002\u0010\u0001!\t![\u0001 i\u0016\u001cHOU1oO\u0016\u0004\u0016M\u001d;ji&|gNQ=LKf\u001cV\r\\3di>\u0014\bfAA\u0007o\"1\u0011Q\u0003\u0001\u0005\u0002%\fQ\u0003^3ti\u001a{'oY3e%\u0016\u0014\u0017\r\\1oG&tw\rK\u0002\u0002\u0014]Da!a\u0007\u0001\t\u0003I\u0017!\u000e;fgRl\u0015\r\u001d)beRLG/[8o\u0003\u001a$XM\u001d*fa\u0006\u0014H/\u001b;j_:D\u0015m]\"peJ,7\r\u001e)be\u0006dG.\u001a7jg6D3!!\u0007x\u0011\u0019\t\t\u0003\u0001C\u0001S\u00061D/Z:u\u001b\u0006\u0004\b+\u0019:uSRLwN\\!gi\u0016\u0014(+\u001a9beRLG/[8o\u0011\u0006\u001c8i\u001c:sK\u000e$\b+\u0019:bY2,G.[:ne!\u001a\u0011qD<\t\r\u0005\u001d\u0002\u0001\"\u0001j\u00031\"Xm\u001d;NCB\fe\r^3s%\u0016\u0004\u0018M\u001d;ji&|g\u000eS1t\u0007>\u0014(/Z2u!\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000eK\u0002\u0002&]Da!!\f\u0001\t\u0003I\u0017!\f;fgRl\u0015\r]!gi\u0016\u0014(+\u001a9beRLG/[8o\u0011\u0006\u001c8i\u001c:sK\u000e$\b+\u0019:bY2,G.[:ne!\u001a\u00111F<\t\r\u0005M\u0002\u0001\"\u0001j\u0003=\"Xm\u001d;GS2$XM]!gi\u0016\u0014(+\u001a9beRLG/[8o\u0011\u0006\u001c8i\u001c:sK\u000e$\b+\u0019:bY2,G.[:nQ\r\t\td\u001e\u0005\u0007\u0003s\u0001A\u0011A5\u0002aQ,7\u000f\u001e$jYR,'/\u00114uKJ\u0014V\r]1si&$\u0018n\u001c8ICN\u001cuN\u001d:fGR\u0004\u0016M]1mY\u0016d\u0017n]73Q\r\t9d\u001e\u0005\u0007\u0003\u007f\u0001A\u0011A5\u00027Q,7\u000f\u001e%bg\"\u0004\u0016M\u001d;ji&|gNT3ti\u0016$\u0007k\u001c6pQ\r\tid\u001e\u0005\u0007\u0003\u000b\u0002A\u0011A5\u00029Q,7\u000f\u001e*b]\u001e,\u0007+\u0019:uSRLwN\u001c(fgR,G\rU8k_\"\u001a\u00111I<)\u000f\u0001\tY%a\u0016\u0002ZA!\u0011QJA*\u001b\t\tyEC\u0002\u0002Ri\u000baA];o]\u0016\u0014\u0018\u0002BA+\u0003\u001f\u0012qAU;o/&$\b.A\u0003wC2,Xm\t\u0002\u0002\\A!\u0011QLA2\u001b\t\tyFC\u0002\u0002bi\u000bqA];o]\u0016\u00148/\u0003\u0003\u0002f\u0005}#!\u0004)be\u0006lW\r^3sSj,G\r")
public class PartitionITCase
extends MultipleProgramsTestBase {
    private final MultipleProgramsTestBase.TestExecutionMode mode;
    private String resultPath;
    private String expected;
    private final TemporaryFolder _tempFolder;

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testEmptyHashPartition() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = env.fromCollection((Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), ClassTag$.MODULE$.apply(Tuple1.class), (TypeInformation)new CaseClassTypeInfo<Tuple1<String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple1<String>> unused = new ScalaCaseClassSerializer<Tuple1<String>>(this, fieldSerializers){

                    public Tuple1<String> createInstance(Object[] fields) {
                        return new Tuple1((Object)((String)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.operators.PartitionITCase$$anon$14 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataSet unique = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("");
    }

    @Test
    public void testEmptyRangePartition() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = env.fromCollection((Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), ClassTag$.MODULE$.apply(Tuple1.class), (TypeInformation)new CaseClassTypeInfo<Tuple1<String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple1<String>> unused = new ScalaCaseClassSerializer<Tuple1<String>>(this, fieldSerializers){

                    public Tuple1<String> createInstance(Object[] fields) {
                        return new Tuple1((Object)((String)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.operators.PartitionITCase$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        DataSet unique = ds.partitionByRange((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("");
    }

    @Test
    public void testHashPartitionByTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet unique = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).mapPartition((Function1 & Serializable & scala.Serializable)x$1 -> x$1.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testHashPartitionByTupleField$2(x$2))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testRangePartitionByTupleField() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet unique = ds.partitionByRange((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).mapPartition((Function1 & Serializable & scala.Serializable)x$3 -> x$3.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testRangePartitionByTupleField$2(x$4))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testHashPartitionByKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet unique = ds.partitionByHash((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testHashPartitionByKeySelector$1(x$5)), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).mapPartition((Function1 & Serializable & scala.Serializable)x$6 -> x$6.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testHashPartitionByKeySelector$3(x$7))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testRangePartitionByKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet unique = ds.partitionByRange((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testRangePartitionByKeySelector$1(x$8)), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).mapPartition((Function1 & Serializable & scala.Serializable)x$9 -> x$9.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testRangePartitionByKeySelector$3(x$10))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testForcedRebalancing() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = env.generateSequence(1L, 3000L);
        DataSet skewed = ds.filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 > 780L);
        DataSet rebalanced = skewed.rebalance();
        DataSet countsInPartition = rebalanced.map((MapFunction)new RichMapFunction<Object, Tuple2<Object, Object>>(null){

            public Tuple2<Object, Object> map(long in) {
                return new Tuple2.mcIJ.sp(this.getRuntimeContext().getIndexOfThisSubtask(), 1L);
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.api.scala.operators.PartitionITCase$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).reduce((Function2 & Serializable & scala.Serializable)(v1, v2) -> new Tuple2.mcIJ.sp(v1._1$mcI$sp(), v1._2$mcJ$sp() + v2._2$mcJ$sp())).map((Function1 & Serializable & scala.Serializable)in -> new Tuple2.mcIJ.sp(in._1$mcI$sp(), in._2$mcJ$sp() / 10L), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$17 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.api.scala.operators.PartitionITCase$$anon$17 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        countsInPartition.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        int numPerPartition = 2220 / env.getParallelism() / 10;
        this.expected_$eq("");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), env.getParallelism()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.expected_$eq(new StringBuilder(0).append(this.expected()).append(new StringBuilder(4).append("(").append(i).append(",").append(numPerPartition).append(")\n").toString()).toString()));
    }

    @Test
    public void testMapPartitionAfterRepartitionHasCorrectParallelism() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        DataSet unique = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).setParallelism(4).mapPartition((Function1 & Serializable & scala.Serializable)x$12 -> x$12.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testMapPartitionAfterRepartitionHasCorrectParallelism$2(x$13))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testMapPartitionAfterRepartitionHasCorrectParallelism2() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        DataSet unique = ds.partitionByRange((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).setParallelism(4).mapPartition((Function1 & Serializable & scala.Serializable)x$14 -> x$14.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testMapPartitionAfterRepartitionHasCorrectParallelism2$2(x$15))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        unique.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1\n2\n3\n4\n5\n6\n");
    }

    @Test
    public void testMapAfterRepartitionHasCorrectParallelism() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        AggregateDataSet count = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).setParallelism(4).map((MapFunction)new RichMapFunction<Tuple3<Object, Object, String>, Tuple1<Object>>(null){
            private boolean first;

            public boolean first() {
                return this.first;
            }

            public void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public Tuple1<Object> map(Tuple3<Object, Object, String> in) {
                Tuple1.mcI.sp sp2;
                if (this.first()) {
                    this.first_$eq(false);
                    sp2 = new Tuple1.mcI.sp(1);
                } else {
                    sp2 = new Tuple1.mcI.sp(0);
                }
                return sp2;
            }
            {
                this.first = true;
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$18 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$5[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$5(org.apache.flink.api.scala.operators.PartitionITCase$$anon$18 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class)).sum(0);
        count.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode = this.mode;
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode2 = MultipleProgramsTestBase.TestExecutionMode.COLLECTION;
        this.expected_$eq(!(testExecutionMode != null ? !testExecutionMode.equals(testExecutionMode2) : testExecutionMode2 != null) ? "(1)\n" : "(4)\n");
    }

    @Test
    public void testMapAfterRepartitionHasCorrectParallelism2() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        AggregateDataSet count = ds.partitionByRange((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).setParallelism(4).map((MapFunction)new RichMapFunction<Tuple3<Object, Object, String>, Tuple1<Object>>(null){
            private boolean first;

            public boolean first() {
                return this.first;
            }

            public void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public Tuple1<Object> map(Tuple3<Object, Object, String> in) {
                Tuple1.mcI.sp sp2;
                if (this.first()) {
                    this.first_$eq(false);
                    sp2 = new Tuple1.mcI.sp(1);
                } else {
                    sp2 = new Tuple1.mcI.sp(0);
                }
                return sp2;
            }
            {
                this.first = true;
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$19 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.api.scala.operators.PartitionITCase$$anon$19 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class)).sum(0);
        count.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode = this.mode;
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode2 = MultipleProgramsTestBase.TestExecutionMode.COLLECTION;
        this.expected_$eq(!(testExecutionMode != null ? !testExecutionMode.equals(testExecutionMode2) : testExecutionMode2 != null) ? "(1)\n" : "(4)\n");
    }

    @Test
    public void testFilterAfterRepartitionHasCorrectParallelism() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        AggregateDataSet count = ds.partitionByHash((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).setParallelism(4).filter((FilterFunction)new RichFilterFunction<Tuple3<Object, Object, String>>(null){
            private boolean first;

            public boolean first() {
                return this.first;
            }

            public void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public boolean filter(Tuple3<Object, Object, String> in) {
                boolean bl;
                if (this.first()) {
                    this.first_$eq(false);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.first = true;
            }
        }).map((Function1 & Serializable & scala.Serializable)x$16 -> new Tuple1.mcI.sp(1), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$20 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.api.scala.operators.PartitionITCase$$anon$20 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class)).sum(0);
        count.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode = this.mode;
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode2 = MultipleProgramsTestBase.TestExecutionMode.COLLECTION;
        this.expected_$eq(!(testExecutionMode != null ? !testExecutionMode.equals(testExecutionMode2) : testExecutionMode2 != null) ? "(1)\n" : "(4)\n");
    }

    @Test
    public void testFilterAfterRepartitionHasCorrectParallelism2() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        env.setParallelism(1);
        AggregateDataSet count = ds.partitionByRange((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).setParallelism(4).filter((FilterFunction)new RichFilterFunction<Tuple3<Object, Object, String>>(null){
            private boolean first;

            public boolean first() {
                return this.first;
            }

            public void first_$eq(boolean x$1) {
                this.first = x$1;
            }

            public boolean filter(Tuple3<Object, Object, String> in) {
                boolean bl;
                if (this.first()) {
                    this.first_$eq(false);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.first = true;
            }
        }).map((Function1 & Serializable & scala.Serializable)x$17 -> new Tuple1.mcI.sp(1), (TypeInformation)new CaseClassTypeInfo<Tuple1<Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$21 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple1<Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple1<Object>> unused = new ScalaCaseClassSerializer<Tuple1<Object>>(this, fieldSerializers){

                    public Tuple1<Object> createInstance(Object[] fields) {
                        return new Tuple1.mcI.sp(BoxesRunTime.unboxToInt((Object)fields[0]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.api.scala.operators.PartitionITCase$$anon$21 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(Tuple1.class)).sum(0);
        count.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode = this.mode;
        MultipleProgramsTestBase.TestExecutionMode testExecutionMode2 = MultipleProgramsTestBase.TestExecutionMode.COLLECTION;
        this.expected_$eq(!(testExecutionMode != null ? !testExecutionMode.equals(testExecutionMode2) : testExecutionMode2 != null) ? "(1)\n" : "(4)\n");
    }

    @Test
    public void testHashPartitionNestedPojo() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(3);
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets$.MODULE$.getDuplicatePojoDataSet(env);
        DataSet uniqLongs = ds.partitionByHash("nestedPojo.longNumber", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).setParallelism(4).mapPartition((Function1 & Serializable & scala.Serializable)x$18 -> x$18.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testHashPartitionNestedPojo$2(x$19))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        uniqLongs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("10000\n20000\n30000\n");
    }

    @Test
    public void testRangePartitionNestedPojo() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setParallelism(3);
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets$.MODULE$.getDuplicatePojoDataSet(env);
        DataSet uniqLongs = ds.partitionByRange("nestedPojo.longNumber", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).setParallelism(4).mapPartition((Function1 & Serializable & scala.Serializable)x$20 -> x$20.map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)PartitionITCase.$anonfun$testRangePartitionNestedPojo$2(x$21))).toSet(), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long());
        uniqLongs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("10000\n20000\n30000\n");
    }

    public static final /* synthetic */ long $anonfun$testHashPartitionByTupleField$2(Tuple3 x$2) {
        return BoxesRunTime.unboxToLong((Object)x$2._2());
    }

    public static final /* synthetic */ long $anonfun$testRangePartitionByTupleField$2(Tuple3 x$4) {
        return BoxesRunTime.unboxToLong((Object)x$4._2());
    }

    public static final /* synthetic */ long $anonfun$testHashPartitionByKeySelector$1(Tuple3 x$5) {
        return BoxesRunTime.unboxToLong((Object)x$5._2());
    }

    public static final /* synthetic */ long $anonfun$testHashPartitionByKeySelector$3(Tuple3 x$7) {
        return BoxesRunTime.unboxToLong((Object)x$7._2());
    }

    public static final /* synthetic */ long $anonfun$testRangePartitionByKeySelector$1(Tuple3 x$8) {
        return BoxesRunTime.unboxToLong((Object)x$8._2());
    }

    public static final /* synthetic */ long $anonfun$testRangePartitionByKeySelector$3(Tuple3 x$10) {
        return BoxesRunTime.unboxToLong((Object)x$10._2());
    }

    public static final /* synthetic */ long $anonfun$testMapPartitionAfterRepartitionHasCorrectParallelism$2(Tuple3 x$13) {
        return BoxesRunTime.unboxToLong((Object)x$13._2());
    }

    public static final /* synthetic */ long $anonfun$testMapPartitionAfterRepartitionHasCorrectParallelism2$2(Tuple3 x$15) {
        return BoxesRunTime.unboxToLong((Object)x$15._2());
    }

    public static final /* synthetic */ long $anonfun$testHashPartitionNestedPojo$2(CollectionDataSets.POJO x$19) {
        return x$19.nestedPojo().longNumber();
    }

    public static final /* synthetic */ long $anonfun$testRangePartitionNestedPojo$2(CollectionDataSets.POJO x$21) {
        return x$21.nestedPojo().longNumber();
    }

    public PartitionITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        this.mode = mode;
        super(mode);
        this.resultPath = null;
        this.expected = null;
        this._tempFolder = new TemporaryFolder();
    }
}

