/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing;

import java.util.ArrayList;
import java.util.PriorityQueue;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.source.TimestampedFileInputSplit;
import org.junit.Assert;
import org.junit.Test;

public class TimestampedFileInputSplitTest {
    @Test
    public void testSplitEquality() {
        TimestampedFileInputSplit richFirstSplit = new TimestampedFileInputSplit(10L, 2, new Path("test"), 0L, 100L, null);
        TimestampedFileInputSplit richSecondSplit = new TimestampedFileInputSplit(10L, 2, new Path("test"), 0L, 100L, null);
        Assert.assertEquals((Object)richFirstSplit, (Object)richSecondSplit);
        TimestampedFileInputSplit richModSecondSplit = new TimestampedFileInputSplit(11L, 2, new Path("test"), 0L, 100L, null);
        Assert.assertNotEquals((Object)richSecondSplit, (Object)richModSecondSplit);
        TimestampedFileInputSplit richThirdSplit = new TimestampedFileInputSplit(10L, 2, new Path("test/test1"), 0L, 100L, null);
        Assert.assertEquals((long)richThirdSplit.getModificationTime(), (long)10L);
        Assert.assertNotEquals((Object)richFirstSplit, (Object)richThirdSplit);
        TimestampedFileInputSplit richThirdSplitCopy = new TimestampedFileInputSplit(10L, 2, new Path("test/test1"), 0L, 100L, null);
        Assert.assertEquals((Object)richThirdSplitCopy, (Object)richThirdSplit);
    }

    @Test
    public void testSplitComparison() {
        TimestampedFileInputSplit richFirstSplit = new TimestampedFileInputSplit(0L, 3, new Path("test/test1"), 0L, 100L, null);
        TimestampedFileInputSplit richSecondSplit = new TimestampedFileInputSplit(10L, 2, new Path("test/test2"), 0L, 100L, null);
        TimestampedFileInputSplit richThirdSplit = new TimestampedFileInputSplit(10L, 1, new Path("test/test2"), 0L, 100L, null);
        TimestampedFileInputSplit richForthSplit = new TimestampedFileInputSplit(11L, 0, new Path("test/test3"), 0L, 100L, null);
        TimestampedFileInputSplit richFifthSplit = new TimestampedFileInputSplit(11L, 1, new Path("test/test3"), 0L, 100L, null);
        Assert.assertTrue((richFirstSplit.compareTo(richSecondSplit) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((richThirdSplit.compareTo(richFifthSplit) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((richThirdSplit.compareTo(richSecondSplit) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((richThirdSplit.compareTo(richForthSplit) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIllegalArgument() {
        block2: {
            try {
                new TimestampedFileInputSplit(-10L, 2, new Path("test"), 0L, 100L, null);
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) break block2;
                Assert.fail((String)e.getMessage());
            }
        }
    }

    @Test
    public void testPriorityQ() {
        TimestampedFileInputSplit richFirstSplit = new TimestampedFileInputSplit(0L, 3, new Path("test/test1"), 0L, 100L, null);
        TimestampedFileInputSplit richSecondSplit = new TimestampedFileInputSplit(10L, 2, new Path("test/test2"), 0L, 100L, null);
        TimestampedFileInputSplit richThirdSplit = new TimestampedFileInputSplit(10L, 1, new Path("test/test2"), 0L, 100L, null);
        TimestampedFileInputSplit richForthSplit = new TimestampedFileInputSplit(11L, 0, new Path("test/test3"), 0L, 100L, null);
        TimestampedFileInputSplit richFifthSplit = new TimestampedFileInputSplit(11L, 1, new Path("test/test3"), 0L, 100L, null);
        PriorityQueue<TimestampedFileInputSplit> pendingSplits = new PriorityQueue<TimestampedFileInputSplit>();
        pendingSplits.add(richSecondSplit);
        pendingSplits.add(richForthSplit);
        pendingSplits.add(richFirstSplit);
        pendingSplits.add(richFifthSplit);
        pendingSplits.add(richFifthSplit);
        pendingSplits.add(richThirdSplit);
        ArrayList actualSortedSplits = new ArrayList();
        do {
            actualSortedSplits.add(pendingSplits.poll());
        } while (!pendingSplits.isEmpty());
        ArrayList<TimestampedFileInputSplit> expectedSortedSplits = new ArrayList<TimestampedFileInputSplit>();
        expectedSortedSplits.add(richFirstSplit);
        expectedSortedSplits.add(richThirdSplit);
        expectedSortedSplits.add(richSecondSplit);
        expectedSortedSplits.add(richForthSplit);
        expectedSortedSplits.add(richFifthSplit);
        expectedSortedSplits.add(richFifthSplit);
        Assert.assertArrayEquals((Object[])expectedSortedSplits.toArray(), (Object[])actualSortedSplits.toArray());
    }
}

