/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.checkpoint.ListCheckpointed;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.test.util.SuccessException;
import org.junit.Assert;

public class ValidatingSink<T>
extends RichSinkFunction<T>
implements ListCheckpointed<HashMap<Long, Integer>> {
    @Nonnull
    private final ResultChecker resultChecker;
    @Nonnull
    private final CountUpdater<T> countUpdater;
    @Nonnull
    private final HashMap<Long, Integer> windowCounts;
    private final boolean usingProcessingTime;

    public ValidatingSink(@Nonnull CountUpdater<T> countUpdater, @Nonnull ResultChecker resultChecker) {
        this(countUpdater, resultChecker, TimeCharacteristic.EventTime);
    }

    public ValidatingSink(@Nonnull CountUpdater<T> countUpdater, @Nonnull ResultChecker resultChecker, @Nonnull TimeCharacteristic timeCharacteristic) {
        this.resultChecker = resultChecker;
        this.countUpdater = countUpdater;
        this.usingProcessingTime = TimeCharacteristic.ProcessingTime == timeCharacteristic;
        this.windowCounts = new HashMap();
    }

    public void open(Configuration parameters) throws Exception {
        Assert.assertEquals((long)1L, (long)this.getRuntimeContext().getNumberOfParallelSubtasks());
        if (this.usingProcessingTime && this.resultChecker.checkResult(this.windowCounts)) {
            throw new SuccessException();
        }
    }

    public void close() {
        if (this.resultChecker.checkResult(this.windowCounts)) {
            if (this.usingProcessingTime) {
                throw new SuccessException();
            }
        } else {
            throw new AssertionError((Object)"Test failed check.");
        }
    }

    public void invoke(T value, SinkFunction.Context context) throws Exception {
        this.countUpdater.updateCount(value, this.windowCounts);
        if (this.usingProcessingTime && this.resultChecker.checkResult(this.windowCounts)) {
            throw new SuccessException();
        }
    }

    public List<HashMap<Long, Integer>> snapshotState(long checkpointId, long timestamp) throws Exception {
        return Collections.singletonList(this.windowCounts);
    }

    public void restoreState(List<HashMap<Long, Integer>> state) throws Exception {
        if (state.isEmpty() || state.size() > 1) {
            throw new RuntimeException("Test failed due to unexpected recovered state size " + state.size());
        }
        this.windowCounts.putAll((Map<Long, Integer>)state.get(0));
    }

    public static interface CountUpdater<T>
    extends Serializable {
        public void updateCount(T var1, Map<Long, Integer> var2);
    }

    @FunctionalInterface
    public static interface ResultChecker
    extends Serializable {
        public boolean checkResult(Map<Long, Integer> var1);
    }
}

