/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.manual;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.types.parser.FieldParserTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MemberUsageScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class CheckForbiddenMethodsUsage {
    private static final List<ForbiddenCall> forbiddenCalls = new ArrayList<ForbiddenCall>();

    @BeforeClass
    public static void init() throws Exception {
        forbiddenCalls.add(ForbiddenCall.of(String.class.getMethod("getBytes", new Class[0]), Arrays.asList(FieldParserTest.class.getMethod("testEndsWithDelimiter", new Class[0]), FieldParserTest.class.getMethod("testDelimiterNext", new Class[0]))));
        forbiddenCalls.add(ForbiddenCall.of(String.class.getConstructor(byte[].class)));
        forbiddenCalls.add(ForbiddenCall.of(String.class.getConstructor(byte[].class, Integer.TYPE)));
        forbiddenCalls.add(ForbiddenCall.of(String.class.getConstructor(byte[].class, Integer.TYPE, Integer.TYPE)));
        forbiddenCalls.add(ForbiddenCall.of(String.class.getConstructor(byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE)));
    }

    @Test
    public void testNoDefaultEncoding() throws Exception {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().useParallelExecutor(Runtime.getRuntime().availableProcessors()).addUrls(ClasspathHelper.forPackage((String)"org.apache.flink", (ClassLoader[])new ClassLoader[0])).addScanners(new Scanner[]{new MemberUsageScanner()}));
        for (ForbiddenCall forbiddenCall : forbiddenCalls) {
            Set<Member> methodUsages = forbiddenCall.getUsages(reflections);
            methodUsages.removeAll(forbiddenCall.getExclusions());
            Assert.assertEquals((String)("Unexpected calls: " + methodUsages), (long)0L, (long)methodUsages.size());
        }
    }

    private static class ForbiddenCall {
        private final Method method;
        private final Constructor<?> constructor;
        private final List<Member> exclusions;

        private ForbiddenCall(Method method, Constructor<?> ctor, List<Member> exclusions) {
            this.method = method;
            this.exclusions = exclusions;
            this.constructor = ctor;
        }

        public Method getMethod() {
            return this.method;
        }

        public List<Member> getExclusions() {
            return this.exclusions;
        }

        public Set<Member> getUsages(Reflections reflections) {
            if (this.method == null) {
                return reflections.getConstructorUsage(this.constructor);
            }
            return reflections.getMethodUsage(this.method);
        }

        public static ForbiddenCall of(Method method) {
            return new ForbiddenCall(method, null, Collections.emptyList());
        }

        public static ForbiddenCall of(Method method, List<Member> exclusions) {
            return new ForbiddenCall(method, null, exclusions);
        }

        public static ForbiddenCall of(Constructor<?> ctor) {
            return new ForbiddenCall(null, ctor, Collections.emptyList());
        }

        public static ForbiddenCall of(Constructor<?> ctor, List<Member> exclusions) {
            return new ForbiddenCall(null, ctor, exclusions);
        }
    }
}

