/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.manual;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.CopyableValueComparator;
import org.apache.flink.api.java.typeutils.runtime.CopyableValueSerializer;
import org.apache.flink.api.java.typeutils.runtime.RuntimeSerializerFactory;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.sort.UnilateralSortMerger;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;

public class MassiveStringValueSorting {
    private static final long SEED = 347569784659278346L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringValueSorting() {
        File input = null;
        File sorted = null;
        try {
            input = this.generateFileWithStrings(300000, "http://some-uri.com/that/is/a/common/prefix/to/all");
            sorted = File.createTempFile("sorted_strings", "txt");
            String[] command = new String[]{"/bin/bash", "-c", "export LC_ALL=\"C\" && cat \"" + input.getAbsolutePath() + "\" | sort > \"" + sorted.getAbsolutePath() + "\""};
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(command);
                int retCode = p.waitFor();
                if (retCode != 0) {
                    throw new Exception("Command failed with return code " + retCode);
                }
                p = null;
            }
            finally {
                if (p != null) {
                    p.destroy();
                }
            }
            UnilateralSortMerger sorter = null;
            BufferedReader reader = null;
            BufferedReader verifyReader = null;
            MemoryManager mm = null;
            try (IOManagerAsync ioMan = new IOManagerAsync();){
                String nextVerify;
                mm = new MemoryManager(0x100000L, 1);
                CopyableValueSerializer serializer = new CopyableValueSerializer(StringValue.class);
                CopyableValueComparator comparator = new CopyableValueComparator(true, StringValue.class);
                reader = new BufferedReader(new FileReader(input));
                StringValueReaderMutableObjectIterator inputIterator = new StringValueReaderMutableObjectIterator(reader);
                sorter = new UnilateralSortMerger(mm, (IOManager)ioMan, (MutableObjectIterator)inputIterator, (AbstractInvokable)new DummyInvokable(), (TypeSerializerFactory)new RuntimeSerializerFactory((TypeSerializer)serializer, StringValue.class), (TypeComparator)comparator, 1.0, 4, 0.8f, true, true);
                MutableObjectIterator sortedData = sorter.getIterator();
                reader.close();
                verifyReader = new BufferedReader(new FileReader(sorted));
                StringValue nextFromFlinkSort = new StringValue();
                while ((nextVerify = verifyReader.readLine()) != null) {
                    nextFromFlinkSort = (StringValue)sortedData.next((Object)nextFromFlinkSort);
                    Assert.assertNotNull((Object)nextFromFlinkSort);
                    Assert.assertEquals((Object)nextVerify, (Object)nextFromFlinkSort.getValue());
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (verifyReader != null) {
                    verifyReader.close();
                }
                if (sorter != null) {
                    sorter.close();
                }
                if (mm != null) {
                    mm.shutdown();
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (input != null) {
                input.delete();
            }
            if (sorted != null) {
                sorted.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringValueTuplesSorting() {
        int numStrings = 300000;
        File input = null;
        File sorted = null;
        try {
            input = this.generateFileWithStringTuples(300000, "http://some-uri.com/that/is/a/common/prefix/to/all");
            sorted = File.createTempFile("sorted_strings", "txt");
            String[] command = new String[]{"/bin/bash", "-c", "export LC_ALL=\"C\" && cat \"" + input.getAbsolutePath() + "\" | sort > \"" + sorted.getAbsolutePath() + "\""};
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(command);
                int retCode = p.waitFor();
                if (retCode != 0) {
                    throw new Exception("Command failed with return code " + retCode);
                }
                p = null;
            }
            finally {
                if (p != null) {
                    p.destroy();
                }
            }
            UnilateralSortMerger sorter = null;
            BufferedReader reader = null;
            BufferedReader verifyReader = null;
            MemoryManager mm = null;
            try (IOManagerAsync ioMan = new IOManagerAsync();){
                mm = new MemoryManager(0x100000L, 1);
                TupleTypeInfo typeInfo = (TupleTypeInfo)new TypeHint<Tuple2<StringValue, StringValue[]>>(){}.getTypeInfo();
                TupleSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
                TypeComparator comparator = typeInfo.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
                reader = new BufferedReader(new FileReader(input));
                StringValueTupleReaderMutableObjectIterator inputIterator = new StringValueTupleReaderMutableObjectIterator(reader);
                sorter = new UnilateralSortMerger(mm, (IOManager)ioMan, (MutableObjectIterator)inputIterator, (AbstractInvokable)new DummyInvokable(), (TypeSerializerFactory)new RuntimeSerializerFactory((TypeSerializer)serializer, Tuple2.class), comparator, 1.0, 4, 0.8f, true, false);
                MutableObjectIterator sortedData = sorter.getIterator();
                reader.close();
                verifyReader = new BufferedReader(new FileReader(sorted));
                StringValueTupleReaderMutableObjectIterator verifyIterator = new StringValueTupleReaderMutableObjectIterator(verifyReader);
                Tuple2 nextVerify = new Tuple2((Object)new StringValue(), (Object)new StringValue[0]);
                Tuple2 nextFromFlinkSort = new Tuple2((Object)new StringValue(), (Object)new StringValue[0]);
                int num = 0;
                while ((nextVerify = (Tuple2)verifyIterator.next(nextVerify)) != null) {
                    ++num;
                    nextFromFlinkSort = (Tuple2)sortedData.next((Object)nextFromFlinkSort);
                    Assert.assertNotNull((Object)nextFromFlinkSort);
                    Assert.assertEquals((Object)nextVerify.f0, (Object)nextFromFlinkSort.f0);
                    Assert.assertArrayEquals((Object[])((Object[])nextVerify.f1), (Object[])((Object[])nextFromFlinkSort.f1));
                }
                Assert.assertNull((Object)sortedData.next((Object)nextFromFlinkSort));
                Assert.assertEquals((long)300000L, (long)num);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (verifyReader != null) {
                    verifyReader.close();
                }
                if (sorter != null) {
                    sorter.close();
                }
                if (mm != null) {
                    mm.shutdown();
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (input != null) {
                input.delete();
            }
            if (sorted != null) {
                sorted.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generateFileWithStrings(int numStrings, String prefix) throws IOException {
        Random rnd = new Random(347569784659278346L);
        StringBuilder bld = new StringBuilder();
        int resetValue = prefix.length();
        bld.append(prefix);
        File f = File.createTempFile("strings", "txt");
        try (BufferedWriter wrt = null;){
            wrt = new BufferedWriter(new FileWriter(f));
            for (int i = 0; i < numStrings; ++i) {
                bld.setLength(resetValue);
                int len = rnd.nextInt(20) + 300;
                for (int k = 0; k < len; ++k) {
                    char c = (char)(rnd.nextInt(80) + 40);
                    bld.append(c);
                }
                String str = bld.toString();
                wrt.write(str);
                wrt.newLine();
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generateFileWithStringTuples(int numStrings, String prefix) throws IOException {
        Random rnd = new Random(347569784659278346L);
        StringBuilder bld = new StringBuilder();
        File f = File.createTempFile("strings", "txt");
        try (BufferedWriter wrt = null;){
            wrt = new BufferedWriter(new FileWriter(f));
            for (int i = 0; i < numStrings; ++i) {
                bld.setLength(0);
                int numComps = rnd.nextInt(5) + 1;
                for (int z = 0; z < numComps; ++z) {
                    if (z > 0) {
                        bld.append(' ');
                    }
                    bld.append(prefix);
                    int len = rnd.nextInt(20) + 10;
                    for (int k = 0; k < len; ++k) {
                        char c = (char)(rnd.nextInt(80) + 40);
                        bld.append(c);
                    }
                }
                String str = bld.toString();
                wrt.write(str);
                wrt.newLine();
            }
        }
        return f;
    }

    public static void main(String[] args) {
        new MassiveStringValueSorting().testStringValueSorting();
        new MassiveStringValueSorting().testStringValueTuplesSorting();
    }

    private static final class StringValueTupleReaderMutableObjectIterator
    implements MutableObjectIterator<Tuple2<StringValue, StringValue[]>> {
        private final BufferedReader reader;

        public StringValueTupleReaderMutableObjectIterator(BufferedReader reader) {
            this.reader = reader;
        }

        public Tuple2<StringValue, StringValue[]> next(Tuple2<StringValue, StringValue[]> reuse) throws IOException {
            String line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            String[] parts = line.split(" ");
            ((StringValue)reuse.f0).setValue((CharSequence)parts[0]);
            reuse.f1 = new StringValue[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                ((StringValue[])reuse.f1)[i] = new StringValue((CharSequence)parts[i]);
            }
            return reuse;
        }

        public Tuple2<StringValue, StringValue[]> next() throws IOException {
            return this.next((Tuple2<StringValue, StringValue[]>)new Tuple2((Object)new StringValue(), (Object)new StringValue[0]));
        }
    }

    private static final class StringValueReaderMutableObjectIterator
    implements MutableObjectIterator<StringValue> {
        private final BufferedReader reader;

        public StringValueReaderMutableObjectIterator(BufferedReader reader) {
            this.reader = reader;
        }

        public StringValue next(StringValue reuse) throws IOException {
            String line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            reuse.setValue((CharSequence)line);
            return reuse;
        }

        public StringValue next() throws IOException {
            return this.next(new StringValue());
        }
    }
}

