/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.misc;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;

public class GenericTypeInfoTest {
    @Test
    public void testSerializerTree() {
        TypeInformation ti = TypeExtractor.createTypeInfo(CollectionDataSets.PojoWithCollectionGeneric.class);
        String serTree = Utils.getSerializerTree((TypeInformation)ti).replaceAll("(java\\.lang\\.String\\R)( {12}\\S*\\R)+", "$1").replaceAll("( {4}[a-zA-Z]+:java\\.math\\.BigInteger\\R)( {8}\\S*\\R)+", "$1").replaceAll("( {8}[a-zA-Z]+:java\\.math\\.BigInteger\\R)( {12}\\S*\\R)+", "$1");
        Assert.assertThat((Object)serTree, (Matcher)IsEqual.equalTo((Object)"GenericTypeInfo (PojoWithCollectionGeneric)\n    pojos:java.util.List\n    key:int\n    sqlDate:java.sql.Date\n    bigInt:java.math.BigInteger\n    bigDecimalKeepItNull:java.math.BigDecimal\n        intVal:java.math.BigInteger\n        scale:int\n    scalaBigInt:scala.math.BigInt\n        bigInteger:java.math.BigInteger\n    mixed:java.util.List\n    makeMeGeneric:org.apache.flink.test.operators.util.CollectionDataSets$PojoWithDateAndEnum\n        group:java.lang.String\n        date:java.util.Date\n        cat:org.apache.flink.test.operators.util.CollectionDataSets$Category (is enum)\n"));
    }
}

