/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.optimizer.examples;

import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.junit.Assert;
import org.junit.Test;

public class WordCountCompilerTest
extends CompilerTestBase {
    private static final long serialVersionUID = 8988304231385358228L;

    @Test
    public void testWordCount() {
        this.checkWordCount(true);
        this.checkWordCount(false);
    }

    private void checkWordCount(boolean estimates) {
        OptimizedPlan plan;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(8);
        Operator lines = env.readTextFile(IN_FILE).name("Input Lines");
        ((AggregateOperator)((MapOperator)lines.map((MapFunction)new MapFunction<String, Tuple2<String, Integer>>(){
            private static final long serialVersionUID = -3952739820618875030L;

            public Tuple2<String, Integer> map(String v) throws Exception {
                return new Tuple2((Object)v, (Object)1);
            }
        }).name("Tokenize Lines")).groupBy(new int[]{0}).sum(1).name("Count Words")).output((OutputFormat)new DiscardingOutputFormat()).name("Word Counts");
        Plan p = env.createProgramPlan();
        p.setExecutionConfig(new ExecutionConfig());
        if (estimates) {
            GenericDataSourceBase source = (GenericDataSourceBase)WordCountCompilerTest.getContractResolver((Plan)p).getNode("Input Lines");
            this.setSourceStatistics(source, 0x10000000000L, 24.0f);
            plan = this.compileWithStats(p);
        } else {
            plan = this.compileNoStats(p);
        }
        CompilerTestBase.OptimizerPlanNodeResolver resolver = WordCountCompilerTest.getOptimizerPlanNodeResolver((OptimizedPlan)plan);
        SinkPlanNode sink = (SinkPlanNode)resolver.getNode("Word Counts");
        SingleInputPlanNode reducer = (SingleInputPlanNode)resolver.getNode("Count Words");
        SingleInputPlanNode mapper = (SingleInputPlanNode)resolver.getNode("Tokenize Lines");
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)mapper.getInput().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)reducer.getInput().getShipStrategy());
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
        Channel c = reducer.getInput();
        Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)c.getLocalStrategy());
        FieldList l = new FieldList(0);
        Assert.assertEquals((Object)l, (Object)c.getShipStrategyKeys());
        Assert.assertEquals((Object)l, (Object)c.getLocalStrategyKeys());
        Assert.assertTrue((boolean)Arrays.equals(c.getLocalStrategySortOrder(), reducer.getSortOrders(0)));
        SingleInputPlanNode combiner = (SingleInputPlanNode)reducer.getPredecessor();
        Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_COMBINE, (Object)combiner.getDriverStrategy());
        Assert.assertEquals((Object)l, (Object)combiner.getKeys(0));
        Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
    }
}

