/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.optimizer.jsonplan;

import java.util.List;
import org.apache.flink.api.common.Plan;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.client.program.PreviewPlanEnvironment;
import org.apache.flink.examples.java.clustering.KMeans;
import org.apache.flink.examples.java.graph.ConnectedComponents;
import org.apache.flink.examples.java.graph.PageRank;
import org.apache.flink.examples.java.relational.TPCHQuery3;
import org.apache.flink.examples.java.relational.WebLogAnalysis;
import org.apache.flink.examples.java.wordcount.WordCount;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParseException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.junit.Assert;
import org.junit.Test;

public class PreviewPlanDumpTest
extends CompilerTestBase {
    @Test
    public void dumpWordCount() {
        PreviewPlanEnvironment env = new PreviewPlanEnvironment();
        env.setAsContext();
        try {
            WordCount.main((String[])new String[]{"--input", IN_FILE, "--output", OUT_FILE});
        }
        catch (OptimizerPlanEnvironment.ProgramAbortException programAbortException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"WordCount failed with an exception");
        }
        this.dump(env.getPlan());
    }

    @Test
    public void dumpTPCH3() {
        PreviewPlanEnvironment env = new PreviewPlanEnvironment();
        env.setAsContext();
        try {
            TPCHQuery3.main((String[])new String[]{"--lineitem", IN_FILE, "--customer", IN_FILE, "--orders", OUT_FILE, "--output", "123"});
        }
        catch (OptimizerPlanEnvironment.ProgramAbortException programAbortException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"TPCH3 failed with an exception");
        }
        this.dump(env.getPlan());
    }

    @Test
    public void dumpIterativeKMeans() {
        PreviewPlanEnvironment env = new PreviewPlanEnvironment();
        env.setAsContext();
        try {
            KMeans.main((String[])new String[]{"--points ", IN_FILE, "--centroids ", IN_FILE, "--output ", OUT_FILE, "--iterations", "123"});
        }
        catch (OptimizerPlanEnvironment.ProgramAbortException programAbortException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"KMeans failed with an exception");
        }
        this.dump(env.getPlan());
    }

    @Test
    public void dumpWebLogAnalysis() {
        PreviewPlanEnvironment env = new PreviewPlanEnvironment();
        env.setAsContext();
        try {
            WebLogAnalysis.main((String[])new String[]{"--documents", IN_FILE, "--ranks", IN_FILE, "--visits", OUT_FILE, "--output", "123"});
        }
        catch (OptimizerPlanEnvironment.ProgramAbortException programAbortException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"WebLogAnalysis failed with an exception");
        }
        this.dump(env.getPlan());
    }

    @Test
    public void dumpBulkIterationKMeans() {
        PreviewPlanEnvironment env = new PreviewPlanEnvironment();
        env.setAsContext();
        try {
            ConnectedComponents.main((String[])new String[]{"--vertices", IN_FILE, "--edges", IN_FILE, "--output", OUT_FILE, "--iterations", "123"});
        }
        catch (OptimizerPlanEnvironment.ProgramAbortException programAbortException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"ConnectedComponents failed with an exception");
        }
        this.dump(env.getPlan());
    }

    @Test
    public void dumpPageRank() {
        PreviewPlanEnvironment env = new PreviewPlanEnvironment();
        env.setAsContext();
        try {
            PageRank.main((String[])new String[]{"--pages", IN_FILE, "--links", IN_FILE, "--output", OUT_FILE, "--numPages", "10", "--iterations", "123"});
        }
        catch (OptimizerPlanEnvironment.ProgramAbortException programAbortException) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"PageRank failed with an exception");
        }
        this.dump(env.getPlan());
    }

    private void dump(Plan p) {
        try {
            List sinks = Optimizer.createPreOptimizedPlan((Plan)p);
            PlanJSONDumpGenerator dumper = new PlanJSONDumpGenerator();
            String json = dumper.getPactPlanAsJSON(sinks);
            try (JsonParser parser = new JsonFactory().createParser(json);){
                while (parser.nextToken() != null) {
                }
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            Assert.fail((String)("JSON Generator produced malformatted output: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An error occurred in the test: " + e.getMessage()));
        }
    }
}

