/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.recovery;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.LocalCollectionOutputFormat;
import org.apache.flink.runtime.client.JobExecutionException;
import org.junit.Assert;
import org.junit.Test;

public abstract class SimpleRecoveryITCaseBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedRunThenSuccessfulRun() throws Exception {
        try {
            ArrayList resultCollection = new ArrayList();
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(4);
            env.setRestartStrategy(RestartStrategies.noRestart());
            env.getConfig().disableSysoutLogging();
            env.generateSequence(1L, 10L).rebalance().map(new FailingMapper1()).reduce((ReduceFunction)new ReduceFunction<Long>(){

                public Long reduce(Long value1, Long value2) {
                    return value1 + value2;
                }
            }).output((OutputFormat)new LocalCollectionOutputFormat(resultCollection));
            try {
                JobExecutionResult res = env.execute();
                String msg = res == null ? "null result" : "result in " + res.getNetRuntime() + " ms";
                Assert.fail((String)("The program should have failed, but returned " + msg));
            }
            catch (JobExecutionException res) {
                // empty catch block
            }
            env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(4);
            env.setRestartStrategy(RestartStrategies.noRestart());
            env.getConfig().disableSysoutLogging();
            env.generateSequence(1L, 10L).rebalance().map(new FailingMapper1()).reduce((ReduceFunction)new ReduceFunction<Long>(){

                public Long reduce(Long value1, Long value2) {
                    return value1 + value2;
                }
            }).output((OutputFormat)new LocalCollectionOutputFormat(resultCollection));
            this.executeAndRunAssertions(env);
            long sum = 0L;
            Iterator iterator = resultCollection.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                sum += l;
            }
            Assert.assertEquals((long)55L, (long)sum);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FailingMapper1.failuresBeforeSuccess = 1;
        }
    }

    private void executeAndRunAssertions(ExecutionEnvironment env) throws Exception {
        try {
            JobExecutionResult result = env.execute();
            Assert.assertTrue((result.getNetRuntime() >= 0L ? 1 : 0) != 0);
            Assert.assertNotNull((Object)result.getAllAccumulatorResults());
            Assert.assertTrue((boolean)result.getAllAccumulatorResults().isEmpty());
        }
        catch (JobExecutionException e) {
            Assert.fail((String)"The program should have succeeded on the second run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestart() {
        try {
            ArrayList resultCollection = new ArrayList();
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(4);
            env.getConfig().disableSysoutLogging();
            env.generateSequence(1L, 10L).rebalance().map(new FailingMapper2()).reduce((ReduceFunction)new ReduceFunction<Long>(){

                public Long reduce(Long value1, Long value2) {
                    return value1 + value2;
                }
            }).output((OutputFormat)new LocalCollectionOutputFormat(resultCollection));
            this.executeAndRunAssertions(env);
            long sum = 0L;
            Iterator iterator = resultCollection.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                sum += l;
            }
            Assert.assertEquals((long)55L, (long)sum);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FailingMapper2.failuresBeforeSuccess = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartMultipleTimes() {
        try {
            ArrayList resultCollection = new ArrayList();
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            env.setParallelism(4);
            env.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)5, (long)100L));
            env.getConfig().disableSysoutLogging();
            env.generateSequence(1L, 10L).rebalance().map(new FailingMapper3()).reduce((ReduceFunction)new ReduceFunction<Long>(){

                public Long reduce(Long value1, Long value2) {
                    return value1 + value2;
                }
            }).output((OutputFormat)new LocalCollectionOutputFormat(resultCollection));
            this.executeAndRunAssertions(env);
            long sum = 0L;
            Iterator iterator = resultCollection.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                sum += l;
            }
            Assert.assertEquals((long)55L, (long)sum);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FailingMapper3.failuresBeforeSuccess = 3;
        }
    }

    private static class FailingMapper3<T>
    extends RichMapFunction<T, T> {
        private static volatile int failuresBeforeSuccess = 3;

        private FailingMapper3() {
        }

        public T map(T value) throws Exception {
            if (failuresBeforeSuccess > 0 && this.getRuntimeContext().getIndexOfThisSubtask() == 1) {
                --failuresBeforeSuccess;
                throw new Exception("Test Failure");
            }
            return value;
        }
    }

    private static class FailingMapper2<T>
    extends RichMapFunction<T, T> {
        private static volatile int failuresBeforeSuccess = 1;

        private FailingMapper2() {
        }

        public T map(T value) throws Exception {
            if (failuresBeforeSuccess > 0 && this.getRuntimeContext().getIndexOfThisSubtask() == 1) {
                --failuresBeforeSuccess;
                throw new Exception("Test Failure");
            }
            return value;
        }
    }

    private static class FailingMapper1<T>
    extends RichMapFunction<T, T> {
        private static volatile int failuresBeforeSuccess = 1;

        private FailingMapper1() {
        }

        public T map(T value) throws Exception {
            if (failuresBeforeSuccess > 0 && this.getRuntimeContext().getIndexOfThisSubtask() == 1) {
                --failuresBeforeSuccess;
                throw new Exception("Test Failure");
            }
            return value;
        }
    }
}

