/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.runtime;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SchedulingITCase
extends TestLogger {
    @Test
    public void testDisablingLocalRecovery() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setBoolean(CheckpointingOptions.LOCAL_RECOVERY, false);
        this.executeSchedulingTest(configuration);
    }

    @Test
    public void testLocalRecoveryFull() throws Exception {
        this.testLocalRecoveryInternal("full");
    }

    @Test
    public void testLocalRecoveryRegion() throws Exception {
        this.testLocalRecoveryInternal("region");
    }

    private void testLocalRecoveryInternal(String failoverStrategyValue) throws Exception {
        Configuration configuration = new Configuration();
        configuration.setBoolean(CheckpointingOptions.LOCAL_RECOVERY, true);
        configuration.setString(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY.key(), failoverStrategyValue);
        this.executeSchedulingTest(configuration);
    }

    private void executeSchedulingTest(Configuration configuration) throws Exception {
        configuration.setString(RestOptions.BIND_PORT, "0");
        long slotIdleTimeout = 50L;
        configuration.setLong(JobManagerOptions.SLOT_IDLE_TIMEOUT, 50L);
        int parallelism = 4;
        MiniClusterConfiguration miniClusterConfiguration = new MiniClusterConfiguration.Builder().setConfiguration(configuration).setNumTaskManagers(4).setNumSlotsPerTaskManager(1).build();
        try (MiniCluster miniCluster = new MiniCluster(miniClusterConfiguration);){
            miniCluster.start();
            MiniClusterClient miniClusterClient = new MiniClusterClient(configuration, miniCluster);
            JobGraph jobGraph = this.createJobGraph(100L, 4);
            CompletableFuture submissionFuture = miniClusterClient.submitJob(jobGraph);
            JobSubmissionResult jobSubmissionResult = (JobSubmissionResult)submissionFuture.get();
            CompletableFuture resultFuture = miniClusterClient.requestJobResult(jobSubmissionResult.getJobID());
            JobResult jobResult = (JobResult)resultFuture.get();
            Assert.assertThat((Object)jobResult.getSerializedThrowable().isPresent(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Nonnull
    private JobGraph createJobGraph(long delay, int parallelism) throws IOException {
        SlotSharingGroup slotSharingGroup = new SlotSharingGroup();
        JobVertex source = new JobVertex("source");
        source.setInvokableClass(OneTimeFailingInvokable.class);
        source.setParallelism(parallelism);
        source.setSlotSharingGroup(slotSharingGroup);
        JobVertex sink = new JobVertex("sink");
        sink.setInvokableClass(NoOpInvokable.class);
        sink.setParallelism(parallelism);
        sink.setSlotSharingGroup(slotSharingGroup);
        sink.connectNewDataSetAsInput(source, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        JobGraph jobGraph = new JobGraph(new JobVertex[]{source, sink});
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)1, (long)delay));
        jobGraph.setExecutionConfig(executionConfig);
        return jobGraph;
    }

    public static final class OneTimeFailingInvokable
    extends AbstractInvokable {
        private static final AtomicBoolean hasFailed = new AtomicBoolean(false);

        public OneTimeFailingInvokable(Environment environment) {
            super(environment);
        }

        public void invoke() throws Exception {
            if (hasFailed.compareAndSet(false, true)) {
                throw new FlinkException("One time failure.");
            }
        }
    }
}

