/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.IOException;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.runtime.operators.testutils.UniformIntTupleGenerator;

public class UniformIntTupleGeneratorInputFormat
extends GenericInputFormat<Tuple2<Integer, Integer>> {
    private final int keyTotal;
    private final int valueTotal;
    private int valueCount = 0;
    private UniformIntTupleGenerator generator;

    public UniformIntTupleGeneratorInputFormat(int numKeys, int numVals) {
        this.keyTotal = numKeys;
        this.valueTotal = numVals;
    }

    public void open(GenericInputSplit split) throws IOException {
        super.open(split);
        this.generator = new UniformIntTupleGenerator(this.keyTotal, this.valueTotal, false);
    }

    public boolean reachedEnd() throws IOException {
        return this.valueCount >= this.valueTotal;
    }

    public Tuple2<Integer, Integer> nextRecord(Tuple2<Integer, Integer> reuse) throws IOException {
        ++this.valueCount;
        return this.generator.next();
    }
}

