/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.windowing.sessionwindows;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.test.windowing.sessionwindows.EventGenerator;
import org.apache.flink.test.windowing.sessionwindows.GeneratorConfiguration;
import org.apache.flink.test.windowing.sessionwindows.GeneratorEventFactory;
import org.apache.flink.test.windowing.sessionwindows.LongRandomGenerator;
import org.apache.flink.test.windowing.sessionwindows.SessionConfiguration;
import org.apache.flink.test.windowing.sessionwindows.SessionEventGeneratorImpl;
import org.apache.flink.test.windowing.sessionwindows.SessionGeneratorConfiguration;
import org.apache.flink.util.Preconditions;

public class EventGeneratorFactory<K, E> {
    private final Map<K, EventGenerator<K, E>> latestGeneratorsByKey;
    private final LongRandomGenerator randomGenerator;
    private final GeneratorConfiguration generatorConfiguration;
    private final GeneratorEventFactory<K, E> eventFactory;
    private final int timelyEventsPerSession;
    private final long maxSessionEventGap;
    private int producedGeneratorsCount;

    public EventGeneratorFactory(GeneratorConfiguration generatorConfiguration, GeneratorEventFactory<K, E> eventFactory, long sessionTimeout, int timelyEventsPerSession, LongRandomGenerator randomGenerator) {
        Preconditions.checkNotNull((Object)generatorConfiguration);
        Preconditions.checkNotNull((Object)randomGenerator);
        Preconditions.checkArgument((sessionTimeout >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((timelyEventsPerSession >= 0 ? 1 : 0) != 0);
        this.latestGeneratorsByKey = new HashMap<K, EventGenerator<K, E>>();
        this.generatorConfiguration = generatorConfiguration;
        this.eventFactory = eventFactory;
        this.randomGenerator = randomGenerator;
        this.maxSessionEventGap = sessionTimeout;
        this.timelyEventsPerSession = timelyEventsPerSession;
        this.producedGeneratorsCount = 0;
    }

    public EventGenerator<K, E> newSessionGeneratorForKey(K key, long globalWatermark) {
        EventGenerator<K, E> eventGenerator = this.latestGeneratorsByKey.get(key);
        if (eventGenerator == null) {
            SessionConfiguration<K, E> sessionConfiguration = SessionConfiguration.of(key, 0, this.maxSessionEventGap, globalWatermark, this.timelyEventsPerSession, this.eventFactory);
            SessionGeneratorConfiguration<K, E> sessionGeneratorConfiguration = new SessionGeneratorConfiguration<K, E>(sessionConfiguration, this.generatorConfiguration);
            eventGenerator = new SessionEventGeneratorImpl<K, E>(sessionGeneratorConfiguration, this.randomGenerator);
        } else {
            eventGenerator = eventGenerator.getNextGenerator(globalWatermark);
        }
        this.latestGeneratorsByKey.put(key, eventGenerator);
        ++this.producedGeneratorsCount;
        return eventGenerator;
    }

    public int getProducedGeneratorsCount() {
        return this.producedGeneratorsCount;
    }
}

